/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2SkillLearn;

public class SkillTreeTable {
    private static Logger _log = Logger.getLogger(SkillTreeTable.class.getName());
    private static final SkillTreeTable _instance = new SkillTreeTable();
    private HashMap<ClassId, ArrayList<L2SkillLearn>> _skillTrees = new HashMap();

    public static SkillTreeTable getInstance() {
        return _instance;
    }

    public static int getExpertiseLevel(int grade) {
        if (grade <= 0) {
            return 0;
        }
        ArrayList<L2SkillLearn> lst = SkillTreeTable._instance._skillTrees.get((Object)ClassId.paladin);
        for (L2SkillLearn sl : lst) {
            if (sl.getId() != 239 || sl.getLevel() != grade) continue;
            return sl.getMinLevel();
        }
        throw new Error("Expertise not found for grade " + grade);
    }

    public static int getMinSkillLevel(int skillID, ClassId classID, int skillLVL) {
        if (skillID > 0 && classID instanceof ClassId && skillLVL > 0) {
            ArrayList<L2SkillLearn> lst = SkillTreeTable._instance._skillTrees.get((Object)classID);
            for (L2SkillLearn sl : lst) {
                if (sl.getLevel() != skillLVL || sl.getId() != skillID) continue;
                return sl.getMinLevel();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkillTreeTable() {
        int classId = 0;
        int count = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM class_list ORDER BY id");
            ResultSet classlist = statement.executeQuery();
            ArrayList<L2SkillLearn> list = new ArrayList<L2SkillLearn>();
            while (classlist.next()) {
                list = new ArrayList();
                int parentClassId = classlist.getInt("parent_id");
                classId = classlist.getInt("id");
                PreparedStatement statement2 = con.prepareStatement("SELECT class_id, skill_id, level, name, sp, min_level FROM skill_trees where class_id=? ORDER BY skill_id, level");
                statement2.setInt(1, classId);
                ResultSet skilltree = statement2.executeQuery();
                if (parentClassId != -1) {
                    ArrayList<L2SkillLearn> parentList = this._skillTrees.get((Object)ClassId.values()[parentClassId]);
                    list.addAll(parentList);
                }
                int prev_skill_id = -1;
                while (skilltree.next()) {
                    int id = skilltree.getInt("skill_id");
                    int lvl = skilltree.getInt("level");
                    String name = skilltree.getString("name");
                    int minLvl = skilltree.getInt("min_level");
                    int cost = skilltree.getInt("sp");
                    if (prev_skill_id != id) {
                        prev_skill_id = id;
                    }
                    L2SkillLearn skill = new L2SkillLearn(id, lvl, minLvl, name, cost);
                    list.add(skill);
                }
                this._skillTrees.put(ClassId.values()[classId], list);
                skilltree.close();
                statement2.close();
                count += list.size();
                _log.fine("SkillTreeTable: skill tree for class " + classId + " has " + list.size() + " skills");
            }
            classlist.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "error while creating skill tree for classId " + classId, e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        _log.config("SkillTreeTable: Loaded " + count + " skills.");
    }

    public L2SkillLearn[] getAvailableSkills(L2PcInstance cha, ClassId classId) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        ArrayList<L2SkillLearn> skills = this._skillTrees.get((Object)classId);
        if (skills == null) {
            _log.warning("Skilltree for class " + (Object)((Object)classId) + " is not defined !");
            return new L2SkillLearn[0];
        }
        L2Skill[] oldSkills = cha.getAllSkills();
        for (int i = 0; i < skills.size(); ++i) {
            L2SkillLearn temp = skills.get(i);
            if (temp.getMinLevel() > cha.getLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getId()) continue;
                knownSkill = true;
                if (oldSkills[j].getLevel() != temp.getLevel() - 1) continue;
                result.add(temp);
            }
            if (knownSkill || temp.getLevel() != 1) continue;
            result.add(temp);
        }
        return result.toArray(new L2SkillLearn[result.size()]);
    }

    public int getSkillCost(L2PcInstance player, L2Skill skill) {
        int min = 100000000;
        int lvl = player.getSkillLevel(skill.getId());
        lvl = lvl > 0 ? ++lvl : 1;
        for (ClassId classId : this._skillTrees.keySet()) {
            if (classId.level() != player.getClassId().level()) continue;
            ArrayList<L2SkillLearn> lst = this._skillTrees.get((Object)classId);
            for (L2SkillLearn sl : lst) {
                if (sl.getId() != skill.getId() || sl.getLevel() != lvl || sl.getMinLevel() > player.getLevel()) continue;
                float cost = sl.getSpCost();
                if (!player.getClassId().equalsOrChildOf(classId)) {
                    if (skill.getCrossLearnAdd() < 0) continue;
                    cost += (float)skill.getCrossLearnAdd();
                    cost *= skill.getCrossLearnMul();
                }
                if (classId.getRace() != player.getRace()) {
                    cost *= skill.getCrossLearnRace();
                }
                if (classId.isMage() != player.getClassId().isMage()) {
                    cost *= skill.getCrossLearnProf();
                }
                min = Math.min(min, Math.round(cost));
            }
        }
        return min;
    }
}

