/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.skills.SkillsEngine;
import net.sf.l2j.gameserver.templates.L2WeaponType;

public class SkillTable {
    private static Logger _log = Logger.getLogger(SkillTable.class.getName());
    private static SkillTable _instance;
    private HashMap<Integer, L2Skill> _skills = new HashMap();
    private boolean _initialized = true;
    private static final L2WeaponType[] weaponDbMasks;

    public static SkillTable getInstance() {
        if (_instance == null) {
            _instance = new SkillTable();
        }
        return _instance;
    }

    private SkillTable() {
        SkillsEngine.getInstance().loadAllSkills(this._skills);
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public L2Skill getInfo(int magicId, int level) {
        return this._skills.get(magicId * 100 + level);
    }

    public int calcWeaponsAllowed(int mask) {
        if (mask == 0) {
            return 0;
        }
        int weaponsAllowed = 0;
        for (int i = 0; i < weaponDbMasks.length; ++i) {
            if ((mask & 1 << i) == 0) continue;
            weaponsAllowed |= weaponDbMasks[i].mask();
        }
        return weaponsAllowed;
    }

    static {
        weaponDbMasks = new L2WeaponType[]{L2WeaponType.ETC, L2WeaponType.BOW, L2WeaponType.POLE, L2WeaponType.DUALFIST, L2WeaponType.DUAL, L2WeaponType.BLUNT, L2WeaponType.SWORD, L2WeaponType.DAGGER};
    }
}

