/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.Server;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.Universe;
import net.sf.l2j.gameserver.model.L2CastleGuardInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.LeaveWorld;

public class Shutdown
extends Thread {
    private static Logger _log = Logger.getLogger(Shutdown.class.getName());
    private static Shutdown _instance;
    private static Shutdown _counterInstance;
    private int secondsShut;
    private int shutdownMode;
    public static final int SIGTERM = 0;
    public static final int GM_SHUTDOWN = 1;
    public static final int GM_RESTART = 2;
    public static final int ABORT = 3;
    private static String[] _modeText;

    public Shutdown() {
        this.secondsShut = -1;
        this.shutdownMode = 0;
    }

    public Shutdown(int seconds, boolean restart) {
        if (seconds < 0) {
            seconds = 0;
        }
        this.secondsShut = seconds;
        this.shutdownMode = restart ? 2 : 1;
    }

    public static Shutdown getInstance() {
        if (_instance == null) {
            _instance = new Shutdown();
        }
        return _instance;
    }

    public void run() {
        if (this == _instance) {
            try {
                Server.loginServer.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                ClientScheduler.getInstance().closeAll();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.saveData();
            try {
                Server.gameServer.getSelectorThread().interrupt();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                L2DatabaseFactory.getInstance().shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Shutdown._instance.shutdownMode == 2) {
                Runtime.getRuntime().halt(2);
            } else {
                Runtime.getRuntime().halt(0);
            }
        } else {
            this.countdown();
            _log.warning("GM shutdown countdown is over. " + _modeText[this.shutdownMode] + " NOW!");
            switch (this.shutdownMode) {
                case 1: {
                    _instance.setMode(1);
                    System.exit(0);
                    break;
                }
                case 2: {
                    _instance.setMode(2);
                    System.exit(2);
                }
            }
        }
    }

    public void startShutdown(L2PcInstance activeChar, int seconds, boolean restart) {
        Announcements _an = Announcements.getInstance();
        _log.warning("GM: " + activeChar.getObjectId() + " issued shutdown command. " + _modeText[this.shutdownMode] + " in " + seconds + " seconds!");
        _an.announceToAll("Server is " + _modeText[this.shutdownMode] + " in " + seconds + " seconds!");
        if (_counterInstance != null) {
            _counterInstance._abort();
        }
        _counterInstance = new Shutdown(seconds, restart);
        _counterInstance.start();
    }

    public void abort(L2PcInstance activeChar) {
        Announcements _an = Announcements.getInstance();
        _log.warning("GM: " + activeChar.getObjectId() + " issued shutdown ABORT. " + _modeText[this.shutdownMode] + " has been stopped!");
        _an.announceToAll("Server aborts " + _modeText[this.shutdownMode] + " and continues normal operation!");
        if (_counterInstance != null) {
            _counterInstance._abort();
        }
    }

    private void setMode(int mode) {
        this.shutdownMode = mode;
    }

    private void _abort() {
        this.shutdownMode = 3;
    }

    private void countdown() {
        Announcements _an = Announcements.getInstance();
        try {
            while (this.secondsShut > 0) {
                switch (this.secondsShut) {
                    case 540: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 9 minutes.");
                        break;
                    }
                    case 480: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 8 minutes.");
                        break;
                    }
                    case 420: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 7 minutes.");
                        break;
                    }
                    case 360: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 6 minutes.");
                        break;
                    }
                    case 300: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 5 minutes.");
                        break;
                    }
                    case 240: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 4 minutes.");
                        break;
                    }
                    case 180: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 3 minutes.");
                        break;
                    }
                    case 120: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 2 minutes.");
                        break;
                    }
                    case 60: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 1 minute.");
                        break;
                    }
                    case 30: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 30 seconds.");
                        break;
                    }
                    case 5: {
                        _an.announceToAll("The server is " + _modeText[this.shutdownMode] + " in 5 seconds, please delog NOW !");
                    }
                }
                --this.secondsShut;
                int delay = 1000;
                Thread.sleep(delay);
                if (this.shutdownMode != 3) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void saveData() {
        Announcements _an = Announcements.getInstance();
        switch (this.shutdownMode) {
            case 0: {
                System.err.println("SIGTERM received. Shutting down NOW!");
                break;
            }
            case 1: {
                System.err.println("GM shutdown received. Shutting down NOW!");
                break;
            }
            case 2: {
                System.err.println("GM restart received. Restarting NOW!");
            }
        }
        if (Config.ACTIVATE_POSITION_RECORDER) {
            Universe.getInstance().implode(true);
        }
        try {
            _an.announceToAll("Server is is " + _modeText[this.shutdownMode] + " NOW! bye bye");
        }
        catch (Throwable t) {
            _log.log(Level.INFO, "", t);
        }
        this.disconnectAllCharacters();
        System.err.println("Data saved. All players disconnected, shutting down.");
        try {
            int delay = 5000;
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void disconnectAllCharacters() {
        for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
            try {
                LeaveWorld ql = new LeaveWorld();
                player.sendPacket(ql);
            }
            catch (Throwable t) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            _log.log(Level.INFO, "", t);
        }
        ArrayList<Integer> guards = L2CastleGuardInstance._castleGuards;
        if (guards != null) {
            while (guards.size() > 0) {
                Integer n = guards.get(0);
                L2Object object = L2World.getInstance().findObject(n);
                L2CastleGuardInstance cg = (L2CastleGuardInstance)object;
                cg.store();
                guards.remove(0);
            }
        }
        for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
            try {
                player.closeNetConnection();
            }
            catch (Throwable t) {}
        }
    }

    static {
        _counterInstance = null;
        _modeText = new String[]{"SIGTERM", "shuting down", "restarting", "aborting"};
    }
}

