/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.BasePacket;
import net.sf.l2j.gameserver.BasePacketQueue;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.Connection;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.serverpackets.LeaveWorld;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public final class SelectorThread
extends Thread {
    private static Logger _log = Logger.getLogger(SelectorThread.class.getName());
    public static SelectorThread instance;
    private final int WRITE_BUF_HASH_SIZE = 4000;
    private final int WRITE_BUF_SIZE = 128;
    private final int SHARED_BUF_SIZE = 65536;
    private final ByteBuffer[] writeBuffers;
    private int numWriteBuffers;
    private final ByteBuffer sharedWriteBuffer;
    private final ByteBuffer sharedReadBuffer;
    private BasePacketQueue sendMsgQueue;
    private BasePacketQueue recvMsgQueue;
    private Selector _selector;
    private final String _hostname;
    private final int _port;
    private int msgCounter;
    HashMap clients = new HashMap();

    public SelectorThread(String hostname, int port) {
        super("NIO Selector");
        if (Config.ASSERT) assert (instance == null);
        instance = this;
        this._hostname = hostname;
        this._port = port;
        this.setDaemon(true);
        this.setPriority(6);
        this.writeBuffers = new ByteBuffer[4000];
        for (int i = 0; i < 4000; ++i) {
            this.writeBuffers[i] = ByteBuffer.allocate(128);
            this.writeBuffers[i].order(ByteOrder.LITTLE_ENDIAN);
            this.writeBuffers[i].clear();
            if (Config.ASSERT) assert (this.writeBuffers[i].capacity() == 128);
        }
        this.numWriteBuffers = 4000;
        this.sharedWriteBuffer = ByteBuffer.allocate(65536);
        this.sharedReadBuffer = ByteBuffer.allocate(65536);
        this.sharedWriteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.sharedReadBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.sendMsgQueue = new BasePacketQueue();
        this.recvMsgQueue = new BasePacketQueue();
    }

    private ByteBuffer allocateBuffer(int sz) {
        if (Config.ASSERT) assert (Thread.currentThread() == this);
        if (sz <= 128 && this.numWriteBuffers > 0) {
            ByteBuffer b = this.writeBuffers[--this.numWriteBuffers];
            if (Config.ASSERT) assert (b.position() == 0);
            if (Config.ASSERT) assert (b.capacity() == 128);
            if (Config.ASSERT) assert (b.limit() >= sz);
            return b;
        }
        ByteBuffer b = ByteBuffer.allocate(sz);
        b.order(ByteOrder.LITTLE_ENDIAN);
        if (Config.ASSERT) assert (b.position() == 0);
        if (Config.ASSERT) assert (b.limit() == sz);
        if (Config.ASSERT) assert (b.capacity() == sz);
        return b;
    }

    private void releaseBuffer(ByteBuffer b) {
        if (Config.ASSERT) assert (Thread.currentThread() == this);
        if (Config.ASSERT) assert (b != null);
        if (b.capacity() == 128 && this.numWriteBuffers <= 3999) {
            b.clear();
            if (Config.ASSERT) assert (b.position() == 0);
            if (Config.ASSERT) assert (b.limit() == 128);
            this.writeBuffers[this.numWriteBuffers++] = b;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            this._selector = Selector.open();
            ssc = ServerSocketChannel.open();
            if ("*".equals(this._hostname)) {
                isa = new InetSocketAddress(this._port);
                SelectorThread._log.config("GameServer listening on all available IPs on Port " + this._port);
            } else {
                isa = new InetSocketAddress(this._hostname, this._port);
                SelectorThread._log.config("GameServer listening on IP: " + this._hostname + " Port " + this._port);
            }
            ssc.socket().bind(isa, 100);
            ssc.configureBlocking(false);
            ssc.register(this._selector, 16);
            block12: while (true) {
                this.processOutboudQueue();
                if (this.msgCounter == 0) {
                    this.setPriority(5);
                } else {
                    this.msgCounter = 0;
                }
                if (this.isInterrupted()) {
                    try {
                        this._selector.close();
                    }
                    catch (Throwable t) {
                        SelectorThread._log.log(Level.INFO, "", t);
                    }
                    return;
                }
                numKeys = this._selector.select(50L);
                if (this.isInterrupted()) {
                    try {
                        this._selector.close();
                    }
                    catch (Throwable t) {
                        SelectorThread._log.log(Level.INFO, "", t);
                    }
                    return;
                }
                if (numKeys == 0) continue;
                it = this._selector.selectedKeys().iterator();
                block13: while (true) {
                    if (it.hasNext()) ** break;
                    continue block12;
                    sk = it.next();
                    it.remove();
                    if (!sk.isValid()) continue;
                    readyOps = sk.readyOps();
                    switch (readyOps) {
                        case 4: {
                            this.writeData(sk);
                            continue block13;
                        }
                        case 1: {
                            this.readData(sk);
                            continue block13;
                        }
                        case 5: {
                            this.writeData(sk);
                            this.readData(sk);
                            continue block13;
                        }
                        case 16: {
                            this.acceptConnection(sk);
                            continue block13;
                        }
                    }
                    System.err.println("Impossible readyOps=" + readyOps);
                    SelectorThread._log.severe("Impossible readyOps=" + readyOps);
                    sk.cancel();
                }
                break;
            }
        }
        catch (Throwable t) {
            SelectorThread._log.log(Level.SEVERE, "", t);
            System.exit(1);
            return;
        }
    }

    private void writeData(SelectionKey sk) {
        Connection con = (Connection)sk.attachment();
        try {
            if (!sk.isValid()) {
                this.closeClient(con);
                return;
            }
            ByteBuffer b = con.writeBuffer;
            if (b != null) {
                int r = ((SocketChannel)sk.channel()).write(b);
                if (r < 0) {
                    this.closeClient(con);
                    return;
                }
                if (r > 0) {
                    con.writeTimeStamp = GameTimeController.getGameTicks();
                } else if (GameTimeController.getGameTicks() - con.writeTimeStamp > 300) {
                    this.closeClient(con);
                    return;
                }
                if (b.hasRemaining()) {
                    return;
                }
                con.writeBuffer = null;
                this.releaseBuffer(b);
            }
            sk.interestOps(sk.interestOps() & 0xFFFFFFFB);
        }
        catch (IOException e) {
            _log.info("Error on network write, player disconnected?");
            this.closeClient(con);
        }
        catch (Throwable t) {
            _log.log(Level.INFO, "", t);
            this.closeClient(con);
        }
    }

    private void readData(SelectionKey sk) {
        Connection con = (Connection)sk.attachment();
        try {
            int sz;
            int r;
            ByteBuffer b;
            if (!sk.isValid() || !con.getChannel().isOpen()) {
                this.closeClient(con);
                return;
            }
            if (con.readBuffer != null) {
                b = con.readBuffer;
                if (Config.ASSERT) assert (b.position() >= 2);
            } else {
                b = this.sharedReadBuffer;
                b.clear();
                if (Config.ASSERT) assert (b.position() == 0);
                byte fb = con.readBufferFirstByte;
                if (fb != 0) {
                    b.put(fb);
                    con.readBufferFirstByte = 0;
                }
            }
            if ((r = ((SocketChannel)sk.channel()).read(b)) < 0) {
                this.closeClient(con);
                return;
            }
            if (r == 0) {
                return;
            }
            b.flip();
            boolean parsed = false;
            while ((r = b.remaining()) > 2) {
                sz = b.getShort(b.position()) & 0xFFFF;
                if (Config.ASSERT) assert (sz > 0);
                if (sz > b.remaining() + 2) break;
                this.parse(con, b);
                parsed = true;
            }
            if (!b.hasRemaining()) {
                this.releaseBuffer(b);
                con.readBuffer = null;
                return;
            }
            if (b.remaining() == 1) {
                con.readBufferFirstByte = b.get();
                this.releaseBuffer(b);
                con.readBuffer = null;
                return;
            }
            if (parsed || b == this.sharedReadBuffer) {
                con.readBuffer = null;
                sz = b.getShort() & 0xFFFF;
                con.readBuffer = this.allocateBuffer(sz + 2);
                con.readBuffer.putShort((short)sz).put(b);
                this.releaseBuffer(b);
            }
            return;
        }
        catch (IOException e) {
            _log.info(e.toString());
            this.closeClient(con);
        }
        catch (Throwable t) {
            _log.log(Level.INFO, "", t);
            this.closeClient(con);
        }
    }

    private void parse(Connection con, ByteBuffer buf) throws Throwable {
        try {
            int sz = buf.getShort() & 0xFFFF;
            ByteBuffer b = (ByteBuffer)buf.slice().limit(sz -= 2);
            b.order(ByteOrder.LITTLE_ENDIAN);
            buf.position(buf.position() + sz);
            con.decript(b);
            con.addReceivedMsg(b);
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "", t);
            this.releaseBuffer(buf);
            con.readBuffer = null;
            throw t;
        }
    }

    private boolean pack(ServerBasePacket msg) {
        if (Config.ASSERT) assert (msg.getConnection().writeBuffer == null);
        this.sharedWriteBuffer.clear();
        try {
            boolean ok = msg.write(this.sharedWriteBuffer);
            if (!ok) {
                return false;
            }
        }
        catch (Exception e) {
            this.closeClient(msg.getConnection());
            return false;
        }
        if (Config.ASSERT) assert (this.sharedWriteBuffer.position() == 0);
        if (Config.ASSERT) assert (this.sharedWriteBuffer.limit() >= 3);
        return true;
    }

    private void acceptConnection(SelectionKey sk) {
        try {
            SocketChannel c;
            if (sk.isAcceptable() && (c = ((ServerSocketChannel)sk.channel()).accept()) != null) {
                c.configureBlocking(false);
                c.register(sk.selector(), 5);
                SelectionKey sk2 = c.keyFor(sk.selector());
                ClientThread client = ClientThread.create(c.socket());
                sk2.attach(client.getConnection());
            }
        }
        catch (Throwable t) {
            _log.log(Level.INFO, "", t);
        }
    }

    void sendMessage(ServerBasePacket msg) {
        if (Config.ASSERT) assert (msg.getConnection() != null);
        this.sendMsgQueue.put(msg);
        ++this.msgCounter;
        if (this.msgCounter > 100 || msg instanceof LeaveWorld) {
            this._selector.wakeup();
            if (this.msgCounter > 1000) {
                this.setPriority(6);
            }
        }
    }

    synchronized ClientBasePacket recvMessage() {
        return (ClientBasePacket)this.recvMsgQueue.get();
    }

    private void processOutboudQueue() {
        if (this.sendMsgQueue.isEmpty()) {
            return;
        }
        Iterator<BasePacket> iter = this.sendMsgQueue.iterator();
        while (iter.hasNext()) {
            ServerBasePacket msg = (ServerBasePacket)iter.next();
            Connection con = msg.getConnection();
            SelectionKey sk = con.getChannel().keyFor(this._selector);
            if (sk == null || !sk.isValid()) continue;
            iter.remove();
            if (Config.ASSERT) assert ((sk.interestOps() & 1) != 0);
            if (con.writeBuffer != null) {
                if (Config.ASSERT) assert ((sk.interestOps() & 4) != 0);
                con._sendMsgQueue.put(msg);
                continue;
            }
            boolean ok = this.pack(msg);
            if (!ok) continue;
            int r = 0;
            try {
                r = con.getChannel().write(this.sharedWriteBuffer);
            }
            catch (IOException e) {
                r = -1;
            }
            if (r < 0 || !sk.isValid()) {
                this.closeClient(con);
                return;
            }
            if (this.sharedWriteBuffer.hasRemaining()) {
                ByteBuffer b = this.allocateBuffer(this.sharedWriteBuffer.remaining());
                b.put(this.sharedWriteBuffer);
                b.flip();
                con.writeBuffer = b;
                con.writeTimeStamp = GameTimeController.getGameTicks();
                sk.interestOps(sk.interestOps() | 4);
                continue;
            }
            if (con._sendMsgQueue.isEmpty() || (msg = (ServerBasePacket)con._sendMsgQueue.get()) == null) continue;
            this.sendMsgQueue.put(msg);
        }
    }

    private void closeClient(Connection c) {
        if (c.readBuffer != null) {
            this.releaseBuffer(c.readBuffer);
            c.readBuffer = null;
        }
        if (c.writeBuffer != null) {
            this.releaseBuffer(c.writeBuffer);
            c.writeBuffer = null;
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

