/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.Inventory;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2RecipeInstance;
import net.sf.l2j.gameserver.model.L2RecipeList;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.RecipeBookItemList;
import net.sf.l2j.gameserver.serverpackets.SetupGauge;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RecipeController {
    protected static Logger _log = Logger.getLogger(RecipeController.class.getName());
    private static RecipeController _instance;
    private HashMap<Integer, L2RecipeList> _lists = new HashMap();
    protected static HashMap<L2PcInstance, ReceipeItemMaker> activeMakers;
    protected static final Random _rnd;

    public static RecipeController getInstance() {
        if (_instance == null) {
            _instance = new RecipeController();
        }
        return _instance;
    }

    public RecipeController() {
        String line = null;
        LineNumberReader lnr = null;
        try {
            File recipesData = new File(Config.DATAPACK_ROOT, "data/recipes.csv");
            lnr = new LineNumberReader(new BufferedReader(new FileReader(recipesData)));
            while ((line = lnr.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                this.parseList(line);
            }
            _log.config("RecipeController: Loaded " + this._lists.size() + " Recipes.");
        }
        catch (Exception e) {
            if (lnr != null) {
                _log.log(Level.WARNING, "error while creating recipe controller in linenr: " + lnr.getLineNumber(), e);
            }
            _log.warning("No recipes were found in data folder");
        }
    }

    public int getRecipesCount() {
        return this._lists.size();
    }

    public L2RecipeList getRecipeList(int listId) {
        return this._lists.get(listId);
    }

    public L2RecipeList getRecipeByItemId(int itemId) {
        for (int i = 0; i < this._lists.size(); ++i) {
            L2RecipeList find = this._lists.get(new Integer(i));
            if (find.getRecipeId() != itemId) continue;
            return find;
        }
        return null;
    }

    public synchronized void requestBookOpen(L2PcInstance player) {
        if (!Config.ALT_GAME_CREATION) {
            RecipeBookItemList response = new RecipeBookItemList();
            response.addRecipes(player.getRecipeBook());
            player.sendPacket(response);
            return;
        }
        ReceipeItemMaker maker = activeMakers.get(player);
        if (maker == null) {
            RecipeBookItemList response = new RecipeBookItemList();
            response.addRecipes(player.getRecipeBook());
            player.sendPacket(response);
            return;
        }
        if (maker.timeReady <= GameTimeController.getGameTicks()) {
            maker.run();
            return;
        }
        SystemMessage sm = new SystemMessage(614);
        sm.addString("You are busy creating ");
        sm.addItemName(maker.recipeList.getItemId());
        player.sendPacket(sm);
    }

    public synchronized void requestMakeItem(L2PcInstance player, int receipeListId) {
        L2RecipeList recipeList = this.getRecipeList(receipeListId - 1);
        SystemMessage sm = new SystemMessage(614);
        if (recipeList == null || recipeList.getRecipes().length == 0) {
            sm = new SystemMessage(614);
            sm.addString("No recipe for: " + receipeListId);
            player.sendPacket(sm);
            return;
        }
        if (!Config.ALT_GAME_CREATION) {
            new ReceipeItemMaker(player, recipeList);
        } else {
            ReceipeItemMaker maker = activeMakers.get(player);
            if (maker != null) {
                sm = new SystemMessage(614);
                sm.addString("You are busy creating ");
                sm.addItemName(recipeList.getItemId());
                player.sendPacket(sm);
                return;
            }
            maker = new ReceipeItemMaker(player, recipeList);
            if (maker.isValid) {
                activeMakers.put(player, maker);
            }
        }
    }

    public synchronized void requestMakeItemAbort(L2PcInstance player) {
        activeMakers.remove(player);
    }

    private void parseList(String line) {
        StringTokenizer st = new StringTokenizer(line, ";");
        Vector<L2RecipeInstance> recipePartList = new Vector<L2RecipeInstance>();
        String recipeName = st.nextToken();
        int id = Integer.parseInt(st.nextToken());
        int recipeId = Integer.parseInt(st.nextToken());
        int level = Integer.parseInt(st.nextToken());
        StringTokenizer st2 = new StringTokenizer(st.nextToken(), "[],");
        while (st2.hasMoreTokens()) {
            StringTokenizer st3 = new StringTokenizer(st2.nextToken(), "()");
            int rpItemId = Integer.parseInt(st3.nextToken());
            int quantity = Integer.parseInt(st3.nextToken());
            L2RecipeInstance rp = new L2RecipeInstance(rpItemId, quantity);
            recipePartList.add(rp);
        }
        int itemId = Integer.parseInt(st.nextToken());
        int count = Integer.parseInt(st.nextToken());
        st.nextToken();
        int mpCost = Integer.parseInt(st.nextToken());
        int successRate = Integer.parseInt(st.nextToken());
        L2RecipeList recipeList = new L2RecipeList(id, level, recipeId, recipeName, successRate, mpCost, itemId, count);
        for (L2RecipeInstance recipePart : recipePartList) {
            recipeList.addRecipe(recipePart);
        }
        this._lists.put(new Integer(this._lists.size()), recipeList);
    }

    static {
        activeMakers = new HashMap();
        _rnd = new Random();
    }

    class ReceipeItemMaker
    implements Runnable {
        int timeReady;
        final L2PcInstance player;
        final L2RecipeList recipeList;
        final ArrayList<L2ItemInstance> items;
        int materialsRefPrice;
        int totalItems;
        int usedItems;
        boolean isValid;

        ReceipeItemMaker(L2PcInstance player, L2RecipeList recipeList) {
            L2ItemInstance invItem;
            this.player = player;
            this.recipeList = recipeList;
            this.items = new ArrayList();
            int skillLevel = player.getSkillLevel(172);
            if (skillLevel <= 0) {
                player.sendPacket(new ActionFailed());
                return;
            }
            if (recipeList == null || recipeList.getRecipes().length == 0) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("No such recipe");
                player.sendPacket(sm);
                return;
            }
            if (recipeList.getLevel() > skillLevel) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Need skill level " + recipeList.getLevel());
                player.sendPacket(sm);
                return;
            }
            L2RecipeInstance[] recipes = recipeList.getRecipes();
            PcInventory inv = player.getInventory();
            for (L2RecipeInstance recipe : recipes) {
                if (recipe.getQuantity() == 0 || (invItem = ((Inventory)inv).getItemByItemId(recipe.getItemId())) != null && recipe.getQuantity() <= invItem.getCount()) continue;
                SystemMessage sm = new SystemMessage(614);
                sm.addString("You dont have the right elements for making this item");
                player.sendPacket(sm);
                return;
            }
            if (!Config.ALT_GAME_CREATION && player.getCurrentMp() < (double)recipeList.getMpCost()) {
                if (Config.DEBUG) {
                    _log.fine("not enough mana");
                }
                SystemMessage sm = new SystemMessage(24);
                player.sendPacket(sm);
                this.timeReady = GameTimeController.getGameTicks();
                return;
            }
            for (L2RecipeInstance recipe : recipes) {
                if (recipe.getQuantity() == 0) continue;
                invItem = ((Inventory)inv).getItemByItemId(recipe.getItemId());
                invItem = ((Inventory)inv).dropItem(invItem, recipe.getQuantity());
                this.items.add(invItem);
                this.materialsRefPrice += invItem.getReferencePrice() * invItem.getCount();
                this.totalItems += invItem.getCount();
            }
            this.isValid = true;
            this.timeReady = 10 + GameTimeController.getGameTicks();
            ClientScheduler.getInstance().scheduleLow(this, 1100L);
        }

        public void run() {
            if (Config.IS_CRAFTING_ENABLED) {
                double currentPlayerMp = this.player.getCurrentMp();
                if (currentPlayerMp < (double)this.recipeList.getMpCost()) {
                    if (Config.DEBUG) {
                        _log.fine("not enough mana");
                    }
                    SystemMessage sm = new SystemMessage(24);
                    this.player.sendPacket(sm);
                    this.timeReady = GameTimeController.getGameTicks();
                    return;
                }
                int gameTicks = GameTimeController.getGameTicks();
                if (this.timeReady > gameTicks) {
                    return;
                }
                this.timeReady = gameTicks + (int)(15.0 * this.player.getMReuseRate(this.player.getKnownSkill(172)) * 10.0);
                if (!Config.ALT_GAME_CREATION || this.items.isEmpty()) {
                    this.player.reduceCurrentMp(this.recipeList.getMpCost());
                    StatusUpdate su = new StatusUpdate(this.player.getObjectId());
                    L2ItemInstance createdItem = ItemTable.getInstance().createItem(this.recipeList.getItemId());
                    createdItem.setCount(this.recipeList.getCount());
                    int randCheck = _rnd.nextInt(100);
                    if (this.recipeList.getSuccessRate() <= randCheck) {
                        SystemMessage sm = new SystemMessage(614);
                        sm.addString("Item(s) failed to create");
                        this.player.sendPacket(sm);
                    } else {
                        int createdItemCount = createdItem.getCount();
                        this.player.getInventory().addItem(createdItem);
                        SystemMessage sm = new SystemMessage(614);
                        sm.addString("Item(s) created");
                        this.player.sendPacket(sm);
                        su.addAttribute(StatusUpdate.CUR_LOAD, this.player.getCurrentLoad());
                        if (Config.ALT_GAME_CREATION) {
                            int skillLevel = this.player.getSkillLevel(172);
                            int receipeLevel = this.recipeList.getLevel();
                            int exp = createdItem.getReferencePrice() * createdItemCount;
                            exp = (int)((float)exp * Config.RATE_XP);
                            if ((exp -= this.materialsRefPrice) < 0) {
                                exp = 0;
                            }
                            for (int i = skillLevel; i > receipeLevel; --i) {
                                exp /= 4;
                            }
                            int sp = exp / 10;
                            sp = (int)((float)sp * Config.RATE_SP);
                            this.player.addExpAndSp(exp, sp);
                        }
                    }
                    activeMakers.remove(this.player);
                    su.addAttribute(StatusUpdate.CUR_MP, (int)this.player.getCurrentMp());
                    this.player.sendPacket(su);
                    this.player.sendPacket(new ItemList(this.player, true));
                } else {
                    double currentMp = this.player.getCurrentMp();
                    if (currentMp < (double)this.recipeList.getMpCost()) {
                        if (Config.DEBUG) {
                            _log.fine("not enough mana");
                        }
                        SystemMessage sm = new SystemMessage(24);
                        this.player.sendPacket(sm);
                        this.timeReady = GameTimeController.getGameTicks();
                        return;
                    }
                    this.player.setCurrentMp(currentMp - (double)this.recipeList.getMpCost());
                    int numItems = this.player.getSkillLevel(172);
                    while (numItems > 0 && !this.items.isEmpty()) {
                        L2ItemInstance item = this.items.get(0);
                        int count = item.getCount();
                        if (count >= numItems) {
                            count = numItems;
                        }
                        item.setCount(item.getCount() - count);
                        if (item.getCount() <= 0) {
                            this.items.remove(0);
                        }
                        numItems -= count;
                        this.usedItems += count;
                        SystemMessage sm = new SystemMessage(368);
                        sm.addNumber(count);
                        sm.addItemName(item.getItemId());
                        this.player.sendPacket(sm);
                    }
                    int delay = (this.timeReady - gameTicks) * 100;
                    MagicSkillUser msk = new MagicSkillUser(this.player, 1050, 1, delay, 0);
                    this.player.broadcastPacket(msk);
                    SetupGauge sg = new SetupGauge(0, delay);
                    this.player.sendPacket(sg);
                    ClientScheduler.getInstance().scheduleLow(this, 100 + delay);
                }
            } else {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Crafting is currently disabled.");
                this.player.sendPacket(sm);
            }
        }
    }
}

