/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.Action;
import net.sf.l2j.gameserver.clientpackets.AddTradeItem;
import net.sf.l2j.gameserver.clientpackets.AnswerTradeRequest;
import net.sf.l2j.gameserver.clientpackets.Appearing;
import net.sf.l2j.gameserver.clientpackets.AttackRequest;
import net.sf.l2j.gameserver.clientpackets.AuthLogin;
import net.sf.l2j.gameserver.clientpackets.CannotMoveAnymore;
import net.sf.l2j.gameserver.clientpackets.ChangeMoveType2;
import net.sf.l2j.gameserver.clientpackets.ChangeWaitType2;
import net.sf.l2j.gameserver.clientpackets.CharacterCreate;
import net.sf.l2j.gameserver.clientpackets.CharacterDelete;
import net.sf.l2j.gameserver.clientpackets.CharacterRestore;
import net.sf.l2j.gameserver.clientpackets.CharacterSelected;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.clientpackets.EnterWorld;
import net.sf.l2j.gameserver.clientpackets.Logout;
import net.sf.l2j.gameserver.clientpackets.MoveBackwardToLocation;
import net.sf.l2j.gameserver.clientpackets.NewCharacter;
import net.sf.l2j.gameserver.clientpackets.ObserverReturn;
import net.sf.l2j.gameserver.clientpackets.ProtocolVersion;
import net.sf.l2j.gameserver.clientpackets.RequestActionUse;
import net.sf.l2j.gameserver.clientpackets.RequestAllyCrest;
import net.sf.l2j.gameserver.clientpackets.RequestAnswerJoinParty;
import net.sf.l2j.gameserver.clientpackets.RequestAnswerJoinPledge;
import net.sf.l2j.gameserver.clientpackets.RequestAquireSkill;
import net.sf.l2j.gameserver.clientpackets.RequestAquireSkillInfo;
import net.sf.l2j.gameserver.clientpackets.RequestAutoSoulShot;
import net.sf.l2j.gameserver.clientpackets.RequestBuyItem;
import net.sf.l2j.gameserver.clientpackets.RequestBypassToServer;
import net.sf.l2j.gameserver.clientpackets.RequestChangePartyLeader;
import net.sf.l2j.gameserver.clientpackets.RequestChangePetName;
import net.sf.l2j.gameserver.clientpackets.RequestCrystallizeItem;
import net.sf.l2j.gameserver.clientpackets.RequestDeleteMacro;
import net.sf.l2j.gameserver.clientpackets.RequestDestroyItem;
import net.sf.l2j.gameserver.clientpackets.RequestDropItem;
import net.sf.l2j.gameserver.clientpackets.RequestEnchantItem;
import net.sf.l2j.gameserver.clientpackets.RequestEvaluate;
import net.sf.l2j.gameserver.clientpackets.RequestFriendDel;
import net.sf.l2j.gameserver.clientpackets.RequestFriendInvite;
import net.sf.l2j.gameserver.clientpackets.RequestGMCommand;
import net.sf.l2j.gameserver.clientpackets.RequestGetItemFromPet;
import net.sf.l2j.gameserver.clientpackets.RequestGiveItemToPet;
import net.sf.l2j.gameserver.clientpackets.RequestGiveNickName;
import net.sf.l2j.gameserver.clientpackets.RequestGmList;
import net.sf.l2j.gameserver.clientpackets.RequestHennaEquip;
import net.sf.l2j.gameserver.clientpackets.RequestHennaItemInfo;
import net.sf.l2j.gameserver.clientpackets.RequestItemList;
import net.sf.l2j.gameserver.clientpackets.RequestJoinParty;
import net.sf.l2j.gameserver.clientpackets.RequestJoinPledge;
import net.sf.l2j.gameserver.clientpackets.RequestMagicSkillUse;
import net.sf.l2j.gameserver.clientpackets.RequestMakeMacro;
import net.sf.l2j.gameserver.clientpackets.RequestOustPartyMember;
import net.sf.l2j.gameserver.clientpackets.RequestOustPledgeMember;
import net.sf.l2j.gameserver.clientpackets.RequestPartyMatchConfig;
import net.sf.l2j.gameserver.clientpackets.RequestPartyMatchDetail;
import net.sf.l2j.gameserver.clientpackets.RequestPartyMatchList;
import net.sf.l2j.gameserver.clientpackets.RequestPetGetItem;
import net.sf.l2j.gameserver.clientpackets.RequestPetUseItem;
import net.sf.l2j.gameserver.clientpackets.RequestPledgeCrest;
import net.sf.l2j.gameserver.clientpackets.RequestPledgeInfo;
import net.sf.l2j.gameserver.clientpackets.RequestPledgeMemberList;
import net.sf.l2j.gameserver.clientpackets.RequestPrivateStoreBuyManage;
import net.sf.l2j.gameserver.clientpackets.RequestPrivateStoreManage;
import net.sf.l2j.gameserver.clientpackets.RequestPrivateStoreQuitBuy;
import net.sf.l2j.gameserver.clientpackets.RequestPrivateStoreQuitSell;
import net.sf.l2j.gameserver.clientpackets.RequestQuestAbort;
import net.sf.l2j.gameserver.clientpackets.RequestQuestList;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeBookDestroy;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeBookOpen;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeItemMakeInfo;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeItemMakeSelf;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeShopListSet;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeShopManageList;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeShopManageQuit;
import net.sf.l2j.gameserver.clientpackets.RequestRecipeShopMessageSet;
import net.sf.l2j.gameserver.clientpackets.RequestRestart;
import net.sf.l2j.gameserver.clientpackets.RequestRestartPoint;
import net.sf.l2j.gameserver.clientpackets.RequestSellItem;
import net.sf.l2j.gameserver.clientpackets.RequestSetPledgeCrest;
import net.sf.l2j.gameserver.clientpackets.RequestShortCutDel;
import net.sf.l2j.gameserver.clientpackets.RequestShortCutReg;
import net.sf.l2j.gameserver.clientpackets.RequestShowBoard;
import net.sf.l2j.gameserver.clientpackets.RequestShowMiniMap;
import net.sf.l2j.gameserver.clientpackets.RequestSkillList;
import net.sf.l2j.gameserver.clientpackets.RequestSocialAction;
import net.sf.l2j.gameserver.clientpackets.RequestTargetCanceld;
import net.sf.l2j.gameserver.clientpackets.RequestUnEquipItem;
import net.sf.l2j.gameserver.clientpackets.RequestUserCommand;
import net.sf.l2j.gameserver.clientpackets.RequestWithDrawalParty;
import net.sf.l2j.gameserver.clientpackets.RequestWithdrawalPledge;
import net.sf.l2j.gameserver.clientpackets.Say2;
import net.sf.l2j.gameserver.clientpackets.SendBypassBuildCmd;
import net.sf.l2j.gameserver.clientpackets.SendPrivateStoreBuyBuyList;
import net.sf.l2j.gameserver.clientpackets.SendPrivateStoreBuyList;
import net.sf.l2j.gameserver.clientpackets.SendWareHouseDepositList;
import net.sf.l2j.gameserver.clientpackets.SendWareHouseWithDrawList;
import net.sf.l2j.gameserver.clientpackets.SetPrivateStoreListBuy;
import net.sf.l2j.gameserver.clientpackets.SetPrivateStoreListSell;
import net.sf.l2j.gameserver.clientpackets.SetPrivateStoreMsgBuy;
import net.sf.l2j.gameserver.clientpackets.SetPrivateStoreMsgSell;
import net.sf.l2j.gameserver.clientpackets.TradeDone;
import net.sf.l2j.gameserver.clientpackets.TradeRequest;
import net.sf.l2j.gameserver.clientpackets.UseItem;
import net.sf.l2j.gameserver.clientpackets.ValidatePosition;

public class PacketHandler {
    private static Logger _log = Logger.getLogger(PacketHandler.class.getName());

    private PacketHandler() {
    }

    public static ClientBasePacket handlePacket(ByteBuffer data, ClientThread _client) {
        ClientBasePacket msg = null;
        int id = data.get() & 0xFF;
        switch (id) {
            case 0: {
                msg = new ProtocolVersion(data, _client);
                break;
            }
            case 1: {
                msg = new MoveBackwardToLocation(data, _client);
                break;
            }
            case 3: {
                msg = new EnterWorld(data, _client);
                break;
            }
            case 4: {
                msg = new Action(data, _client);
                break;
            }
            case 8: {
                msg = new AuthLogin(data, _client);
                break;
            }
            case 9: {
                msg = new Logout(data, _client);
                break;
            }
            case 10: {
                msg = new AttackRequest(data, _client);
                break;
            }
            case 11: {
                msg = new CharacterCreate(data, _client);
                break;
            }
            case 12: {
                msg = new CharacterDelete(data, _client);
                break;
            }
            case 13: {
                msg = new CharacterSelected(data, _client);
                break;
            }
            case 14: {
                msg = new NewCharacter(data, _client);
                break;
            }
            case 15: {
                msg = new RequestItemList(data, _client);
                break;
            }
            case 17: {
                msg = new RequestUnEquipItem(data, _client);
                break;
            }
            case 18: {
                msg = new RequestDropItem(data, _client);
                break;
            }
            case 20: {
                msg = new UseItem(data, _client);
                break;
            }
            case 21: {
                msg = new TradeRequest(data, _client);
                break;
            }
            case 22: {
                msg = new AddTradeItem(data, _client);
                break;
            }
            case 23: {
                msg = new TradeDone(data, _client);
                break;
            }
            case 27: {
                msg = new RequestSocialAction(data, _client);
                break;
            }
            case 28: {
                msg = new ChangeMoveType2(data, _client);
                break;
            }
            case 29: {
                msg = new ChangeWaitType2(data, _client);
                break;
            }
            case 30: {
                msg = new RequestSellItem(data, _client);
                break;
            }
            case 31: {
                msg = new RequestBuyItem(data, _client);
                break;
            }
            case 33: {
                msg = new RequestBypassToServer(data, _client);
                break;
            }
            case 36: {
                msg = new RequestJoinPledge(data, _client);
                break;
            }
            case 37: {
                msg = new RequestAnswerJoinPledge(data, _client);
                break;
            }
            case 38: {
                msg = new RequestWithdrawalPledge(data, _client);
                break;
            }
            case 39: {
                msg = new RequestOustPledgeMember(data, _client);
                break;
            }
            case 41: {
                msg = new RequestJoinParty(data, _client);
                break;
            }
            case 42: {
                msg = new RequestAnswerJoinParty(data, _client);
                break;
            }
            case 43: {
                msg = new RequestWithDrawalParty(data, _client);
                break;
            }
            case 44: {
                msg = new RequestOustPartyMember(data, _client);
                break;
            }
            case 47: {
                msg = new RequestMagicSkillUse(data, _client);
                break;
            }
            case 48: {
                msg = new Appearing(data, _client);
                break;
            }
            case 49: {
                if (!Config.ALLOW_WAREHOUSE) break;
                msg = new SendWareHouseDepositList(data, _client);
                break;
            }
            case 50: {
                msg = new SendWareHouseWithDrawList(data, _client);
                break;
            }
            case 51: {
                msg = new RequestShortCutReg(data, _client);
                break;
            }
            case 53: {
                msg = new RequestShortCutDel(data, _client);
                break;
            }
            case 54: {
                msg = new CannotMoveAnymore(data, _client);
                break;
            }
            case 55: {
                msg = new RequestTargetCanceld(data, _client);
                break;
            }
            case 56: {
                msg = new Say2(data, _client);
                break;
            }
            case 60: {
                msg = new RequestPledgeMemberList(data, _client);
                break;
            }
            case 63: {
                msg = new RequestSkillList(data, _client);
                break;
            }
            case 68: {
                msg = new AnswerTradeRequest(data, _client);
                break;
            }
            case 69: {
                msg = new RequestActionUse(data, _client);
                break;
            }
            case 70: {
                msg = new RequestRestart(data, _client);
                break;
            }
            case 72: {
                msg = new ValidatePosition(data, _client);
                break;
            }
            case 74: {
                break;
            }
            case 75: {
                break;
            }
            case 83: {
                msg = new RequestSetPledgeCrest(data, _client);
                break;
            }
            case 85: {
                msg = new RequestGiveNickName(data, _client);
                break;
            }
            case 87: {
                msg = new RequestShowBoard(data, _client);
                break;
            }
            case 88: {
                msg = new RequestEnchantItem(data, _client);
                break;
            }
            case 89: {
                msg = new RequestDestroyItem(data, _client);
                break;
            }
            case 91: {
                msg = new SendBypassBuildCmd(data, _client);
                break;
            }
            case 94: {
                msg = new RequestFriendInvite(data, _client);
                break;
            }
            case 97: {
                msg = new RequestFriendDel(data, _client);
                break;
            }
            case 98: {
                msg = new CharacterRestore(data, _client);
                break;
            }
            case 99: {
                msg = new RequestQuestList(data, _client);
                break;
            }
            case 100: {
                msg = new RequestQuestAbort(data, _client);
                break;
            }
            case 102: {
                msg = new RequestPledgeInfo(data, _client);
                break;
            }
            case 104: {
                msg = new RequestPledgeCrest(data, _client);
                break;
            }
            case 107: {
                msg = new RequestAquireSkillInfo(data, _client);
                break;
            }
            case 108: {
                msg = new RequestAquireSkill(data, _client);
                break;
            }
            case 109: {
                msg = new RequestRestartPoint(data, _client);
                break;
            }
            case 110: {
                msg = new RequestGMCommand(data, _client);
                break;
            }
            case 111: {
                msg = new RequestPartyMatchConfig(data, _client);
                break;
            }
            case 112: {
                msg = new RequestPartyMatchList(data, _client);
                break;
            }
            case 113: {
                msg = new RequestPartyMatchDetail(data, _client);
                break;
            }
            case 114: {
                msg = new RequestCrystallizeItem(data, _client);
                break;
            }
            case 115: {
                msg = new RequestPrivateStoreManage(data, _client);
                break;
            }
            case 116: {
                msg = new SetPrivateStoreListSell(data, _client);
                break;
            }
            case 118: {
                msg = new RequestPrivateStoreQuitSell(data, _client);
                break;
            }
            case 119: {
                msg = new SetPrivateStoreMsgSell(data, _client);
                break;
            }
            case 121: {
                msg = new SendPrivateStoreBuyList(data, _client);
                break;
            }
            case 129: {
                msg = new RequestGmList(data, _client);
                break;
            }
            case 136: {
                msg = new RequestAllyCrest(data, _client);
                break;
            }
            case 137: {
                msg = new RequestChangePetName(data, _client);
                break;
            }
            case 138: {
                msg = new RequestPetUseItem(data, _client);
                break;
            }
            case 139: {
                msg = new RequestGiveItemToPet(data, _client);
                break;
            }
            case 140: {
                msg = new RequestGetItemFromPet(data, _client);
                break;
            }
            case 143: {
                msg = new RequestPetGetItem(data, _client);
                break;
            }
            case 144: {
                msg = new RequestPrivateStoreBuyManage(data, _client);
                break;
            }
            case 145: {
                msg = new SetPrivateStoreListBuy(data, _client);
                break;
            }
            case 147: {
                msg = new RequestPrivateStoreQuitBuy(data, _client);
                break;
            }
            case 148: {
                msg = new SetPrivateStoreMsgBuy(data, _client);
                break;
            }
            case 150: {
                msg = new SendPrivateStoreBuyBuyList(data, _client);
                break;
            }
            case 157: {
                if (Config.DEBUG) {
                    _log.info("Request Skill Cool Time .. ignored");
                }
                msg = null;
                break;
            }
            case 170: {
                msg = new RequestUserCommand(data, _client);
                break;
            }
            case 172: {
                msg = new RequestRecipeBookOpen(data, _client);
                break;
            }
            case 173: {
                msg = new RequestRecipeBookDestroy(data, _client);
                break;
            }
            case 174: {
                msg = new RequestRecipeItemMakeInfo(data, _client);
                break;
            }
            case 175: {
                msg = new RequestRecipeItemMakeSelf(data, _client);
                break;
            }
            case 176: {
                msg = new RequestRecipeShopManageList(data, _client);
                break;
            }
            case 177: {
                msg = new RequestRecipeShopMessageSet(data, _client);
                break;
            }
            case 178: {
                msg = new RequestRecipeShopListSet(data, _client);
                break;
            }
            case 179: {
                msg = new RequestRecipeShopManageQuit(data, _client);
                break;
            }
            case 184: {
                msg = new ObserverReturn(data, _client);
                break;
            }
            case 185: {
                msg = new RequestEvaluate(data, _client);
                break;
            }
            case 187: {
                msg = new RequestHennaItemInfo(data, _client);
                break;
            }
            case 188: {
                msg = new RequestHennaEquip(data, _client);
                break;
            }
            case 193: {
                msg = new RequestMakeMacro(data, _client);
                break;
            }
            case 194: {
                msg = new RequestDeleteMacro(data, _client);
                break;
            }
            case 205: {
                msg = new RequestShowMiniMap(data, _client);
                break;
            }
            case 206: {
                msg = null;
                break;
            }
            case 207: {
                int id2 = data.getShort() & 0xFFFF;
                switch (id2) {
                    case 5: {
                        msg = new RequestAutoSoulShot(data, _client);
                        break;
                    }
                    case 4: {
                        msg = new RequestChangePartyLeader(data, _client);
                    }
                }
                break;
            }
            default: {
                msg = null;
                int sz = data.remaining();
                _log.warning("Unknown Packet:" + Integer.toHexString(id));
                byte[] arr = new byte[sz];
                data.get(arr);
                _log.warning(PacketHandler.printData(arr, sz));
                break;
            }
        }
        if (msg != null) {
            msg._buf = null;
        }
        return msg;
    }

    private static String printData(byte[] data, int len) {
        byte t1;
        int a;
        int charpoint;
        StringBuffer result = new StringBuffer();
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            if (counter % 16 == 0) {
                result.append(PacketHandler.fillHex(i, 4) + ": ");
            }
            result.append(PacketHandler.fillHex(data[i] & 0xFF, 2) + " ");
            if (++counter != 16) continue;
            result.append("   ");
            charpoint = i - 15;
            for (a = 0; a < 16; ++a) {
                if ((t1 = data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append("\n");
            counter = 0;
        }
        int rest = data.length % 16;
        if (rest > 0) {
            for (int i = 0; i < 17 - rest; ++i) {
                result.append("   ");
            }
            charpoint = data.length - rest;
            for (a = 0; a < rest; ++a) {
                if ((t1 = data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append("\n");
        }
        return result.toString();
    }

    private static String fillHex(int data, int digits) {
        String number = Integer.toHexString(data);
        for (int i = number.length(); i < digits; ++i) {
            number = "0" + number;
        }
        return number;
    }
}

