/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.Location;

public class MapRegionTable {
    private static Logger _log = Logger.getLogger(MapRegionTable.class.getName());
    private static MapRegionTable _instance;
    private final int[][] _regions = new int[19][21];
    private final int[][] _pointsWithKarmas;
    private final int[][] _closestTown;

    public static MapRegionTable getInstance() {
        if (_instance == null) {
            _instance = new MapRegionTable();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapRegionTable() {
        int count2 = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT region, sec0, sec1, sec2, sec3, sec4, sec5, sec6, sec7, sec8, sec9 FROM mapregion");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int region = rset.getInt(1);
                for (int j = 0; j < 10; ++j) {
                    this._regions[j][region] = rset.getInt(j + 2);
                    ++count2;
                }
            }
            rset.close();
            statement.close();
            if (Config.DEBUG) {
                _log.fine(count2 + " mapregion loaded");
            }
        }
        catch (Exception e) {
            _log.warning("error while creating map region data: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        this._pointsWithKarmas = new int[14][3];
        this._pointsWithKarmas[0][0] = -79077;
        this._pointsWithKarmas[0][1] = 240355;
        this._pointsWithKarmas[0][2] = -3440;
        this._pointsWithKarmas[1][0] = 43503;
        this._pointsWithKarmas[1][1] = 40398;
        this._pointsWithKarmas[1][2] = -3450;
        this._pointsWithKarmas[2][0] = 1675;
        this._pointsWithKarmas[2][1] = 19581;
        this._pointsWithKarmas[2][2] = -3110;
        this._pointsWithKarmas[3][0] = -44413;
        this._pointsWithKarmas[3][1] = -121762;
        this._pointsWithKarmas[3][2] = -235;
        this._pointsWithKarmas[4][0] = 12009;
        this._pointsWithKarmas[4][1] = -187319;
        this._pointsWithKarmas[4][2] = -3309;
        this._pointsWithKarmas[5][0] = -18872;
        this._pointsWithKarmas[5][1] = 126216;
        this._pointsWithKarmas[5][2] = -3280;
        this._pointsWithKarmas[6][0] = -85915;
        this._pointsWithKarmas[6][1] = 150402;
        this._pointsWithKarmas[6][2] = -3060;
        this._pointsWithKarmas[7][0] = 23652;
        this._pointsWithKarmas[7][1] = 144823;
        this._pointsWithKarmas[7][2] = -3330;
        this._pointsWithKarmas[8][0] = 79125;
        this._pointsWithKarmas[8][1] = 154197;
        this._pointsWithKarmas[8][2] = -3490;
        this._pointsWithKarmas[9][0] = 73840;
        this._pointsWithKarmas[9][1] = 58193;
        this._pointsWithKarmas[9][2] = -2730;
        this._pointsWithKarmas[10][0] = 44413;
        this._pointsWithKarmas[10][1] = 22610;
        this._pointsWithKarmas[10][2] = 235;
        this._pointsWithKarmas[11][0] = 114137;
        this._pointsWithKarmas[11][1] = 72993;
        this._pointsWithKarmas[11][2] = -2445;
        this._pointsWithKarmas[12][0] = 79125;
        this._pointsWithKarmas[12][1] = 154197;
        this._pointsWithKarmas[12][2] = -3490;
        this._pointsWithKarmas[13][0] = 119536;
        this._pointsWithKarmas[13][1] = 218558;
        this._pointsWithKarmas[13][2] = -3495;
        this._closestTown = new int[14][3];
        this._closestTown[0][0] = -84176;
        this._closestTown[0][1] = 243382;
        this._closestTown[0][2] = -3126;
        this._closestTown[1][0] = 45525;
        this._closestTown[1][1] = 48376;
        this._closestTown[1][2] = -3059;
        this._closestTown[2][0] = 12181;
        this._closestTown[2][1] = 16675;
        this._closestTown[2][2] = -4580;
        this._closestTown[3][0] = -45232;
        this._closestTown[3][1] = -113603;
        this._closestTown[3][2] = -224;
        this._closestTown[4][0] = 115074;
        this._closestTown[4][1] = -178115;
        this._closestTown[4][2] = -880;
        this._closestTown[5][0] = -14138;
        this._closestTown[5][1] = 122042;
        this._closestTown[5][2] = -2988;
        this._closestTown[6][0] = -82856;
        this._closestTown[6][1] = 150901;
        this._closestTown[6][2] = -3128;
        this._closestTown[7][0] = 18823;
        this._closestTown[7][1] = 145048;
        this._closestTown[7][2] = -3126;
        this._closestTown[8][0] = 83235;
        this._closestTown[8][1] = 148497;
        this._closestTown[8][2] = -3404;
        this._closestTown[9][0] = 80853;
        this._closestTown[9][1] = 54653;
        this._closestTown[9][2] = -1524;
        this._closestTown[10][0] = 147391;
        this._closestTown[10][1] = 25967;
        this._closestTown[10][2] = -2012;
        this._closestTown[11][0] = 117163;
        this._closestTown[11][1] = 76511;
        this._closestTown[11][2] = -2712;
        this._closestTown[12][0] = 83235;
        this._closestTown[12][1] = 148497;
        this._closestTown[12][2] = -3404;
        this._closestTown[13][0] = 111381;
        this._closestTown[13][1] = 219064;
        this._closestTown[13][2] = -3543;
    }

    private int getMapRegion(int posX, int posY) {
        int tileX = (posX >> 15) + 4;
        int tileY = (posY >> 15) + 10;
        return this._regions[tileX][tileY];
    }

    public int getClosestTownNumber(L2Character activeChar) {
        return this.getMapRegion(activeChar.getX(), activeChar.getY());
    }

    public Location getClosestTownCords(L2Character activeChar) {
        int closest = this.getMapRegion(activeChar.getX(), activeChar.getY());
        Location closestTownCords = new Location(this._closestTown[closest][0], this._closestTown[closest][1], this._closestTown[closest][2]);
        if (activeChar instanceof L2PcInstance) {
            int y2;
            int x2;
            int y1;
            int x1;
            L2PcInstance player = (L2PcInstance)activeChar;
            if (player.getKarma() > 0) {
                closestTownCords = new Location(this._pointsWithKarmas[closest][0], this._pointsWithKarmas[closest][1], this._pointsWithKarmas[closest][2]);
            }
            for (int i = 0; i < L2World.arenas.length; ++i) {
                x1 = L2World.arenas[i][0];
                y1 = L2World.arenas[i][1];
                x2 = L2World.arenas[i][2];
                y2 = L2World.arenas[i][3];
                if (player.getX() < Math.min(x1, x2) || player.getX() > Math.max(x1, x2) || player.getY() < Math.min(y1, y2) || player.getY() > Math.max(y1, y2)) continue;
                closestTownCords = new Location(L2World.arenaspawn[i][0], L2World.arenaspawn[i][1], L2World.arenaspawn[i][2]);
            }
            if (L2Siege.getSiege() != 0) {
                int theCastle = L2Siege.getSiege() - 1;
                x1 = L2World.castles[theCastle][0];
                y1 = L2World.castles[theCastle][1];
                x2 = L2World.castles[theCastle][2];
                y2 = L2World.castles[theCastle][3];
                if (player.getX() >= Math.min(x1, x2) && player.getX() <= Math.max(x1, x2) && player.getY() >= Math.min(y1, y2) && player.getY() <= Math.max(y1, y2)) {
                    if (L2Siege.isAttacker(player.getClanId())) {
                        Location tempLoc = L2Siege.getAttackerSpawn(player.getClanId());
                        closestTownCords = tempLoc != null ? tempLoc : new Location(L2World.castlespawns[theCastle * 2][0], L2World.castlespawns[theCastle * 2][1], L2World.castlespawns[theCastle * 2][2]);
                    } else if (L2Siege.isDefender(player.getClanId())) {
                        closestTownCords = new Location(L2World.castlespawns[theCastle * 2 + 1][0], L2World.castlespawns[theCastle * 2 + 1][1], L2World.castlespawns[theCastle * 2 + 1][2]);
                    }
                }
            }
        }
        return closestTownCords;
    }
}

