/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdFactory {
    private static Logger _log = Logger.getLogger(IdFactory.class.getName());
    private static final int STACK_SIZE_INCREMENT = 8196;
    private AtomicInteger freeIdCount;
    private AtomicInteger nextFreeId;
    private static int newFreeID;
    private static String[] id_updates;
    private static String[] id_checks;
    private int _curOID;
    private int[] _freeOIDs;
    private int _freeSize;
    private boolean initialized;
    private static int FIRST_OID;
    private static int LAST_OID;
    private static IdFactory _instance;
    private BitSet freeIds = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdFactory() {
        if (Config.COMPACTION) {
            this._curOID = FIRST_OID;
            this._freeOIDs = new int[8196];
            this._freeSize = 0;
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                Statement s = con.createStatement();
                try {
                    s.executeUpdate("drop table temporaryObjectTable");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                s.executeUpdate("create table temporaryObjectTable (object_id int NOT NULL PRIMARY KEY)");
                s.executeUpdate("insert into temporaryObjectTable (object_id) select obj_id from characters");
                s.executeUpdate("insert into temporaryObjectTable (object_id) select object_id from items");
                s.executeUpdate("insert into temporaryObjectTable (object_id) select clan_id from clan_data");
                ResultSet result = s.executeQuery("select count(object_id) from temporaryObjectTable ORDER BY object_id");
                result.next();
                int[] tmp_obj_ids = new int[result.getInt(1)];
                result.close();
                result = s.executeQuery("select object_id from temporaryObjectTable ORDER BY object_id");
                int idx = 0;
                while (result.next()) {
                    tmp_obj_ids[idx++] = result.getInt(1);
                }
                result.close();
                s.close();
                int N = tmp_obj_ids.length;
                for (idx = 0; idx < N; ++idx) {
                    N = this.insertUntil(tmp_obj_ids, idx, N, con);
                }
                ++this._curOID;
                _log.config("IdFactory: Next usable Object ID is: " + this._curOID);
                this.initialized = true;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                _log.severe("ID Factory could not be initialized correctly:" + e1);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        } else {
            this.initialize();
            _log.info("IDFactory: " + this.freeIds.size() + " id's avaliable.");
        }
    }

    private IdFactory(int i) {
    }

    private int[] extractUsedObjectIDTable(Connection con) throws SQLException {
        Statement s = con.createStatement();
        s.executeUpdate("drop table if exists tmp_obj_id");
        s.executeUpdate("create table tmp_obj_id (object_id int NOT NULL PRIMARY KEY)");
        s.executeUpdate("insert into tmp_obj_id (object_id) select obj_id from characters");
        s.executeUpdate("insert into tmp_obj_id (object_id) select clan_id from clan_data");
        s.executeUpdate("update items i left join tmp_obj_id t on (i.object_id = t.object_id) set i.object_id = i.object_id + 200000000 where i.object_id IS NOT NULL AND t.object_id IS NOT NULL;");
        s.executeUpdate("insert into tmp_obj_id (object_id) select object_id from items");
        ResultSet result = s.executeQuery("select count(object_id) from tmp_obj_id ORDER BY object_id");
        result.next();
        int[] tmp_obj_ids = new int[result.getInt(1)];
        result.close();
        result = s.executeQuery("select object_id from tmp_obj_id ORDER BY object_id");
        int idx = 0;
        while (result.next()) {
            tmp_obj_ids[idx++] = result.getInt(1);
        }
        result.close();
        s.close();
        return tmp_obj_ids;
    }

    public static void main(String[] args) {
        System.out.println("Commencing Database Reindexing.");
        new IdFactory(1).reindex();
        System.out.println("Finished Reindexing Database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex() {
        newFreeID = FIRST_OID;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            int[] objectIds = this.extractUsedObjectIDTable(con);
            ArrayList<Integer> objectIDList = new ArrayList<Integer>();
            int[] arr$ = objectIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer oId = arr$[i$];
                objectIDList.add(oId);
            }
            IdFactory.reindexCharacterIds(con, objectIDList);
            IdFactory.reindexPetItemIds(con, objectIDList);
        }
        catch (Exception e1) {
            _log.severe("ID Factory could not be initialized correctly (2):" + e1);
            e1.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void reindexPetItemIds(Connection con, ArrayList<Integer> objectIDList) throws SQLException {
        System.out.println("Reindexing Pet Items.");
        Statement s = con.createStatement();
        ResultSet result = s.executeQuery("select count(item_obj_id) from pets");
        result.next();
        int[] characterIds = new int[result.getInt(1)];
        result.close();
        result = s.executeQuery("select item_obj_id from pets ORDER BY item_obj_id");
        int idx = 0;
        while (result.next()) {
            characterIds[idx++] = result.getInt(1);
        }
        result.close();
        int[] chars = new int[]{1, 13};
        int[] arr$ = characterIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer oldOID = arr$[i$];
            int[] arr$2 = chars;
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Integer updateId = arr$2[i$2];
                String update2 = id_updates[updateId];
                newFreeID = IdFactory.getNextUnusedID(objectIDList, newFreeID);
                PreparedStatement ps = con.prepareStatement(update2);
                ps.setInt(1, oldOID);
                ps.setInt(2, newFreeID);
                ps.execute();
                ps.close();
                objectIDList.remove(oldOID);
            }
            System.out.println("Reindexed Pet Item from Old ID: " + oldOID + "\tto New ID: " + newFreeID + ".");
        }
        System.out.println("Finished Reindexing Pet Items.");
    }

    private static void reindexCharacterIds(Connection con, ArrayList<Integer> objectIDList) throws SQLException {
        System.out.println("Reindexing Characters.");
        Statement s = con.createStatement();
        ResultSet result = s.executeQuery("select count(obj_id) from characters ORDER BY obj_id");
        result.next();
        int[] characterIds = new int[result.getInt(1)];
        result.close();
        result = s.executeQuery("select obj_id from characters ORDER BY obj_id");
        int idx = 0;
        while (result.next()) {
            characterIds[idx++] = result.getInt(1);
        }
        result.close();
        int[] chars = new int[]{0, 2, 3, 4, 6, 7, 8, 12};
        int[] arr$ = characterIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer oldOID = arr$[i$];
            int[] arr$2 = chars;
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Integer updateId = arr$2[i$2];
                String update2 = id_updates[updateId];
                newFreeID = IdFactory.getNextUnusedID(objectIDList, newFreeID);
                PreparedStatement ps = con.prepareStatement(update2);
                ps.setInt(1, oldOID);
                ps.setInt(2, newFreeID);
                ps.execute();
                ps.close();
                objectIDList.remove(oldOID);
            }
            System.out.println("Reindexed Character from Old ID: " + oldOID + "\tto New ID: " + newFreeID + ".");
        }
        System.out.println("Finished Reindexing Characters.");
    }

    private static int getNextUnusedID(ArrayList<Integer> objectIDList, int startIndex) {
        for (int id = startIndex + 1; id <= LAST_OID; ++id) {
            if (objectIDList.contains(id)) continue;
            return id;
        }
        return -1;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private int insertUntil(int[] tmp_obj_ids, int idx, int N, Connection con) throws SQLException {
        int id = tmp_obj_ids[idx];
        if (id == this._curOID) {
            ++this._curOID;
            return N;
        }
        for (String check : id_checks) {
            PreparedStatement ps = con.prepareStatement(check);
            ps.setInt(1, this._curOID);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int badId = rs.getInt(1);
                _log.severe("Bad ID " + badId + " in DB found by: " + check);
                throw new RuntimeException();
            }
            rs.close();
            ps.close();
        }
        int hole = id - this._curOID;
        if (hole > N - idx) {
            hole = N - idx;
        }
        for (int i = 1; i <= hole; ++i) {
            id = tmp_obj_ids[N - i];
            System.out.println("Compacting DB object ID=" + id + " into " + this._curOID);
            for (String update2 : id_updates) {
                PreparedStatement ps = con.prepareStatement(update2);
                ps.setInt(1, this._curOID);
                ps.setInt(2, id);
                ps.execute();
                ps.close();
            }
            ++this._curOID;
        }
        if (hole < N - idx) {
            ++this._curOID;
        }
        return N - hole;
    }

    public static IdFactory getInstance() {
        return _instance;
    }

    public synchronized int getNextId() {
        if (Config.COMPACTION) {
            if (this._freeSize == 0) {
                return this._curOID++;
            }
            return this._freeOIDs[--this._freeSize];
        }
        int newID = this.nextFreeId.get();
        int nextFree = this.freeIds.nextClearBit(newID);
        if (nextFree < 0) {
            nextFree = this.freeIds.nextClearBit(0);
        }
        if (nextFree < 0) {
            throw new NullPointerException("Ran out of valid Id's.");
        }
        this.nextFreeId.set(nextFree);
        return newID + FIRST_OID;
    }

    public synchronized void releaseId(int id) {
        if (Config.COMPACTION) {
            if (this._freeSize >= this._freeOIDs.length) {
                int[] tmp = new int[this._freeSize + 8196];
                System.arraycopy(this._freeOIDs, 0, tmp, 0, this._freeSize);
                this._freeOIDs = tmp;
            }
            this._freeOIDs[this._freeSize++] = id;
        } else if (id >= FIRST_OID) {
            this.freeIds.clear(id - FIRST_OID);
            this.freeIdCount.incrementAndGet();
        }
    }

    public int size() {
        if (!Config.COMPACTION) {
            return this.freeIdCount.get();
        }
        return this._freeSize + LAST_OID - FIRST_OID;
    }

    public void initialize() {
        try {
            this.freeIds = new BitSet(LAST_OID - FIRST_OID);
            this.freeIdCount = new AtomicInteger(this.freeIds.size());
            this.nextFreeId = new AtomicInteger(0);
            this.freeIds.set(0);
            this.initialized = true;
        }
        catch (Exception e) {
            this.initialized = false;
            e.printStackTrace();
        }
    }

    public synchronized void setObjectIDAsUsed(int id) {
        if (id >= FIRST_OID && !Config.COMPACTION) {
            this.freeIds.set(id - FIRST_OID);
            this.freeIdCount.decrementAndGet();
        }
    }

    static {
        id_updates = new String[]{"UPDATE items                SET owner_id = ?    WHERE owner_id = ?", "UPDATE items                SET object_id = ?   WHERE object_id = ?", "UPDATE character_quests     SET char_id = ?     WHERE char_id = ?", "UPDATE character_recipebook SET char_id = ?     WHERE char_id = ?", "UPDATE character_shortcuts  SET char_obj_id = ? WHERE char_obj_id = ?", "UPDATE character_shortcuts  SET shortcut_id = ? WHERE shortcut_id = ? AND type = 1", "UPDATE character_macroses   SET char_obj_id = ? WHERE char_obj_id = ?", "UPDATE character_skills     SET char_obj_id = ? WHERE char_obj_id = ?", "UPDATE characters           SET obj_Id = ?      WHERE obj_Id = ?", "UPDATE characters           SET clanid = ?      WHERE clanid = ?", "UPDATE clan_data            SET clan_id = ?     WHERE clan_id = ?", "UPDATE clan_data            SET ally_id = ?     WHERE ally_id = ?", "UPDATE clan_data            SET leader_id = ?   WHERE leader_id = ?", "UPDATE pets                 SET item_obj_id = ? WHERE item_obj_id = ?"};
        id_checks = new String[]{"SELECT object_id   FROM items                WHERE object_id >= ?   AND object_id < ?", "SELECT owner_id    FROM items                WHERE object_id >= ?   AND object_id < ?", "SELECT char_id     FROM character_quests     WHERE char_id >= ?     AND char_id < ?", "SELECT char_id     FROM character_recipebook WHERE char_id >= ?     AND char_id < ?", "SELECT char_obj_id FROM character_shortcuts  WHERE char_obj_id >= ? AND char_obj_id < ?", "SELECT char_obj_id FROM character_macroses   WHERE char_obj_id >= ? AND char_obj_id < ?", "SELECT char_obj_id FROM character_skills     WHERE char_obj_id >= ? AND char_obj_id < ?", "SELECT obj_Id      FROM characters           WHERE obj_Id >= ?      AND obj_Id < ?", "SELECT clanid      FROM characters           WHERE clanid >= ?      AND clanid < ?", "SELECT clan_id     FROM clan_data            WHERE clan_id >= ?     AND clan_id < ?", "SELECT ally_id     FROM clan_data            WHERE ally_id >= ?     AND ally_id < ?", "SELECT leader_id   FROM clan_data            WHERE leader_id >= ?   AND leader_id < ?", "SELECT item_obj_id FROM pets                 WHERE item_obj_id >= ? AND item_obj_id < ?"};
        FIRST_OID = 0x10000000;
        LAST_OID = Integer.MAX_VALUE;
        _instance = new IdFactory();
    }
}

