/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.SunRise;
import net.sf.l2j.gameserver.serverpackets.SunSet;

public class GameTimeController {
    static final Logger _log = Logger.getLogger(GameTimeController.class.getName());
    public static final int TICKS_PER_SECOND = 10;
    public static final int MILLIS_IN_TICK = 100;
    private static GameTimeController _instance = new GameTimeController();
    protected static int _gameTicks;
    protected static long _gameStartTime;
    protected static boolean _isNight;
    private static ArrayList<L2Character> movingObjects;
    protected TimerThread _timer;

    public static GameTimeController getInstance() {
        return _instance;
    }

    private GameTimeController() {
        _gameStartTime = System.currentTimeMillis() - 3600000L;
        _gameTicks = 36000;
        this._timer = new TimerThread();
        this._timer.start();
        ClientScheduler.getInstance().scheduleLowAtFixedRate(new TimerWatcher(), 0L, 1000L);
        ClientScheduler.getInstance().scheduleLowAtFixedRate(new BroadcastSunState(), 0L, 3600000L);
    }

    public boolean isNowNight() {
        return _isNight;
    }

    public int getGameTime() {
        return _gameTicks / 100;
    }

    public static int getGameTicks() {
        return _gameTicks;
    }

    public synchronized void registerMovingObject(L2Character cha) {
        if (!movingObjects.contains(cha)) {
            movingObjects.add(cha);
        }
    }

    protected synchronized void moveObjects() {
        L2Character[] chars = movingObjects.toArray(new L2Character[movingObjects.size()]);
        ArrayList<L2Character> ended = null;
        for (int i = 0; i < chars.length; ++i) {
            L2Character cha = chars[i];
            boolean end = cha.updatePosition(_gameTicks);
            if (!end) continue;
            movingObjects.remove(cha);
            if (ended == null) {
                ended = new ArrayList<L2Character>();
            }
            ended.add(cha);
        }
        if (ended != null) {
            ClientScheduler.getInstance().scheduleLow(new MovingObjectArrived(ended), 10L);
        }
    }

    public void stopTimer() {
        this._timer._stop = true;
    }

    static {
        movingObjects = new ArrayList();
    }

    class BroadcastSunState
    implements Runnable {
        BroadcastSunState() {
        }

        public void run() {
            ServerBasePacket packet;
            int time = GameTimeController.this.getGameTime() + 0;
            boolean bl = _isNight = (time %= 6) >= 5;
            if (time >= 5) {
                packet = new SunSet();
                if (Config.DEBUG) {
                    _log.fine("SunSet");
                }
            } else if (time == 0) {
                _isNight = false;
                packet = new SunRise();
                if (Config.DEBUG) {
                    _log.fine("SunRise");
                }
            } else {
                return;
            }
            for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
                player.sendPacket(packet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MovingObjectArrived
    implements Runnable {
        final ArrayList<L2Character> ended;

        MovingObjectArrived(ArrayList<L2Character> ended) {
            this.ended = ended;
        }

        @Override
        public void run() {
            for (L2Character cha : this.ended) {
                cha.updateKnownObjects();
                cha.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
            }
        }
    }

    class TimerWatcher
    implements Runnable {
        TimerWatcher() {
        }

        public void run() {
            if (!GameTimeController.this._timer.isAlive()) {
                String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
                _log.warning(time + " TimerThread stop with following error. restart it.");
                if (GameTimeController.this._timer._error != null) {
                    GameTimeController.this._timer._error.printStackTrace();
                }
                GameTimeController.this._timer = new TimerThread();
                GameTimeController.this._timer.start();
            }
        }
    }

    class TimerThread
    extends Thread {
        protected boolean _stop;
        protected Exception _error;

        public TimerThread() {
            super("TimerThread");
            this.setDaemon(true);
            this.setPriority(10);
            this._stop = false;
            this._error = null;
        }

        public void run() {
            try {
                do {
                    long runtime = System.currentTimeMillis() - _gameStartTime;
                    _gameTicks = (int)(runtime / 100L);
                    GameTimeController.this.moveObjects();
                    runtime = System.currentTimeMillis() - _gameStartTime;
                    int sleepTime = 101 - (int)runtime % 100;
                    TimerThread.sleep(sleepTime);
                } while (!this._stop);
                throw new Exception("stopTimer() was called");
            }
            catch (Exception e) {
                this._error = e;
                return;
            }
        }
    }
}

