/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.BasePacketQueue;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.Crypt;
import net.sf.l2j.gameserver.PacketHandler;
import net.sf.l2j.gameserver.SelectorThread;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.WrappedMessage;

public final class Connection {
    private static Logger _log = Logger.getLogger(Connection.class.getName());
    private Crypt _inCrypt;
    private Crypt _outCrypt;
    private byte[] _cryptkey;
    private final Socket _csocket;
    private final SocketChannel _chanell;
    byte readBufferFirstByte;
    ByteBuffer readBuffer;
    ByteBuffer writeBuffer;
    final ConcurrentLinkedQueue<ClientBasePacket> _receivedMsgQueue;
    final BasePacketQueue _sendMsgQueue;
    int writeTimeStamp;
    final ClientThread _client;

    public Connection(ClientThread client, Socket socket, byte[] cryptKey) {
        this._client = client;
        this._csocket = socket;
        this._chanell = this._csocket.getChannel();
        this._receivedMsgQueue = new ConcurrentLinkedQueue();
        this._sendMsgQueue = new BasePacketQueue();
        this._inCrypt = new Crypt();
        this._outCrypt = new Crypt();
        this._cryptkey = cryptKey;
    }

    public ClientThread getClient() {
        return this._client;
    }

    public synchronized void addReceivedMsg(ByteBuffer buf) {
        if (Config.ASSERT) assert (Thread.currentThread() == SelectorThread.instance);
        ClientBasePacket pkt = PacketHandler.handlePacket(buf, this._client);
        if (pkt != null) {
            if (pkt.getPriority() == TaskPriority.PR_URGENT) {
                pkt.run();
            } else {
                ClientScheduler.addReceivedMsg(pkt);
            }
        }
    }

    synchronized ClientBasePacket getNextReceivedMsg() {
        if (Config.ASSERT) assert (Thread.currentThread() != SelectorThread.instance);
        if (this._receivedMsgQueue.isEmpty()) {
            return null;
        }
        return (ClientBasePacket)this._receivedMsgQueue.remove();
    }

    public void sendPacket(byte[] data) {
        if (Config.DEBUG && _log.isLoggable(Level.FINEST)) {
            _log.finest("\n" + this.printData(data, data.length));
        }
        WrappedMessage msg = new WrappedMessage(data, this);
        SelectorThread.instance.sendMessage(msg);
    }

    public void sendPacket(ServerBasePacket bp) {
        bp = (ServerBasePacket)bp.setConnection(this);
        SelectorThread.instance.sendMessage(bp);
    }

    public void activateCryptKey() {
        this._inCrypt.setKey(this._cryptkey);
        this._outCrypt.setKey(this._cryptkey);
    }

    public void decript(ByteBuffer b) {
        this._inCrypt.decrypt(b);
    }

    public void encript(ByteBuffer b) {
        this._outCrypt.encrypt(b);
    }

    public byte[] getCryptKey() {
        return this._cryptkey;
    }

    public void close() {
        try {
            if (this._csocket != null && this._csocket.isConnected()) {
                this._csocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._client.getActiveChar() != null) {
                this._client.onDisconnect();
            }
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
    }

    public SocketChannel getChannel() {
        return this._chanell;
    }

    private String printData(byte[] data, int len) {
        byte t1;
        int a;
        int charpoint;
        StringBuffer result = new StringBuffer();
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            if (counter % 16 == 0) {
                result.append(this.fillHex(i, 4) + ": ");
            }
            result.append(this.fillHex(data[i] & 0xFF, 2) + " ");
            if (++counter != 16) continue;
            result.append("   ");
            charpoint = i - 15;
            for (a = 0; a < 16; ++a) {
                if ((t1 = data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append("\n");
            counter = 0;
        }
        int rest = data.length % 16;
        if (rest > 0) {
            for (int i = 0; i < 17 - rest; ++i) {
                result.append("   ");
            }
            charpoint = data.length - rest;
            for (a = 0; a < rest; ++a) {
                if ((t1 = data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append("\n");
        }
        return result.toString();
    }

    private String fillHex(int data, int digits) {
        String number = Integer.toHexString(data);
        for (int i = number.length(); i < digits; ++i) {
            number = "0" + number;
        }
        return number;
    }
}

