/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;

public final class ClientScheduler {
    static Logger _log = Logger.getLogger(ClientScheduler.class.getName());
    public static final int PRIORITY_URGENT = 3;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_MEDIUM = 1;
    public static final int PRIORITY_LOW = 0;
    private static final ClientScheduler _instance = new ClientScheduler();
    private final ScheduledThreadPoolExecutor _executorHighPriority;
    private final ScheduledThreadPoolExecutor _executorMedPriority;
    private final ScheduledThreadPoolExecutor _executorLowPriority;

    public static final ClientScheduler getInstance() {
        return _instance;
    }

    private ClientScheduler() {
        if (Config.ASSERT) assert (_instance == null);
        this._executorHighPriority = new ScheduledThreadPoolExecutor(4, new ThrFactory(1, "PoolHIGH"));
        this._executorMedPriority = new ScheduledThreadPoolExecutor(10, new ThrFactory(0, "PoolMED"));
        this._executorLowPriority = new ScheduledThreadPoolExecutor(4, new ThrFactory(-1, "PoolLOW"));
    }

    public void closeAll() {
        try {
            this._executorHighPriority.shutdown();
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
        try {
            this._executorMedPriority.shutdown();
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
        try {
            this._executorLowPriority.shutdown();
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
        try {
            this._executorHighPriority.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
        try {
            this._executorMedPriority.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
        try {
            this._executorLowPriority.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            _log.log(Level.WARNING, "", t);
        }
        this._executorHighPriority.shutdownNow();
        this._executorHighPriority.shutdownNow();
        this._executorHighPriority.shutdownNow();
    }

    public static void addReceivedMsg(ClientBasePacket pkt) {
        TaskPriority pr = pkt.getPriority();
        if (pr == null) {
            pr = TaskPriority.PR_LOW;
        }
        switch (pr) {
            case PR_URGENT: {
                pkt.run();
                return;
            }
            case PR_HIGH: {
                ClientScheduler._instance._executorHighPriority.execute(pkt);
                return;
            }
            case PR_MEDIUM: {
                ClientScheduler._instance._executorMedPriority.execute(pkt);
                return;
            }
        }
        ClientScheduler._instance._executorLowPriority.execute(pkt);
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable r, TaskPriority pr, long initial, long delay) {
        switch (pr) {
            case PR_HIGH: {
                return this.scheduleHighAtFixedRate(r, initial, delay);
            }
            case PR_MEDIUM: {
                return this.scheduleMedAtFixedRate(r, initial, delay);
            }
        }
        return this.scheduleLowAtFixedRate(r, initial, delay);
    }

    public ScheduledFuture scheduleHighAtFixedRate(Runnable r, long initial, long delay) {
        try {
            if (delay < 0L) {
                delay = 0L;
            }
            return this._executorHighPriority.scheduleAtFixedRate(r, initial, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture scheduleMedAtFixedRate(Runnable r, long initial, long delay) {
        try {
            if (delay < 0L) {
                delay = 0L;
            }
            return this._executorMedPriority.scheduleAtFixedRate(r, initial, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture scheduleLowAtFixedRate(Runnable r, long initial, long delay) {
        try {
            if (delay < 0L) {
                delay = 0L;
            }
            return this._executorLowPriority.scheduleAtFixedRate(r, initial, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture schedule(Runnable r, TaskPriority pr, long delay) {
        switch (pr) {
            case PR_HIGH: {
                return this.scheduleHigh(r, delay);
            }
            case PR_MEDIUM: {
                return this.scheduleMed(r, delay);
            }
        }
        return this.scheduleLow(r, delay);
    }

    public ScheduledFuture scheduleHigh(Runnable r, long delay) {
        try {
            if (delay < 0L) {
                delay = 0L;
            }
            return this._executorHighPriority.schedule(r, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture scheduleMed(Runnable r, long delay) {
        try {
            if (delay < 0L) {
                delay = 0L;
            }
            return this._executorMedPriority.schedule(r, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture scheduleLow(Runnable r, long delay) {
        try {
            if (delay < 0L) {
                delay = 0L;
            }
            return this._executorLowPriority.schedule(r, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    class ThrFactory
    implements ThreadFactory {
        private final String _prefix;
        private final int _priority;
        private int _count;

        ThrFactory(int priority, String prefix) {
            this._prefix = prefix;
            this._priority = priority;
        }

        public Thread newThread(Runnable r) {
            Thread thr = new Thread(r, this._prefix + "-" + this._count);
            thr.setDaemon(true);
            thr.setPriority(5 + this._priority);
            ++this._count;
            return thr;
        }
    }
}

