/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.CastleUpdater;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.lib.MySqlUtils;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ClanMember;
import net.sf.l2j.gameserver.model.L2PcInstance;

public class ClanTable {
    private static Logger _log = Logger.getLogger(ClanTable.class.getName());
    private static ClanTable _instance;
    private HashMap<Integer, L2Clan> _clans = new HashMap();

    public static ClanTable getInstance() {
        if (_instance == null) {
            _instance = new ClanTable();
        }
        return _instance;
    }

    private ClanTable() {
    }

    public L2Clan getClan(int clanId) {
        L2Clan clan = this._clans.get(new Integer(clanId));
        if (clan == null && (clan = new L2Clan(clanId)) != null) {
            this._clans.put(clan.getClanId(), clan);
        }
        return clan;
    }

    public void initClans() {
        Integer[] clansWithCastle = MySqlUtils.getIntArray("clan_id", "clan_data", "hasCastle > 0");
        if (clansWithCastle != null) {
            for (Integer clanID : clansWithCastle) {
                _log.info("Setting clan updater for clanId: " + clanID);
                L2Clan clan = this.getClan(clanID);
                CastleUpdater cu = new CastleUpdater(clan);
                ClientScheduler.getInstance().scheduleLow(cu, 60000L);
            }
            _log.config("ClanTable: Loaded " + clansWithCastle.length + " ClanTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2Clan createClan(L2PcInstance player, String clanName) {
        Connection con = null;
        boolean clanExists = true;
        L2Clan clan = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_id FROM clan_data WHERE clan_name=?");
            statement.setString(1, clanName);
            ResultSet result = statement.executeQuery();
            clanExists = result.next();
            result.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("error while saving new clan to db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        if (!clanExists) {
            L2ClanMember leader = new L2ClanMember(player.getName(), player.getLevel(), player.getClassId().getId(), player.getObjectId());
            clan = new L2Clan(IdFactory.getInstance().getNextId(), clanName, leader);
            clan.store();
            player.setClan(clan);
            if (Config.DEBUG) {
                _log.fine("New clan created: " + clan.getClanId() + " " + clan.getName());
            }
            this._clans.put(new Integer(clan.getClanId()), clan);
        }
        return clan;
    }
}

