/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.SpawnTable;
import net.sf.l2j.gameserver.model.L2CastleGuardInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class CastleGuardsSpawner {
    private static Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private static CastleGuardsSpawner _instance;
    public static ArrayList<Integer> _castleGuards;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CastleGuardsSpawner() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id, template_id FROM castle_guards");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("template_id"));
                L2CastleGuardInstance castleguard = new L2CastleGuardInstance((Integer)rset.getInt("object_id"), template1);
                castleguard.setCurrentHpMp(castleguard.getMaxHp(), castleguard.getMaxMp());
                castleguard.spawnMe(castleguard.x, castleguard.y, castleguard.z);
                castleguard.OnSpawn();
                if (_castleGuards == null) {
                    _castleGuards = new ArrayList();
                }
                _castleGuards.add(rset.getInt("object_id"));
            }
            rset.close();
            statement.close();
        }
        catch (Exception e1) {
            _log.warning("spawn couldnt be initialized:" + e1);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        if (_castleGuards != null) {
            _log.config("CastleGuards Loaded " + L2CastleGuardInstance._castleGuards.size() + " Instances Created");
        }
    }

    public static CastleGuardsSpawner getInstance() {
        if (_instance == null) {
            _instance = new CastleGuardsSpawner();
        }
        return _instance;
    }
}

