/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.Iterator;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.BasePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasePacketQueue {
    BasePacket _first;
    BasePacket _last;

    BasePacketQueue() {
    }

    boolean isEmpty() {
        return this._first == null;
    }

    synchronized void put(BasePacket pkt) {
        if (Config.ASSERT) assert (pkt._queue == null);
        if (Config.ASSERT) assert (pkt._prev == null);
        if (Config.ASSERT) assert (pkt._next == null);
        pkt._queue = this;
        if (this._first == null) {
            this._first = this._last = pkt;
        } else {
            pkt._prev = this._last;
            this._last._next = pkt;
            this._last = pkt;
        }
    }

    synchronized BasePacket get() {
        if (this._first == null) {
            return null;
        }
        BasePacket pkt = this._first;
        this._first = pkt._next;
        pkt._queue = this;
        if (this._first == null) {
            this._last = null;
        } else {
            this._first._prev = null;
        }
        pkt._queue = null;
        pkt._prev = null;
        pkt._next = null;
        return pkt;
    }

    synchronized void remove(BasePacket pkt) {
        if (pkt == null || pkt._queue == null) {
            return;
        }
        if (Config.ASSERT) assert (pkt._queue == this);
        if (pkt._prev != null) {
            pkt._prev._next = pkt._next;
        }
        if (pkt._next != null) {
            pkt._next._prev = pkt._prev;
        }
        if (this._first == pkt) {
            this._first = pkt._next;
        }
        if (this._last == pkt) {
            this._last = pkt._prev;
        }
        pkt._queue = null;
        pkt._prev = null;
        pkt._next = null;
    }

    Iterator<BasePacket> iterator() {
        return new Iter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Iter
    implements Iterator<BasePacket> {
        private BasePacket _lastRet;
        private BasePacket _next;

        Iter() {
            this._next = BasePacketQueue.this._first;
        }

        @Override
        public void remove() {
            BasePacketQueue.this.remove(this._lastRet);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public BasePacket next() {
            if (this._next == null) {
                return null;
            }
            this._lastRet = this._next;
            this._next = this._next._next;
            return this._lastRet;
        }
    }
}

