/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j;

import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.PooledDataSource;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.sf.l2j.Config;

public class L2DatabaseFactory {
    private static L2DatabaseFactory _instance;
    private String _driver;
    private String _url;
    private String _login;
    private String _password;
    private int _maxConnections;
    private DataSource _source;
    static Logger _log;

    public L2DatabaseFactory() throws SQLException {
        try {
            Properties serverSettings = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/config/server.properties");
            serverSettings.load(is);
            is.close();
            this._driver = serverSettings.getProperty("Driver");
            this._url = serverSettings.getProperty("URL");
            this._login = serverSettings.getProperty("Login");
            this._password = serverSettings.getProperty("Password");
            String maxConnections = serverSettings.getProperty("MaximumDbConnections");
            try {
                this._maxConnections = Integer.parseInt(maxConnections);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this._maxConnections < 2) {
                this._maxConnections = 2;
                _log.warning("at least " + this._maxConnections + " db connections are required.");
            }
            PoolConfig config = new PoolConfig();
            config.setAutoCommitOnClose(true);
            config.setInitialPoolSize(1);
            config.setMinPoolSize(1);
            config.setMaxPoolSize(this._maxConnections);
            config.setMaxStatements(100);
            config.setIdleConnectionTestPeriod(0);
            config.setMaxIdleTime(0);
            Class.forName(this._driver).newInstance();
            if (Config.DEBUG) {
                _log.fine("Database Connection Working");
            }
            DataSource unpooled = DataSources.unpooledDataSource(this._url, this._login, this._password);
            this._source = DataSources.pooledDataSource(unpooled, config);
            this._source.getConnection().close();
        }
        catch (SQLException x) {
            if (Config.DEBUG) {
                _log.fine("Database Connection FAILED");
            }
            throw x;
        }
        catch (Exception e) {
            if (Config.DEBUG) {
                _log.fine("Database Connection FAILED");
            }
            throw new SQLException("could not init DB connection:" + e);
        }
    }

    public static L2DatabaseFactory getInstance() throws SQLException {
        if (_instance == null) {
            _instance = new L2DatabaseFactory();
        }
        return _instance;
    }

    public Connection getConnection() throws SQLException {
        return this._source.getConnection();
    }

    public int getBusyConnectionCount() throws SQLException {
        return ((PooledDataSource)this._source).getNumBusyConnectionsDefaultUser();
    }

    public int getIdleConnectionCount() throws SQLException {
        return ((PooledDataSource)this._source).getNumIdleConnectionsDefaultUser();
    }

    public void shutdown() {
        try {
            ((PooledDataSource)this._source).close();
        }
        catch (SQLException e) {
            _log.log(Level.INFO, "", e);
        }
        try {
            DataSources.destroy(this._source);
        }
        catch (SQLException e) {
            _log.log(Level.INFO, "", e);
        }
    }

    static {
        _log = Logger.getLogger(L2DatabaseFactory.class.getName());
    }
}

