package net.kldp.j2ee.kupload;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class MemoryMappedByteStream implements MappedByteStream {

	private ByteBuffer buffer;

	public MemoryMappedByteStream(InputStream in, int length) throws HttpServletUploadException {
		byte[] b = new byte[8192];
		buffer = ByteBuffer.allocate(length);
		int read;
		try {
			while ((read = in.read(b)) != -1)
				buffer.put(b, 0, read);
		} catch (Exception e) {
			throw new HttpServletUploadException("업로드 중에 에러가 발생했습니다.");
		}
	}

	public ByteBuffer getBuffer() {
		return buffer;
	}

	public byte getPosition(int position) {
		return buffer.get(position);
	}
}