package net.kldp.j2ee.kupload;

public final class HeaderParser {

	/**
	 * 파일이 맥용 바이너리 파일인지 확인한다.
	 * 
	 * @param dataHeader
	 * @return 파일이 맥용 바이너리인지 나타내는 boolean값
	 */
	public static boolean isMacBinary(String dataHeader) {
		return getContentType(dataHeader).indexOf("application/x-macbinary") > 0;
	}

	/**
	 * Form의 필드 이름을 추출한다.
	 * 
	 * @param dataHeader
	 * @return field Name
	 */
	public static String getFieldName(String dataHeader) {
		String token = "name=\"";
		int position = dataHeader.indexOf(token);
		if (position > 0) {
			int start = position + token.length();
			int end = dataHeader.indexOf("\"", start);
			if (start > 0 && end > 0)
				return dataHeader.substring(start, end);
		}
		return "";
	}

	/**
	 * 파일의 경로를 추출한다.
	 * 
	 * @param dataHeader
	 * @return filePath
	 */
	public static String getFilePath(String dataHeader) {
		String token = "filename=\"";
		int position = dataHeader.indexOf(token);
		if (position > 0) {
			int start = position + token.length();
			int end = dataHeader.indexOf("\"", start);
			if (start > 0 && end > 0)
				return dataHeader.substring(start, end);
		}
		return "";
	}

	/**
	 * 파일의 컨텐츠 타입을 추출한다.
	 * 
	 * @param dataHeader
	 * @return contentType
	 */
	public static String getContentType(String dataHeader) {
		String token = "Content-Type:";
		int start = dataHeader.indexOf(token) + token.length();
		if (start != -1) {
			int end = dataHeader.length();
			return dataHeader.substring(start, end);
		}
		return "";
	}

	/**
	 * 필드 타입 파일인지 확인한다.
	 * 
	 * @param dataHeader
	 * @return 필드 타입이 파일인지 나타내는 boolean값
	 */
	public static boolean isFile(String dataHeader) {
		return dataHeader.indexOf("filename") > 0;
	}
}