package net.kldp.j2ee.kupload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannel.MapMode;
import java.util.ArrayList;
import java.util.Random;

public class DiskMappedByteStream implements MappedByteStream {
	private static final int READ_SIZE = 8192;
	private int length;
	private InputStream in;
	private ByteBuffer buffer = null;
	private byte[] currentByte = new byte[READ_SIZE];
	private byte[] tempByte = new byte[READ_SIZE];
	private OutputStream out;
	private int currentReadedPosition = 0;
	private File file;
	private static ArrayList<File> filePool = new ArrayList<File>();

	public DiskMappedByteStream(InputStream in, int length) {
		this.in = in;
		this.length = length;
		this.out = createTempOutputStream();
		readStream();
	}

	private void readStream() {
		try {
			int read = in.read(tempByte);
			if (read != -1) {
				out.write(tempByte, 0, read);
				currentReadedPosition += read;
				currentByte = tempByte;
			} else {
				makeByteBuffer();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private void makeByteBuffer() {
		try {
			FileChannel channel = new FileInputStream(file).getChannel();
			buffer = channel.map(MapMode.READ_ONLY, 0, length);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private OutputStream createTempOutputStream() {
		String prefix = String.valueOf(System.currentTimeMillis());
		String suffix = String.valueOf(new Random().nextInt());
		OutputStream out = null;
		try {
			file = File.createTempFile(prefix, suffix);
			file.deleteOnExit();
			out = new BufferedOutputStream(new FileOutputStream(file), READ_SIZE * 4);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return out;
	}

	public byte getPosition(int position) {

		if (position > currentReadedPosition)
			readStream();

		if (position > length)
			return -1;
		return currentByte[currentReadedPosition - position];
	}

	public ByteBuffer getBuffer() {
		return buffer;
	}

	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		synchronized (filePool) {
			for (File f : filePool) {
				if (f.delete()) {
					filePool.remove(f);
				}
			}
			filePool.add(file);
		}
	}
}