/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.kldp.j2ee.kupload.ByteData;
import net.kldp.j2ee.kupload.DataSection;
import net.kldp.j2ee.kupload.FieldValue;
import net.kldp.j2ee.kupload.HttpServletUploadException;
import net.kldp.j2ee.kupload.MappedDiskFile;
import net.kldp.j2ee.kupload.Parameters;
import net.kldp.j2ee.kupload.UploadFiles;
import net.kldp.j2ee.kuploadold.HeaderParser;

public class HttpServletUpload {
    private UploadFiles uploadFiles = new UploadFiles();
    private Parameters parameters = new Parameters();
    private String encoding = "utf-8";
    private final int MEMORY_SIZE = 0x200000;

    public HttpServletUpload(HttpServletRequest httpServletRequest) throws HttpServletUploadException, IOException, ServletException {
        this.execute(httpServletRequest);
    }

    public HttpServletUpload(HttpServletRequest httpServletRequest, String string) throws HttpServletUploadException, IOException, ServletException {
        this.encoding = string;
        this.execute(httpServletRequest);
    }

    private void execute(HttpServletRequest httpServletRequest) throws IOException, HttpServletUploadException {
        DataSection dataSection = new DataSection((InputStream)httpServletRequest.getInputStream(), httpServletRequest.getContentLength(), 0x200000);
        while (this.seekNextDataSection(dataSection)) {
            String string = this.getDataHeader(dataSection);
            this.seekBinaryData(dataSection);
            if (HeaderParser.isFile((String)string)) {
                this.addFile(dataSection, string);
                continue;
            }
            this.addParameter(dataSection, string);
        }
    }

    private void addParameter(DataSection dataSection, String string) {
        this.parameters.putParameter(HeaderParser.getFieldName((String)string), new FieldValue(dataSection.getBuffer(), dataSection.start, dataSection.end, this.encoding));
    }

    public UploadFiles getUploadFiles() {
        return this.uploadFiles;
    }

    public Parameters getRequestParameters() {
        return this.parameters;
    }

    private boolean seekNextDataSection(DataSection dataSection) {
        if (dataSection.position == 0) {
            return this.seekFirstDataSection(dataSection);
        }
        if (dataSection.getPosition(dataSection.position + 1) == 45) {
            return false;
        }
        if (dataSection.position + 2 >= dataSection.length) {
            dataSection.position += 2;
            return false;
        }
        return true;
    }

    private boolean seekFirstDataSection(DataSection dataSection) {
        byte by;
        while (dataSection.position < dataSection.length && (by = dataSection.getPosition(dataSection.position)) != 13) {
            dataSection.boundary.append((char)by);
            ++dataSection.position;
        }
        ++dataSection.position;
        return dataSection.position != 2;
    }

    private void addFile(DataSection dataSection, String string) {
        if (HeaderParser.isMacBinary((String)string)) {
            dataSection.start += 128;
        }
        MappedDiskFile mappedDiskFile = new MappedDiskFile(dataSection.getBuffer(), dataSection.start, dataSection.end);
        mappedDiskFile.setFieldName(HeaderParser.getFieldName((String)string));
        mappedDiskFile.setContentType(HeaderParser.getContentType((String)string));
        mappedDiskFile.setFilePath(HeaderParser.getFilePath((String)string));
        this.uploadFiles.putFile(mappedDiskFile.getFieldName(), mappedDiskFile);
    }

    private void seekBinaryData(DataSection dataSection) {
        int n = 0;
        dataSection.start = dataSection.position;
        for (int i = dataSection.position; i <= dataSection.length; ++i) {
            if (dataSection.getPosition(i) == (byte)dataSection.boundary.charAt(n)) {
                if (n == dataSection.boundary.length() - 1) {
                    dataSection.end = i - dataSection.boundary.length() - 2;
                    break;
                }
                ++n;
                continue;
            }
            n = 0;
        }
        dataSection.position = dataSection.end + dataSection.boundary.length() + 3;
    }

    private String getDataHeader(DataSection dataSection) {
        ByteData byteData = new ByteData();
        while (true) {
            byte by;
            if ((by = dataSection.getPosition(dataSection.position)) == 13 && dataSection.getPosition(dataSection.position + 2) == 13) {
                dataSection.position += 2;
                break;
            }
            byteData.add(by);
            ++dataSection.position;
        }
        dataSection.position += 2;
        return byteData.toString(this.encoding);
    }
}

