/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.j2ee.kupload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Random;
import net.kldp.j2ee.kupload.MappedByteStream;

public class DiskMappedByteStream
implements MappedByteStream {
    private static final int READ_SIZE = 8192;
    private int length;
    private InputStream in;
    private ByteBuffer buffer = null;
    private byte[] currentByte = new byte[8192];
    private byte[] tempByte = new byte[8192];
    private OutputStream out;
    private int currentReadedPosition = 0;
    private File file;
    private static ArrayList<File> filePool = new ArrayList();

    public DiskMappedByteStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.length = n;
        this.out = this.createTempOutputStream();
        this.readStream();
    }

    private void readStream() {
        try {
            int n = this.in.read(this.tempByte);
            if (n != -1) {
                this.out.write(this.tempByte, 0, n);
                this.currentReadedPosition += n;
                this.currentByte = this.tempByte;
            } else {
                this.makeByteBuffer();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void makeByteBuffer() {
        try {
            FileChannel fileChannel = new FileInputStream(this.file).getChannel();
            this.buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private OutputStream createTempOutputStream() {
        String string = String.valueOf(System.currentTimeMillis());
        String string2 = String.valueOf(new Random().nextInt());
        BufferedOutputStream bufferedOutputStream = null;
        try {
            this.file = File.createTempFile(string, string2);
            this.file.deleteOnExit();
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file), 32768);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bufferedOutputStream;
    }

    @Override
    public byte getPosition(int n) {
        if (n > this.currentReadedPosition) {
            this.readStream();
        }
        if (n > this.length) {
            return -1;
        }
        return this.currentByte[this.currentReadedPosition - n];
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        ArrayList<File> arrayList = filePool;
        synchronized (arrayList) {
            for (File file : filePool) {
                if (!file.delete()) continue;
                filePool.remove(file);
            }
            filePool.add(this.file);
        }
    }
}

