package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

/**
 * 업로드 한 파일을 메로리에 임시 저장한후 ByteBuffer로 제공한다.
 * 
 */
class TempByteBuffer {

	private int size;
	private ByteBuffer buffer;

	/**
	 * 바이트 버퍼를 생성한다.
	 * 
	 * @param in
	 * @param size
	 * @throws IOException
	 * @throws HttpServletUploadException
	 */
	public TempByteBuffer(InputStream in, int size) throws IOException, HttpServletUploadException {
		byte[] b = new byte[8192];
		this.size = size;
		buffer = ByteBuffer.allocate(size);
		int read;
		try {
			while ((read = in.read(b)) != -1)
				buffer.put(b, 0, read);
		} catch (Exception e) {
			throw new HttpServletUploadException("업로드 중에 에러가 발생했습니다.");
		}
	}

	/**
	 * 생성된 바이트 버퍼를 리턴한다.
	 * 
	 * @return buffer
	 */
	public ByteBuffer getBuffer() {
		return buffer;
	}

	/**
	 * 크기를 리턴한다. 이 값은 request.getContentLength()와 같다.
	 * 
	 * @return　size
	 */
	public int getSize() {
		return size;
	}

	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		buffer = null;
	}
}