/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.kldp.j2ee.kupload.FormFile;
import net.kldp.j2ee.kupload.UploadFileInputStream;

class MappedDiskFile
implements FormFile {
    private String contentType = "";
    private String filePath = "";
    private int start;
    private int size;
    private ByteBuffer buffer;
    private String fieldName = "";

    protected MappedDiskFile(ByteBuffer byteBuffer, int n, int n2) {
        this.buffer = byteBuffer;
        this.start = n;
        this.size = n2 - n + 1;
    }

    @Override
    public void destroy() {
        this.buffer = null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public synchronized byte[] getFileData() throws IOException {
        this.buffer.position(this.start);
        byte[] byArray = new byte[this.size];
        this.buffer.get(byArray, 0, this.size);
        return byArray;
    }

    @Override
    public String getFileName() {
        int n = this.filePath.lastIndexOf(47);
        if (n != -1) {
            return this.filePath.substring(n + 1, this.filePath.length());
        }
        n = this.filePath.lastIndexOf(92);
        if (n != -1) {
            return this.filePath.substring(n + 1, this.filePath.length());
        }
        return this.filePath;
    }

    @Override
    public int getFileSize() {
        return this.size;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        return new UploadFileInputStream(this.buffer, this.start, this.size);
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    @Override
    public String getFileSuffix() {
        String string = this.getFileName();
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (string.lastIndexOf(46) > 0) {
            return string2;
        }
        return "";
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MappedDiskFile && this.hashCode() == object.hashCode()) {
            MappedDiskFile mappedDiskFile = (MappedDiskFile)object;
            if (this.fieldName.equals(mappedDiskFile.fieldName) && this.filePath.equals(mappedDiskFile.filePath)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 27 * this.start * this.size * this.fieldName.length() + 29;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.buffer = null;
    }
}

