/*
 * ۼ: 2005. 7. 7.
 * ۼ: ̰
 *   : 
 */
package net.koov.irc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Vector;

/**
 * @ۼ ̰
 * @ۼ 2005. 7. 7.
 * @ 2005. 7. 7.
 *
 */
public class KoovBot {
	
	// IO  
	private Socket					socket;
	private BufferedReader			in;
	private BufferedWriter			out;
	
	private static PrintWriter		log;
	
	//   
	private static String			serverVersion = "0.0.1";
	private boolean					running;
	
	private boolean					connected = false;
	
	//  ú

	/**
	 * 
	 */
	public KoovBot() {
		init();
	}

	/**
	 * ʱȭ ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 11.
	 * @: 2005. 7. 11.
	 *
	 */
	private void init() {
		try {
			if (log != null) {
				log.flush();
				log.close();
				log = null;
			}
			
			// Append
			log = new PrintWriter(new FileWriter("log.txt", true));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	/**
	 *  ϴ ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 *
	 */
	protected void connect() {
		try {
			socket = new Socket(Config.getServerAddress(), Config.getServerPort());
			System.out.println("Connecting to server....");
		} catch (Exception e) {
			System.err.println("Couldn't make connection .. try again!!!");
			e.getMessage();
			e.printStackTrace();
			System.err.println(Config.getServerAddress() + " " + Config.getServerPort());
			System.exit(0);
		}

		try {
			in		= new BufferedReader(new InputStreamReader(socket.getInputStream()));
			out		= new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
		} catch (Exception e) {
			System.err.println("Couldn't get I/O-Streams .. Exiting!");
			e.printStackTrace();
			System.exit(0);
		}

		return;
	}

	/**
	 * Ӳ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 *
	 */
	protected void disconnect() {
		try //Streams beenden
		{
			in.close();
			out.close();
		}

		catch (IOException e) {
			System.err.print("Error occured while trying to disconnect from IRC server");
			e.printStackTrace();
			System.exit(0);
		}

	}

	/**
	 * IRC  α ϴ ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 *
	 */
	protected void logon() {
		try //sending user info
		{
			System.out.println("logon");
			
			// Command:  USER
			// Parameters:  <username> <hostname> <servername> <realname> 
			out.write("user " + Config.getClientName().toLowerCase() + " " + Config.getClientAddress().toLowerCase() + " " + Config.getServerAddress().toLowerCase() + ": " + Config.getClientName());
			out.newLine();
			out.write("nick " + Config.getClientNick());
			out.newLine();
			
			System.out.println("Connected, logging on to IRC server " + Config.getServerAddress() + "!");
			
			//sendToServer("PRIVMSG nickserv :IDENTIFY " + botName.toLowerCase());
			out.newLine();
			out.flush();
			
		} catch (Exception e) {
			System.err.println("Error occured while logging on to IRC server ... Exiting!");
			e.printStackTrace();
			System.exit(0);
		}
	}

	/**
	 * IRC  α׿ϴ ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 *
	 */
	protected void logoff() {
		try {
			//if (!sendToServer("logging off from server");
			
			out.write("logging off from server");
			out.newLine();
			out.flush();
			
		} catch (Exception e) {
			System.err.println("Error occured while logging off from server");
			e.printStackTrace();
			System.exit(0);
		}

	}

	/**
	 *  ޼  ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 * @param message
	 * @return
	 */
	protected boolean send(String message) {
		debug("SEND:" + message);
		
		try {
			out.write(message);
			out.newLine();
			out.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return true;
	}

	/**
	 *   ޼ҵ
	 * Ÿ о μ óѴ.
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 *
	 */
	protected void service() //serves and handles IRC msgs
	{
		try {
			
			if (in.ready()) {
				String message = in.readLine();
				
				debug(message);
				
				if (message != null && message.length() > 0) {
					if (message.charAt(0) == ':') {
						processCommand(message.substring(1));
					}
					else {
						processFunction(message);
					}
				}
			}
		} catch (Exception e) {
			System.err.println("Error occured while handling messages");
			e.printStackTrace();
		}
	}

	/**
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 11.
	 * @: 2005. 7. 11.
	 * @param message
	 */
	private void processFunction(String message) {
		String[] tokens = message.split(" ");
		
		if (tokens != null && tokens.length > 0) {
			// PING ޼
			if (tokens[0].equalsIgnoreCase("PING")) {
				send("PONG " + tokens[1]);
			}
			else {
				debug("Unknown Function : " + message);
			}
		}
	}

	/**
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 11.
	 * @: 2005. 7. 11.
	 * @param string
	 */
	private void processCommand(String string) {
		String[] tokens = string.split(":", 2);
		String[] headers = tokens[0].split(" ");
		
		if (headers.length > 2) {
			if (headers[1].equalsIgnoreCase("NOTICE")) {
				connected = true;
			}
			// Ӹϰ
			else if (headers[1].equalsIgnoreCase("PRIVMSG")) {
				processOrder(headers, tokens[1]);
			}
			
		}
		
		for (int i = 0 ; i < headers.length ; i++) {
			System.out.println("HEADER[" + i + "] "+ headers[i]);
		}
		
		if (tokens.length > 1) {
			System.out.println("CONTENTS " + tokens[1]);
		}
	}
	
	/**
	 *  óϴ ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 11.
	 * @: 2005. 7. 11.
	 * @param who
	 * @param order
	 */
	private void processOrder(String[] headers, String msg) {
		String who = headers[0];
		String id = null;
		String hostUser = null;
		String hostAt = null;
		String channel = null;
		
		if (headers.length >= 3 && headers[2] != null && headers[2].charAt(0) == '#') {
			channel = headers[2];
		}
		
		if (who != null && who.indexOf("!") != -1 && who.indexOf("@") != -1) {
			id = who.substring(0, who.indexOf("!"));
			hostUser = who.substring(who.indexOf("!") + 1, who.indexOf("@"));
			hostAt = who.substring(who.indexOf("@") + 1);
		}
		
		if (msg.length() > 0 && msg.charAt(0) == '!') {
			String[] orders = msg.split(" ");
			
			//  ɾ
			if (orders[0].equalsIgnoreCase("!join") && orders.length >= 2) {
				if (isAuthUser(id, hostUser, hostAt)) {
					String tmpChan = "";
					for (int x = 1 ; x < orders.length ; x++) {
						tmpChan += orders[x] + ",";
					}
					
					send("JOIN " + tmpChan);
				}
				else {
					send("PRIVMSG " + id + " : ׿~");
				}
			}
			else if (orders[0].equalsIgnoreCase("!op")) {
				// Ѱ˻
				if (!isAuthUser(id, hostUser, hostAt)) {
					send("PRIVMSG " + id + " : ׿~");
				}
				else if (channel == null) {
					send("PRIVMSG " + id + " :ä ּ~");
				}
				// ׳ !op̶  ڱ ֱ
				else if (orders.length < 2) {
					send("MODE " + channel + " +o " + id);
				}
				else {
					if (isAuthUser(id, hostUser, hostAt)) {
						String tmpUsers = "";
						String tmpOps = "";
						for (int x = 1 ; x < orders.length ; x++) {
							tmpUsers += orders[x] + " ";
							tmpOps += "o";
						}
						
						send("MODE " + channel + " +" + tmpOps + " " + tmpUsers);
					}
				}
			}
			else if (orders[0].equalsIgnoreCase("!allop") || orders[0].equalsIgnoreCase("!!")) {
				
			}
		}
		
		System.out.println("id:" + id + "/hostUser:" + hostUser + "/hostAt:" + hostAt);
	}

	/**
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 11.
	 * @: 2005. 7. 11.
	 * @param id
	 * @param hostUser
	 * @param hostAt
	 * @return
	 */
	private boolean isAuthUser(String id, String hostUser, String hostAt) {
		boolean result = false;
		
		Vector authUser = Config.getAccounts();
		
		for (int i = 0 ; i < authUser.size() ; i++) {
			String[] user = (String[]) authUser.get(i);
			if (id.matches(user[0]) && hostAt.matches(user[2])) {
				result = true;
			}
		}
		
		return result;
	}

	/**
	 *  ŸƮ ޼ҵ
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println("+==============================================+\r\n");
		System.out.println("  KooV Bot " + serverVersion + " - Developed by KooV");
		System.out.println("+==============================================+\r\n");
		System.out.println("\n\n");

		KoovBot kb = new KoovBot();
		kb.connect();
		kb.logon();
		kb.running = true;

		while (kb.running) {
			kb.service();
			
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		kb.logoff();
		kb.disconnect();
	}
	
	public void debug(String msg) {
		if (log != null) {
			log.println(msg);
			log.flush();
		}
		
		System.out.println(msg);
	}
}
