/*
 * Decompiled with CFR 0.152.
 */
package klchateclipse;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class Tab
extends Composite {
    private SashForm sashForm = null;
    private StyledText chatLog = null;
    private List userList = null;

    public Tab(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.createSashForm();
        this.setLayout((Layout)gridLayout);
    }

    private void createSashForm() {
        GridData gridData3 = new GridData();
        gridData3.grabExcessVerticalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        this.sashForm = new SashForm((Composite)this, 0);
        this.chatLog = new StyledText((Composite)this.sashForm, 520);
        this.chatLog.setWordWrap(true);
        this.userList = new List((Composite)this.sashForm, 512);
        this.sashForm.setWeights(new int[]{80, 20});
        this.sashForm.setLayoutData((Object)gridData3);
    }

    private void autoscroll() {
        StyledTextContent doc = this.chatLog.getContent();
        int docLength = doc.getCharCount();
        if (docLength > 0) {
            this.chatLog.setCaretOffset(docLength);
            this.chatLog.showSelection();
        }
    }

    protected void output(String line) {
        final String outline = "\n" + line;
        this.chatLog.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Tab.this.chatLog.append(outline);
                Tab.this.autoscroll();
            }
        });
    }
}

