/***************************************************************************
 *   Copyright (C) 2004 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* kioslave for KDE to handle unalz files.
 * based on kio_p7zip source code.
 *
 * minsu kim <minsu.kim@gmail.com>
 */

/* $Id: unalz.h 2 2006-12-26 11:55:19Z minsu $ */

#ifndef _UNALZ_H_
#define _UNALZ_H_

#include <kio/global.h>
#include <kio/slavebase.h>

class QCString;
class KShellProcess;
class KProcess;
class KProcIO;
class KURL;
class QString;
class QStringList;

class kio_unalzProtocol : public QObject, public KIO::SlaveBase
{
Q_OBJECT
public:
    kio_unalzProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~kio_unalzProtocol();
    //virtual void mimetype(const KURL& url);
    virtual void get(const KURL& url);
    virtual void stat( const KURL & url );
    virtual void listDir( const KURL & url );
    virtual void del( const KURL &url, bool isFile );
    virtual void put(const KURL& url,int permissions,bool overwrite,bool resume);
protected:
    bool listArchive( const KURL &archiveUrl );
    KProcess *proc1;
    KIO::filesize_t processed;
    KProcIO *proc;
    QString unalzProgram;
    KURL archive;
    time_t archiveTime;
    QStringList archiveList;
public slots:
    void receivedData( KProcess *, char* buffer, int len );
protected:
    bool checkName( const KURL &url, KURL &archiveUrl, KURL &fileUrl );
};

#endif
