/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.widgets.Composite;

abstract class WebBrowser {
    Browser browser;
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    static Runnable MozillaClearSessions;
    static Runnable NativeClearSessions;

    WebBrowser() {
    }

    public void addCloseWindowListener(CloseWindowListener closeWindowListener) {
        CloseWindowListener[] closeWindowListenerArray = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, closeWindowListenerArray, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = closeWindowListenerArray;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = closeWindowListener;
    }

    public void addLocationListener(LocationListener locationListener) {
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, this.locationListeners.length);
        this.locationListeners = locationListenerArray;
        this.locationListeners[this.locationListeners.length - 1] = locationListener;
    }

    public void addOpenWindowListener(OpenWindowListener openWindowListener) {
        OpenWindowListener[] openWindowListenerArray = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, openWindowListenerArray, 0, this.openWindowListeners.length);
        this.openWindowListeners = openWindowListenerArray;
        this.openWindowListeners[this.openWindowListeners.length - 1] = openWindowListener;
    }

    public void addProgressListener(ProgressListener progressListener) {
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, this.progressListeners.length);
        this.progressListeners = progressListenerArray;
        this.progressListeners[this.progressListeners.length - 1] = progressListener;
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, this.statusTextListeners.length);
        this.statusTextListeners = statusTextListenerArray;
        this.statusTextListeners[this.statusTextListeners.length - 1] = statusTextListener;
    }

    public void addTitleListener(TitleListener titleListener) {
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, this.titleListeners.length);
        this.titleListeners = titleListenerArray;
        this.titleListeners[this.titleListeners.length - 1] = titleListener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        VisibilityWindowListener[] visibilityWindowListenerArray = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, visibilityWindowListenerArray, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = visibilityWindowListenerArray;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = visibilityWindowListener;
    }

    public abstract boolean back();

    public static void clearSessions() {
        if (NativeClearSessions != null) {
            NativeClearSessions.run();
        }
        if (MozillaClearSessions != null) {
            MozillaClearSessions.run();
        }
    }

    public abstract void create(Composite var1, int var2);

    public abstract boolean execute(String var1);

    public abstract boolean forward();

    public abstract String getUrl();

    public Object getWebBrowser() {
        return null;
    }

    public abstract boolean isBackEnabled();

    public boolean isFocusControl() {
        return false;
    }

    public abstract boolean isForwardEnabled();

    public abstract void refresh();

    public void removeCloseWindowListener(CloseWindowListener closeWindowListener) {
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.closeWindowListeners.length) {
            if (closeWindowListener == this.closeWindowListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] closeWindowListenerArray = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, closeWindowListenerArray, 0, n);
        System.arraycopy(this.closeWindowListeners, n + 1, closeWindowListenerArray, n, this.closeWindowListeners.length - n - 1);
        this.closeWindowListeners = closeWindowListenerArray;
    }

    public void removeLocationListener(LocationListener locationListener) {
        if (this.locationListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.locationListeners.length) {
            if (locationListener == this.locationListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, n);
        System.arraycopy(this.locationListeners, n + 1, locationListenerArray, n, this.locationListeners.length - n - 1);
        this.locationListeners = locationListenerArray;
    }

    public void removeOpenWindowListener(OpenWindowListener openWindowListener) {
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.openWindowListeners.length) {
            if (openWindowListener == this.openWindowListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] openWindowListenerArray = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, openWindowListenerArray, 0, n);
        System.arraycopy(this.openWindowListeners, n + 1, openWindowListenerArray, n, this.openWindowListeners.length - n - 1);
        this.openWindowListeners = openWindowListenerArray;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.progressListeners.length) {
            if (progressListener == this.progressListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, n);
        System.arraycopy(this.progressListeners, n + 1, progressListenerArray, n, this.progressListeners.length - n - 1);
        this.progressListeners = progressListenerArray;
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.statusTextListeners.length) {
            if (statusTextListener == this.statusTextListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, n);
        System.arraycopy(this.statusTextListeners, n + 1, statusTextListenerArray, n, this.statusTextListeners.length - n - 1);
        this.statusTextListeners = statusTextListenerArray;
    }

    public void removeTitleListener(TitleListener titleListener) {
        if (this.titleListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.titleListeners.length) {
            if (titleListener == this.titleListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, n);
        System.arraycopy(this.titleListeners, n + 1, titleListenerArray, n, this.titleListeners.length - n - 1);
        this.titleListeners = titleListenerArray;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.visibilityWindowListeners.length) {
            if (visibilityWindowListener == this.visibilityWindowListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] visibilityWindowListenerArray = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, visibilityWindowListenerArray, 0, n);
        System.arraycopy(this.visibilityWindowListeners, n + 1, visibilityWindowListenerArray, n, this.visibilityWindowListeners.length - n - 1);
        this.visibilityWindowListeners = visibilityWindowListenerArray;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public abstract boolean setText(String var1);

    public abstract boolean setUrl(String var1);

    public abstract void stop();
}

