/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CFRunLoopSourceContext;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    Event[] eventQueue;
    Callback actionCallback;
    Callback appleEventCallback;
    Callback clockCallback;
    Callback commandCallback;
    Callback controlCallback;
    Callback accessibilityCallback;
    Callback appearanceCallback;
    Callback drawItemCallback;
    Callback itemDataCallback;
    Callback itemNotificationCallback;
    Callback itemCompareCallback;
    Callback searchCallback;
    Callback trayItemCallback;
    Callback hitTestCallback;
    Callback keyboardCallback;
    Callback menuCallback;
    Callback mouseHoverCallback;
    Callback helpCallback;
    Callback observerCallback;
    Callback sourceCallback;
    Callback mouseCallback;
    Callback trackingCallback;
    Callback windowCallback;
    Callback colorCallback;
    Callback textInputCallback;
    Callback releaseCallback;
    Callback coreEventCallback;
    int actionProc;
    int appleEventProc;
    int clockProc;
    int commandProc;
    int controlProc;
    int appearanceProc;
    int accessibilityProc;
    int drawItemProc;
    int itemDataProc;
    int itemNotificationProc;
    int itemCompareProc;
    int helpProc;
    int searchProc;
    int trayItemProc;
    int hitTestProc;
    int keyboardProc;
    int menuProc;
    int mouseHoverProc;
    int observerProc;
    int sourceProc;
    int mouseProc;
    int trackingProc;
    int windowProc;
    int colorProc;
    int textInputProc;
    int releaseProc;
    int coreEventProc;
    EventTable eventTable;
    EventTable filterTable;
    int queue;
    int runLoop;
    int runLoopSource;
    int lastModifiers;
    int lastState;
    int lastX;
    int lastY;
    boolean disposing;
    boolean inPaint;
    boolean needsPaint;
    int gcWindow;
    int disposeWindow;
    int[] disposeWindowList;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    boolean runAsyncMessages = true;
    int freeSlot;
    int[] indexTable;
    int[] property;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT0 = 1937208368;
    Shell activeShell;
    int focusEvent;
    Control focusControl;
    Combo focusCombo;
    boolean ignoreFocus;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    static final int ID_TEMPORARY = 1000;
    static final int ID_START = 1001;
    Runnable[] disposeList;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    boolean allowTimers = true;
    Caret currentCaret;
    Callback caretCallback;
    int caretID;
    int caretProc;
    Control grabControl;
    int helpString;
    Widget helpWidget;
    int lastHelpX;
    int lastHelpY;
    int clickCount;
    int clickCountButton;
    Control currentControl;
    int mouseHoverID;
    boolean mouseMoved;
    int dragButton;
    int dragX;
    int dragY;
    int dragState;
    int dragModifiers;
    boolean dragging;
    Rect buttonInset;
    Rect tabFolderNorthInset;
    Rect tabFolderSouthInset;
    Rect comboInset;
    Rect editTextInset;
    Rect searchTextInset;
    boolean smallFonts;
    int kchrPtr;
    int[] kchrState = new int[1];
    Image errorImage;
    Image infoImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    boolean runSettings;
    RGBColor highlightColor;
    int dockImage;
    static int[][] KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {71, 16777299}, {114, 0x1000051}};
    static String APP_NAME = "SWT";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Object data;
    String[] keys;
    Object[] values;

    static {
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    static byte[] ascii(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return byArray;
    }

    static int translateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][0] == n) {
                return KeyTable[n2][1];
            }
            ++n2;
        }
        return 0;
    }

    static int untranslateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][1] == n) {
                return KeyTable[n2][0];
            }
            ++n2;
        }
        return 0;
    }

    int actionProc(int n, int n2) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.actionProc(n, n2);
        }
        return 0;
    }

    int appearanceProc(int n, int n2, int n3) {
        this.runSettings = true;
        this.wakeThread();
        return -9874;
    }

    int appleEventProc(int n, int n2, int n3) {
        int n4 = OS.GetEventClass(n2);
        int n5 = OS.GetEventKind(n2);
        switch (n4) {
            case 1634758764: {
                switch (n5) {
                    case 110: {
                        if (this.dockImage == 0) break;
                        int[] nArray = new int[1];
                        OS.GetEventParameter(n2, 2003335487, 1835100014, null, 4, null, nArray);
                        if (nArray[0] != 1) break;
                        OS.SetApplicationDockTileImage(this.dockImage);
                    }
                }
                break;
            }
            case 1701867619: {
                EventRecord eventRecord = new EventRecord();
                boolean bl = false;
                if (OS.IsEventInQueue(this.queue, n2)) {
                    OS.RetainEvent(n2);
                    bl = true;
                    OS.RemoveEventFromQueue(this.queue, n2);
                }
                OS.ConvertEventRefToEventRecord(n2, eventRecord);
                OS.AEProcessAppleEvent(eventRecord);
                if (!bl) break;
                OS.ReleaseEvent(n2);
            }
        }
        return -9874;
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == null) {
                menu.id = (short)(1001 + n);
                this.menus[n] = menu;
                return;
            }
            ++n;
        }
        Menu[] menuArray = new Menu[this.menus.length + 12];
        menu.id = (short)(1001 + this.menus.length);
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n = this.popups.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    void addToDisposeWindow(int n) {
        int[] nArray = new int[1];
        if (this.disposeWindow == 0) {
            int[] nArray2 = new int[1];
            OS.CreateNewWindow(14, 0, new Rect(), nArray2);
            this.disposeWindow = nArray2[0];
            OS.CreateRootControl(this.disposeWindow, nArray);
        } else {
            OS.GetRootControl(this.disposeWindow, nArray);
        }
        OS.EmbedControl(n, nArray[0]);
    }

    void addWidget(int n, Widget widget) {
        int n2;
        if (n == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n2 = this.freeSlot + 1024;
            int[] nArray = new int[n2];
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            int n3 = this.freeSlot;
            while (n3 < n2 - 1) {
                nArray[n3] = n3 + 1;
                ++n3;
            }
            nArray[n2 - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        this.property[0] = this.freeSlot + 1;
        OS.SetControlProperty(n, 1937208368, 1937208368, 4, this.property);
        n2 = this.freeSlot;
        this.freeSlot = this.indexTable[n2];
        this.indexTable[n2] = -2;
        this.widgetTable[n2] = widget;
    }

    void addDisposeWindow(int n) {
        if (this.disposeWindowList == null) {
            this.disposeWindowList = new int[4];
        }
        int n2 = this.disposeWindowList.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.disposeWindowList[n3] == n) {
                return;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (this.disposeWindowList[n3] == 0) break;
            ++n3;
        }
        if (n3 == n2) {
            int[] nArray = new int[n2 + 4];
            System.arraycopy(this.disposeWindowList, 0, nArray, 0, n2);
            this.disposeWindowList = nArray;
        }
        this.disposeWindowList[n3] = n;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.SysBeep((short)100);
    }

    int caretProc(int n, int n2) {
        if (this.currentCaret == null || this.currentCaret.isDisposed()) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int n3 = this.currentCaret.blinkRate;
            if (n3 == 0) {
                return 0;
            }
            OS.SetEventLoopTimerNextFireTime(n, (double)n3 / 1000.0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    int[] createImage(int n) {
        int[] nArray = new int[1];
        int n2 = OS.GetIconRef((short)Short.MIN_VALUE, 1835098995, n, nArray);
        if (n2 != 0) {
            return null;
        }
        int[] nArray2 = new int[1];
        n2 = OS.IconRefToIconFamily(nArray[0], -1, nArray2);
        OS.ReleaseIconRef(nArray[0]);
        if (n2 != 0) {
            return null;
        }
        int[] nArray3 = this.createImageFromFamily(nArray2[0], 1768698674, 1815637355, 32, 32);
        OS.DisposeHandle(nArray2[0]);
        return nArray3;
    }

    int[] createImageFromFamily(int n, int n2, int n3, int n4, int n5) {
        int n6 = OS.NewHandle(0);
        int n7 = OS.GetIconFamilyData(n, n2, n6);
        if (n7 != 0) {
            OS.DisposeHandle(n6);
            return null;
        }
        int n8 = OS.NewHandle(0);
        n7 = OS.GetIconFamilyData(n, n3, n8);
        if (n7 != 0) {
            OS.DisposeHandle(n8);
            OS.DisposeHandle(n6);
            return null;
        }
        int n9 = n4 * 4;
        int n10 = OS.GetHandleSize(n6);
        int n11 = OS.NewPtrClear(n10);
        if (n11 == 0) {
            OS.DisposeHandle(n8);
            OS.DisposeHandle(n6);
            return null;
        }
        OS.HLock(n6);
        OS.HLock(n8);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.memmove(nArray, n6, 4);
        OS.memmove(nArray2, n8, 4);
        OS.memmove(n11, nArray[0], n10);
        int n12 = n10 / 4;
        int n13 = 0;
        while (n13 < n12) {
            OS.memmove(n11 + n13 * 4, nArray2[0] + n13, 1);
            ++n13;
        }
        OS.HUnlock(n8);
        OS.HUnlock(n6);
        OS.DisposeHandle(n8);
        OS.DisposeHandle(n6);
        n13 = OS.CGDataProviderCreateWithData(0, n11, n10, this.releaseProc);
        if (n13 == 0) {
            OS.DisposePtr(n11);
            return null;
        }
        int n14 = OS.CGColorSpaceCreateDeviceRGB();
        if (n14 == 0) {
            OS.CGDataProviderRelease(n13);
            return null;
        }
        int n15 = OS.CGImageCreate(n4, n5, 8, 32, n9, n14, 4, n13, null, true, 0);
        OS.CGColorSpaceRelease(n14);
        OS.CGDataProviderRelease(n13);
        return new int[]{n15, n11};
    }

    int createOverlayWindow() {
        int n = OS.GetMainDevice();
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        Rect rect = new Rect();
        OS.SetRect(rect, gDevice.left, gDevice.top, gDevice.right, gDevice.bottom);
        int[] nArray2 = new int[1];
        OS.CreateNewWindow(14, 0, rect, nArray2);
        if (nArray2[0] == 0) {
            SWT.error(2);
        }
        return nArray2[0];
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    static synchronized void checkDisplay(Thread thread, boolean bl) {
        int n = 0;
        while (n < Displays.length) {
            if (Displays[n] != null) {
                if (!bl) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[n].thread == thread) {
                    SWT.error(22);
                }
            }
            ++n;
        }
    }

    int colorProc(int n, int n2, int n3, int n4) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.colorProc(n, n2, n3, n4);
        }
        return -9874;
    }

    int commandProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        HICommand hICommand = new HICommand();
        OS.GetEventParameter(n2, 0x2D2D2D2D, 1751346532, null, 14, null, hICommand);
        switch (n4) {
            case 1: {
                if ((hICommand.attributes & 1) == 0) break;
                if (n3 != 0) {
                    Widget widget = this.getWidget(n3);
                    if (widget == null) break;
                    return widget.commandProc(n, n2, n3);
                }
                int n5 = -9874;
                int n6 = hICommand.menu_menuRef;
                short s = OS.GetMenuID(n6);
                Menu menu = this.getMenu(s);
                if (menu != null) {
                    MenuItem menuItem = null;
                    menuItem = menu.closed && menu.modified ? menu.lastTarget : menu.getItem(hICommand.menu_menuItemIndex - 1);
                    if (menuItem != null) {
                        n5 = menuItem.kEventProcessCommand(n, n2, n3);
                    }
                }
                OS.HiliteMenu((short)0);
                return n5;
            }
        }
        return -9874;
    }

    Rect computeInset(int n) {
        int n2 = OS.NewRgn();
        Rect rect = new Rect();
        OS.GetControlRegion(n, (short)-1, n2);
        OS.GetControlBounds(n, rect);
        Rect rect2 = new Rect();
        OS.GetRegionBounds(n2, rect2);
        OS.DisposeRgn(n2);
        rect.left = (short)(rect.left - rect2.left);
        rect.top = (short)(rect.top - rect2.top);
        rect.right = (short)(rect2.right - rect.right);
        rect.bottom = (short)(rect2.bottom - rect.bottom);
        return rect;
    }

    int clockProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget != null) {
            return widget.clockProc(n, n2, n3);
        }
        return -9874;
    }

    int controlProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget != null) {
            return widget.controlProc(n, n2, n3);
        }
        return -9874;
    }

    int coreEventProc(int n, int n2, int n3) {
        if (!this.disposing) {
            Event event = new Event();
            this.sendEvent(21, event);
            if (event.doit) {
                this.dispose();
            } else {
                return -128;
            }
        }
        return 0;
    }

    int accessibilityProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget != null) {
            return widget.accessibilityProc(n, n2, n3);
        }
        return -9874;
    }

    static String convertToLf(String string) {
        char c = '\r';
        char c2 = '\n';
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(c2, 0);
        if (n2 == -1 || n2 == 0) {
            return string;
        }
        if (string.charAt(n2 - 1) != c) {
            return string;
        }
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n) {
            int n3 = string.indexOf(c, n2);
            if (n3 == -1) {
                n3 = n;
            }
            String string2 = string.substring(n2, n3);
            stringBuffer.append(string2);
            n2 = n3 + 2;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    void clearMenuFlags() {
        if (this.menus == null) {
            return;
        }
        int n = 0;
        while (n < this.menus.length) {
            Menu menu = this.menus[n];
            if (menu != null) {
                menu.closed = false;
                menu.modified = false;
                menu.lastTarget = null;
            }
            ++n;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        int[] nArray;
        if (OS.VERSION < 4144) {
            System.out.println("***WARNING: SWT requires MacOS X version 10.3 or greater");
            System.out.println("***WARNING: Detected: " + Integer.toHexString((OS.VERSION & 0xFF00) >> 8) + "." + Integer.toHexString((OS.VERSION & 0xF0) >> 4) + "." + Integer.toHexString(OS.VERSION & 0xF));
        }
        if (OS.GetCurrentProcess(nArray = new int[2]) == 0) {
            int n;
            int n2 = OS.getpid();
            byte[] byArray = null;
            int n3 = OS.getenv(Display.ascii("APP_NAME_" + n2));
            if (n3 != 0) {
                byArray = new byte[OS.strlen(n3) + 1];
                OS.memmove(byArray, n3, byArray.length);
            } else if (APP_NAME != null) {
                char[] cArray = new char[APP_NAME.length()];
                APP_NAME.getChars(0, cArray.length, cArray, 0);
                int n4 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (n4 != 0) {
                    int[] nArray2;
                    CFRange cFRange = new CFRange();
                    cFRange.length = cArray.length;
                    int n5 = OS.CFStringGetSystemEncoding();
                    int n6 = OS.CFStringGetBytes(n4, cFRange, n5, (byte)63, true, null, 0, nArray2 = new int[1]);
                    if (n6 != 0) {
                        byArray = new byte[nArray2[0] + 1];
                        n6 = OS.CFStringGetBytes(n4, cFRange, n5, (byte)63, true, byArray, nArray2[0], nArray2);
                    }
                    OS.CFRelease(n4);
                }
            }
            if (byArray != null) {
                OS.CPSSetProcessName(nArray, byArray);
            }
            OS.CPSEnableForegroundOperation(nArray, 3, 60, 44, 4355);
            OS.SetFrontProcess(nArray);
            n3 = OS.getenv(Display.ascii("APP_ICON_" + n2));
            if (n3 != 0 && (n = this.readImageRef(n3)) != 0) {
                this.dockImage = n;
                OS.SetApplicationDockTileImage(this.dockImage);
            }
        }
        OS.ClearMenuBar();
        this.queue = OS.GetCurrentEventQueue();
        this.runLoop = OS.GetCFRunLoopFromEventLoop(OS.GetCurrentEventLoop());
        OS.TXNInitTextension(0, 0, 0);
        OS.RegisterAppearanceClient();
        this.highlightColor = new RGBColor();
        OS.GetThemeBrushAsColor((short)-3, (short)this.getDepth(), true, this.highlightColor);
    }

    static synchronized void deregister(Display display) {
        int n = 0;
        while (n < Displays.length) {
            if (display == Displays[n]) {
                Display.Displays[n] = null;
            }
            ++n;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n = 0;
        while (n < this.disposeList.length) {
            if (this.disposeList[n] == null) {
                this.disposeList[n] = runnable;
                return;
            }
            ++n;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    int drawItemProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.drawItemProc(n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    void disposeWindows() {
        if (this.disposeWindow != 0) {
            OS.DisposeWindow(this.disposeWindow);
            this.disposeWindow = 0;
        }
        if (this.disposeWindowList != null) {
            int n = 0;
            while (n < this.disposeWindowList.length) {
                if (this.disposeWindowList[n] != 0) {
                    OS.DisposeWindow(this.disposeWindowList[n]);
                }
                ++n;
            }
            this.disposeWindowList = null;
        }
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    public Widget findWidget(int n) {
        this.checkDevice();
        return this.getWidget(n);
    }

    public Widget findWidget(int n, int n2) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int n) {
        this.checkDevice();
        return null;
    }

    public static synchronized Display findDisplay(Thread thread) {
        int n = 0;
        while (n < Displays.length) {
            Display display = Displays[n];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++n;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        if (this.activeShell != null && !this.activeShell.isDisposed()) {
            return this.activeShell;
        }
        int n = 0;
        while (n < this.widgetTable.length) {
            Widget widget = this.widgetTable[n];
            if (widget != null && widget instanceof Shell) {
                Shell shell = (Shell)widget;
                if (OS.IsWindowActive(shell.shellHandle)) {
                    return shell;
                }
            }
            ++n;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n = OS.GetDeviceList();
        if (n == 0 || OS.GetNextDevice(n) == 0) {
            return super.getBounds();
        }
        Monitor[] monitorArray = this.getMonitors();
        Rectangle rectangle = monitorArray[0].getBounds();
        int n2 = 1;
        while (n2 < monitorArray.length) {
            rectangle = rectangle.union(monitorArray[n2].getBounds());
            ++n2;
        }
        return rectangle;
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return OS.GetCaretTime() * 1000 / 60;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int n = OS.GetDeviceList();
        if (n == 0 || OS.GetNextDevice(n) == 0) {
            return super.getClientArea();
        }
        Monitor[] monitorArray = this.getMonitors();
        Rectangle rectangle = monitorArray[0].getBounds();
        int n2 = 1;
        while (n2 < monitorArray.length) {
            rectangle = rectangle.union(monitorArray[n2].getBounds());
            ++n2;
        }
        return rectangle;
    }

    public Control getCursorControl() {
        Widget widget;
        Point point = new Point();
        OS.GetGlobalMouse(point);
        int[] nArray = new int[1];
        if (OS.FindWindow(point, nArray) != 3) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        Rect rect = new Rect();
        OS.GetWindowBounds(nArray[0], (short)33, rect);
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = point.h - rect.left;
        cGPoint.y = point.v - rect.top;
        int[] nArray2 = new int[1];
        OS.GetRootControl(nArray[0], nArray2);
        int[] nArray3 = new int[1];
        OS.HIViewGetSubviewHit(nArray2[0], cGPoint, true, nArray3);
        while (nArray3[0] != 0 && !OS.IsControlEnabled(nArray3[0])) {
            OS.GetSuperControl(nArray3[0], nArray3);
        }
        if (nArray3[0] != 0) {
            do {
                Control control;
                if ((widget = this.getWidget(nArray3[0])) != null && widget instanceof Control && (control = (Control)widget).isEnabled()) {
                    return control.isEnabledModal() ? control : null;
                }
                OS.GetSuperControl(nArray3[0], nArray3);
            } while (nArray3[0] != 0);
        }
        if ((widget = this.getWidget(nArray2[0])) != null && widget instanceof Control) {
            return (Control)widget;
        }
        return null;
    }

    public org.eclipse.swt.graphics.Point getCursorLocation() {
        this.checkDevice();
        Point point = new Point();
        OS.GetGlobalMouse(point);
        return new org.eclipse.swt.graphics.Point(point.h, point.v);
    }

    public org.eclipse.swt.graphics.Point[] getCursorSizes() {
        this.checkDevice();
        return new org.eclipse.swt.graphics.Point[]{new org.eclipse.swt.graphics.Point(16, 16)};
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        int n = OS.GetUserFocusWindow();
        if (n == 0) {
            return null;
        }
        return this.getFocusControl(n, false);
    }

    Control getFocusControl(int n, boolean bl) {
        int[] nArray = new int[1];
        OS.GetKeyboardFocus(n, nArray);
        if (nArray[0] == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(nArray[0])) != null && widget instanceof Control) {
                Control control = (Control)widget;
                if (bl) {
                    return control;
                }
                return control.isEnabled() ? control : null;
            }
            OS.GetSuperControl(nArray[0], nArray);
        } while (nArray[0] != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public org.eclipse.swt.graphics.Point[] getIconSizes() {
        this.checkDevice();
        return new org.eclipse.swt.graphics.Point[]{new org.eclipse.swt.graphics.Point(16, 16), new org.eclipse.swt.graphics.Point(32, 32), new org.eclipse.swt.graphics.Point(64, 64), new org.eclipse.swt.graphics.Point(128, 128)};
    }

    int getLastEventTime() {
        return (int)System.currentTimeMillis();
    }

    Menu[] getMenus(Decorations decorations) {
        Object object;
        if (this.menus == null) {
            return new Menu[0];
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.menus.length) {
            object = this.menus[n2];
            if (object != null && object.parent == decorations) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        object = new Menu[n];
        int n3 = 0;
        while (n3 < this.menus.length) {
            Menu menu = this.menus[n3];
            if (menu != null && menu.parent == decorations) {
                object[n2++] = menu;
            }
            ++n3;
        }
        return object;
    }

    Menu getMenu(int n) {
        if (this.menus == null) {
            return null;
        }
        int n2 = n - 1001;
        if (n2 >= 0 && n2 < this.menus.length) {
            return this.menus[n2];
        }
        return null;
    }

    Menu getMenuBar() {
        return this.menuBar;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        Object object;
        this.checkDevice();
        int n = 0;
        Monitor[] monitorArray = new Monitor[1];
        Rect rect = new Rect();
        GDevice gDevice = new GDevice();
        int n2 = OS.GetDeviceList();
        while (n2 != 0) {
            if (n >= monitorArray.length) {
                object = new Monitor[monitorArray.length + 4];
                System.arraycopy(monitorArray, 0, object, 0, monitorArray.length);
                monitorArray = object;
            }
            object = new Monitor();
            object.handle = n2;
            int[] nArray = new int[1];
            OS.memmove(nArray, n2, 4);
            OS.memmove(gDevice, nArray[0], 62);
            object.x = gDevice.left;
            object.y = gDevice.top;
            object.width = gDevice.right - gDevice.left;
            object.height = gDevice.bottom - gDevice.top;
            OS.GetAvailableWindowPositioningBounds(n2, rect);
            object.clientX = rect.left;
            object.clientY = rect.top;
            object.clientWidth = rect.right - rect.left;
            object.clientHeight = rect.bottom - rect.top;
            monitorArray[n++] = object;
            n2 = OS.GetNextDevice(n2);
        }
        if (n < monitorArray.length) {
            object = new Monitor[n];
            System.arraycopy(monitorArray, 0, object, 0, n);
            monitorArray = object;
        }
        return monitorArray;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        int n = OS.GetMainDevice();
        Monitor monitor = new Monitor();
        monitor.handle = n;
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        GDevice gDevice = new GDevice();
        OS.memmove(gDevice, nArray[0], 62);
        monitor.x = gDevice.left;
        monitor.y = gDevice.top;
        monitor.width = gDevice.right - gDevice.left;
        monitor.height = gDevice.bottom - gDevice.top;
        Rect rect = new Rect();
        OS.GetAvailableWindowPositioningBounds(n, rect);
        monitor.clientX = rect.left;
        monitor.clientY = rect.top;
        monitor.clientWidth = rect.right - rect.left;
        monitor.clientHeight = rect.bottom - rect.top;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        int n2 = 0;
        while (n2 < this.widgetTable.length) {
            Widget widget = this.widgetTable[n2];
            if (widget != null && widget instanceof Shell) {
                int n3 = 0;
                while (n3 < n) {
                    if (shellArray[n3] == widget) break;
                    ++n3;
                }
                if (n3 == n) {
                    if (n == shellArray.length) {
                        Shell[] shellArray2 = new Shell[n + 16];
                        System.arraycopy(shellArray, 0, shellArray2, 0, n);
                        shellArray = shellArray2;
                    }
                    shellArray[n++] = (Shell)widget;
                }
            }
            ++n2;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        RGBColor rGBColor = new RGBColor();
        switch (n) {
            case 28: {
                return super.getSystemColor(2);
            }
            case 29: {
                return Color.carbon_new(this, new float[]{1.0f, 1.0f, 0.88235295f, 1.0f});
            }
            case 30: {
                OS.GetThemeTextColor((short)23, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 31: {
                OS.GetThemeBrushAsColor((short)-5, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 32: {
                OS.GetThemeBrushAsColor((short)-3, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 33: {
                OS.GetThemeTextColor((short)24, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 34: {
                OS.GetThemeBrushAsColor((short)-4, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 35: {
                OS.GetThemeBrushAsColor((short)-4, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 17: {
                return Color.carbon_new(this, new float[]{0.2f, 0.2f, 0.2f, 1.0f});
            }
            case 18: {
                return Color.carbon_new(this, new float[]{0.4f, 0.4f, 0.4f, 1.0f});
            }
            case 19: {
                return Color.carbon_new(this, new float[]{0.6f, 0.6f, 0.6f, 1.0f});
            }
            case 20: {
                return Color.carbon_new(this, new float[]{0.8f, 0.8f, 0.8f, 1.0f});
            }
            case 22: {
                OS.GetThemeBrushAsColor((short)29, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 21: {
                OS.GetThemeTextColor((short)12, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 23: {
                return super.getSystemColor(2);
            }
            case 24: {
                OS.GetThemeTextColor((short)22, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 25: {
                OS.GetThemeBrushAsColor((short)10, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 27: {
                OS.GetThemeTextColor((short)22, (short)this.getDepth(), true, rGBColor);
                break;
            }
            case 26: {
                OS.GetThemeBrushAsColor((short)-3, (short)this.getDepth(), true, rGBColor);
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        float f = (float)(rGBColor.red >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(rGBColor.green >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(rGBColor.blue >> 8 & 0xFF) / 255.0f;
        return Color.carbon_new(this, new float[]{f, f2, f3, 1.0f});
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (n < 0 || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                int[] nArray = this.createImage(1937010544);
                if (nArray == null) break;
                this.errorImage = Image.carbon_new(this, 1, nArray[0], nArray[1]);
                return this.errorImage;
            }
            case 2: 
            case 4: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                int[] nArray = this.createImage(1852798053);
                if (nArray == null) break;
                this.infoImage = Image.carbon_new(this, 1, nArray[0], nArray[1]);
                return this.infoImage;
            }
            case 8: {
                if (this.warningImage != null) {
                    return this.warningImage;
                }
                int[] nArray = this.createImage(1667331444);
                if (nArray == null) break;
                this.warningImage = Image.carbon_new(this, 1, nArray[0], nArray[1]);
                return this.warningImage;
            }
        }
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    Widget getWidget(int n) {
        if (n == 0) {
            return null;
        }
        this.property[0] = 0;
        OS.GetControlProperty(n, 1937208368, 1937208368, 4, null, this.property);
        int n2 = this.property[0] - 1;
        if (n2 >= 0 && n2 < this.widgetTable.length) {
            return this.widgetTable[n2];
        }
        return null;
    }

    int helpProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.helpProc(n, n2, n3, n4, n5);
        }
        return -9874;
    }

    int hitTestProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.hitTestProc(n, n2, n3, n4, n5);
        }
        return 0;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeInsets();
        this.initializeWidgetTable();
        this.initializeFonts();
    }

    void initializeCallbacks() {
        this.actionCallback = new Callback(this, "actionProc", 2);
        this.actionProc = this.actionCallback.getAddress();
        if (this.actionProc == 0) {
            this.error(3);
        }
        this.appleEventCallback = new Callback(this, "appleEventProc", 3);
        this.appleEventProc = this.appleEventCallback.getAddress();
        if (this.appleEventProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 2);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.clockCallback = new Callback(this, "clockProc", 3);
        this.clockProc = this.clockCallback.getAddress();
        if (this.clockProc == 0) {
            this.error(3);
        }
        this.commandCallback = new Callback(this, "commandProc", 3);
        this.commandProc = this.commandCallback.getAddress();
        if (this.commandProc == 0) {
            this.error(3);
        }
        this.controlCallback = new Callback(this, "controlProc", 3);
        this.controlProc = this.controlCallback.getAddress();
        if (this.controlProc == 0) {
            this.error(3);
        }
        this.accessibilityCallback = new Callback(this, "accessibilityProc", 3);
        this.accessibilityProc = this.accessibilityCallback.getAddress();
        if (this.accessibilityProc == 0) {
            this.error(3);
        }
        this.drawItemCallback = new Callback(this, "drawItemProc", 7);
        this.drawItemProc = this.drawItemCallback.getAddress();
        if (this.drawItemProc == 0) {
            this.error(3);
        }
        this.itemCompareCallback = new Callback(this, "itemCompareProc", 4);
        this.itemCompareProc = this.itemCompareCallback.getAddress();
        if (this.itemCompareProc == 0) {
            this.error(3);
        }
        this.itemDataCallback = new Callback(this, "itemDataProc", 5);
        this.itemDataProc = this.itemDataCallback.getAddress();
        if (this.itemDataProc == 0) {
            this.error(3);
        }
        this.itemNotificationCallback = new Callback(this, "itemNotificationProc", 3);
        this.itemNotificationProc = this.itemNotificationCallback.getAddress();
        if (this.itemNotificationProc == 0) {
            this.error(3);
        }
        this.helpCallback = new Callback(this, "helpProc", 5);
        this.helpProc = this.helpCallback.getAddress();
        if (this.helpProc == 0) {
            this.error(3);
        }
        this.hitTestCallback = new Callback(this, "hitTestProc", 5);
        this.hitTestProc = this.hitTestCallback.getAddress();
        if (this.hitTestProc == 0) {
            this.error(3);
        }
        this.keyboardCallback = new Callback(this, "keyboardProc", 3);
        this.keyboardProc = this.keyboardCallback.getAddress();
        if (this.keyboardProc == 0) {
            this.error(3);
        }
        this.menuCallback = new Callback(this, "menuProc", 3);
        this.menuProc = this.menuCallback.getAddress();
        if (this.menuProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 2);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.mouseCallback = new Callback(this, "mouseProc", 3);
        this.mouseProc = this.mouseCallback.getAddress();
        if (this.mouseProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 2);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.trackingCallback = new Callback(this, "trackingProc", 6);
        this.trackingProc = this.trackingCallback.getAddress();
        if (this.trackingProc == 0) {
            this.error(3);
        }
        this.windowCallback = new Callback(this, "windowProc", 3);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.colorCallback = new Callback(this, "colorProc", 4);
        this.colorProc = this.colorCallback.getAddress();
        if (this.colorProc == 0) {
            this.error(3);
        }
        this.textInputCallback = new Callback(this, "textInputProc", 3);
        this.textInputProc = this.textInputCallback.getAddress();
        if (this.textInputProc == 0) {
            this.error(3);
        }
        this.appearanceCallback = new Callback(this, "appearanceProc", 3);
        this.appearanceProc = this.appearanceCallback.getAddress();
        if (this.appearanceProc == 0) {
            this.error(3);
        }
        this.trayItemCallback = new Callback(this, "trayItemProc", 4);
        this.trayItemProc = this.trayItemCallback.getAddress();
        if (this.trayItemProc == 0) {
            this.error(3);
        }
        this.observerCallback = new Callback(this, "observerProc", 3);
        this.observerProc = this.observerCallback.getAddress();
        if (this.observerProc == 0) {
            this.error(3);
        }
        this.sourceCallback = new Callback(this, "sourceProc", 1);
        this.sourceProc = this.sourceCallback.getAddress();
        if (this.sourceProc == 0) {
            this.error(3);
        }
        this.searchCallback = new Callback(this, "searchProc", 3);
        this.searchProc = this.searchCallback.getAddress();
        if (this.searchProc == 0) {
            this.error(3);
        }
        this.releaseCallback = new Callback(this, "releaseDataProc", 3);
        this.releaseProc = this.releaseCallback.getAddress();
        if (this.releaseProc == 0) {
            SWT.error(3);
        }
        this.coreEventCallback = new Callback(this, "coreEventProc", 3);
        this.coreEventProc = this.coreEventCallback.getAddress();
        if (this.coreEventProc == 0) {
            SWT.error(3);
        }
        int[] nArray = new int[]{1668113523, 1};
        int n = OS.GetApplicationEventTarget();
        OS.InstallEventHandler(n, this.commandProc, nArray.length / 2, nArray, 0, null);
        int[] nArray2 = new int[]{1836021107, 1, 1836021107, 6, 1836021107, 5, 1836021107, 2, 1836021107, 10};
        OS.InstallEventHandler(n, this.mouseProc, nArray2.length / 2, nArray2, 0, null);
        int[] nArray3 = new int[]{1634758764, 110, 1701867619, 1};
        OS.InstallEventHandler(n, this.appleEventProc, nArray3.length / 2, nArray3, 0, null);
        OS.AEInstallEventHandler(1634039412, 1903520116, this.coreEventProc, 0, false);
        int[] nArray4 = new int[]{1801812322, 1, 1801812322, 4, 1801812322, 2, 1801812322, 3};
        int n2 = OS.GetUserFocusEventTarget();
        OS.InstallEventHandler(n2, this.keyboardProc, nArray4.length / 2, nArray4, 0, null);
        int[] nArray5 = new int[]{1952807028, 2};
        OS.InstallEventHandler(n2, this.textInputProc, nArray5.length / 2, nArray5, 0, null);
        OS.AEInstallEventHandler(1634758770, 1953000805, this.appearanceProc, 0, false);
        OS.AEInstallEventHandler(1634758770, 1936942702, this.appearanceProc, 0, false);
        OS.AEInstallEventHandler(1634758770, 1937339238, this.appearanceProc, 0, false);
        OS.AEInstallEventHandler(1634758770, 1986424436, this.appearanceProc, 0, false);
        int n3 = OS.kCFRunLoopCommonModes();
        int n4 = 32;
        int n5 = OS.CFRunLoopObserverCreate(0, n4, true, 0, this.observerProc, 0);
        if (n5 == 0) {
            this.error(2);
        }
        OS.CFRunLoopAddObserver(this.runLoop, n5, n3);
        OS.CFRelease(n5);
        CFRunLoopSourceContext cFRunLoopSourceContext = new CFRunLoopSourceContext();
        cFRunLoopSourceContext.version = 0;
        cFRunLoopSourceContext.perform = this.sourceProc;
        this.runLoopSource = OS.CFRunLoopSourceCreate(0, 0, cFRunLoopSourceContext);
        if (this.runLoopSource == 0) {
            this.error(2);
        }
        OS.CFRunLoopAddSource(this.runLoop, this.runLoopSource, n3);
    }

    void initializeFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
    }

    void initializeInsets() {
        int[] nArray = new int[1];
        Rect rect = new Rect();
        rect.bottom = (short)200;
        rect.right = (short)200;
        OS.CreatePushButtonControl(0, rect, 0, nArray);
        this.buttonInset = this.computeInset(nArray[0]);
        OS.DisposeControl(nArray[0]);
        OS.CreateTabsControl(0, rect, (short)0, (short)0, (short)0, 0, nArray);
        this.tabFolderNorthInset = this.computeInset(nArray[0]);
        OS.DisposeControl(nArray[0]);
        OS.CreateTabsControl(0, rect, (short)0, (short)1, (short)0, 0, nArray);
        this.tabFolderSouthInset = this.computeInset(nArray[0]);
        OS.DisposeControl(nArray[0]);
        OS.CreateEditUnicodeTextControl(0, rect, 0, false, null, nArray);
        this.editTextInset = this.computeInset(nArray[0]);
        OS.DisposeControl(nArray[0]);
        int n = 3;
        OS.HISearchFieldCreate(null, n, 0, 0, nArray);
        if (this.smallFonts) {
            OS.SetControlData(nArray[0], 0, 1936292453, 2, new short[]{1});
        }
        this.searchTextInset = this.computeInset(nArray[0]);
        this.editTextInset.bottom = this.editTextInset.top;
        OS.DisposeControl(nArray[0]);
        CGRect cGRect = new CGRect();
        cGRect.height = 200.0f;
        cGRect.width = 200.0f;
        int n2 = 9;
        OS.HIComboBoxCreate(cGRect, 0, null, 0, n2, nArray);
        this.comboInset = this.computeInset(nArray[0]);
        this.comboInset.bottom = this.comboInset.top;
        OS.DisposeControl(nArray[0]);
    }

    void initializeWidgetTable() {
        this.property = new int[1];
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int n = 0;
        while (n < 1023) {
            this.indexTable[n] = n + 1;
            ++n;
        }
        this.indexTable[1023] = -1;
    }

    public int internal_new_GC(GCData gCData) {
        Rect rect;
        int[] nArray;
        int n;
        int n2;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((n2 = this.gcWindow) == 0) {
            n2 = this.gcWindow = this.createOverlayWindow();
        } else {
            n = OS.GetMainDevice();
            nArray = new int[1];
            OS.memmove(nArray, n, 4);
            GDevice gDevice = new GDevice();
            OS.memmove(gDevice, nArray[0], 62);
            rect = new Rect();
            OS.SetRect(rect, gDevice.left, gDevice.top, gDevice.right, gDevice.bottom);
            OS.SetWindowBounds(n2, 32, rect);
        }
        n = OS.GetWindowPort(n2);
        nArray = new int[1];
        OS.CreateCGContextForPort(n, nArray);
        int n3 = nArray[0];
        if (n3 == 0) {
            SWT.error(2);
        }
        rect = new Rect();
        OS.GetPortBounds(n, rect);
        OS.CGContextScaleCTM(n3, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(n3, 0.0f, rect.top - rect.bottom);
        if (gCData != null) {
            int n4 = 0x6000000;
            if ((gCData.style & n4) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.window = n2;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
            gCData.updateClip = true;
            gCData.portRect = rect;
        } else {
            OS.ShowWindow(n2);
        }
        return n3;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (gCData != null) {
            int n2 = gCData.window;
            if (this.gcWindow == n2) {
                OS.HideWindow(n2);
            } else {
                OS.DisposeWindow(n2);
            }
            gCData.window = 0;
        }
        OS.CGContextSynchronize(n);
        OS.CGContextRelease(n);
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    int itemCompareProc(int n, int n2, int n3, int n4) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.itemCompareProc(n, n2, n3, n4);
        }
        return 0;
    }

    int itemDataProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.itemDataProc(n, n2, n3, n4, n5);
        }
        return 0;
    }

    int itemNotificationProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.itemNotificationProc(n, n2, n3);
        }
        return 0;
    }

    int keyboardProc(int n, int n2, int n3) {
        int n4 = OS.GetUserFocusWindow();
        if (n4 != 0) {
            int[] nArray = new int[1];
            OS.GetKeyboardFocus(n4, nArray);
            Widget widget = this.getWidget(nArray[0]);
            if (widget != null) {
                return widget.keyboardProc(n, n2, n3);
            }
        }
        return -9874;
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        int n = event.type;
        switch (n) {
            case 1: 
            case 2: {
                short s;
                int n2 = Display.untranslateKey(event.keyCode);
                if (n2 != 0) {
                    return OS.CGPostKeyboardEvent(0, n2, n == 1) == 0;
                }
                n2 = -1;
                int n3 = OS.GetScriptManagerVariable((short)38);
                int n4 = -1;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                short s2 = (short)OS.GetScriptManagerVariable((short)22);
                if (OS.UpgradeScriptInfoToTextEncoding(s2, (short)-128, s = (short)OS.GetScriptManagerVariable((short)40), null, nArray2) == -50 && OS.UpgradeScriptInfoToTextEncoding(s2, (short)-128, (short)-128, null, nArray2) == -50) {
                    nArray2[0] = 0;
                }
                int[] nArray3 = new int[1];
                OS.CreateUnicodeToTextInfoByEncoding(nArray2[0], nArray3);
                if (nArray3[0] != 0) {
                    char[] cArray = new char[]{event.character};
                    byte[] byArray = new byte[2];
                    OS.ConvertFromUnicodeToPString(nArray3[0], 2, cArray, byArray);
                    OS.DisposeUnicodeToTextInfo(nArray3);
                    n4 = byArray[1] & 0x7F;
                }
                if (n4 == -1) {
                    return false;
                }
                int n5 = 0;
                while (n5 <= 127) {
                    int n6 = OS.KeyTranslate(n3, (short)(n5 | 0x200), nArray);
                    int n7 = OS.KeyTranslate(n3, (short)n5, nArray);
                    if ((n6 & 0x7F) == n4 || (n7 & 0x7F) == n4) {
                        n2 = n5;
                        break;
                    }
                    ++n5;
                }
                if (n2 == -1) {
                    return false;
                }
                return OS.CGPostKeyboardEvent(n4, n2, n == 1) == 0;
            }
            case 3: 
            case 4: 
            case 5: {
                CGPoint cGPoint = new CGPoint();
                int n8 = OS.GetCurrentEventButtonState();
                if (n == 5) {
                    cGPoint.x = event.x;
                    cGPoint.y = event.y;
                    return OS.CGPostMouseEvent(cGPoint, true, 5, (n8 & 1) != 0, (n8 & 2) != 0, (n8 & 4) != 0, (n8 & 8) != 0, (n8 & 0x10) != 0) == 0;
                }
                int n9 = event.button;
                if (n9 < 1 || n9 > 5) {
                    return false;
                }
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                switch (n9) {
                    case 1: {
                        bl = n == 3;
                        bl2 = (n8 & 4) != 0;
                        bl3 = (n8 & 2) != 0;
                        bl4 = (n8 & 8) != 0;
                        bl5 = (n8 & 0x10) != 0;
                        break;
                    }
                    case 2: {
                        bl = (n8 & 1) != 0;
                        bl2 = n == 3;
                        bl3 = (n8 & 2) != 0;
                        bl4 = (n8 & 8) != 0;
                        bl5 = (n8 & 0x10) != 0;
                        break;
                    }
                    case 3: {
                        bl = (n8 & 1) != 0;
                        bl2 = (n8 & 4) != 0;
                        bl3 = n == 3;
                        bl4 = (n8 & 8) != 0;
                        bl5 = (n8 & 0x10) != 0;
                        break;
                    }
                    case 4: {
                        bl = (n8 & 1) != 0;
                        bl2 = (n8 & 4) != 0;
                        bl3 = (n8 & 2) != 0;
                        bl4 = n == 3;
                        bl5 = (n8 & 0x10) != 0;
                        break;
                    }
                    case 5: {
                        bl = (n8 & 1) != 0;
                        bl2 = (n8 & 4) != 0;
                        bl3 = (n8 & 2) != 0;
                        bl4 = (n8 & 8) != 0;
                        bl5 = n == 3;
                    }
                }
                Point point = new Point();
                OS.GetGlobalMouse(point);
                cGPoint.x = point.h;
                cGPoint.y = point.v;
                return OS.CGPostMouseEvent(cGPoint, true, 5, bl, bl3, bl2, bl4, bl5) == 0;
            }
            case 37: {
                return OS.CGPostScrollWheelEvent(1, event.count) == 0;
            }
        }
        return false;
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n = 0;
        int n2 = this.eventQueue.length;
        while (n < n2) {
            if (this.eventQueue[n] == null) break;
            ++n;
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    public org.eclipse.swt.graphics.Point map(Control control, Control control2, org.eclipse.swt.graphics.Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point map(Control control, Control control2, int n, int n2) {
        Rect rect;
        CGPoint cGPoint;
        int n3;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(n, n2);
        if (control == control2) {
            return point;
        }
        Rect rect2 = new Rect();
        if (control != null) {
            n3 = OS.GetControlOwner(control.handle);
            cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, control.handle, 0);
            point.x += (int)cGPoint.x;
            point.y += (int)cGPoint.y;
            OS.GetWindowBounds(n3, (short)32, rect2);
            point.x += rect2.left;
            point.y += rect2.top;
            rect = control.getInset();
            point.x -= rect.left;
            point.y -= rect.top;
        }
        if (control2 != null) {
            n3 = OS.GetControlOwner(control2.handle);
            cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, control2.handle, 0);
            point.x -= (int)cGPoint.x;
            point.y -= (int)cGPoint.y;
            OS.GetWindowBounds(n3, (short)32, rect2);
            point.x -= rect2.left;
            point.y -= rect2.top;
            rect = control2.getInset();
            point.x += rect.left;
            point.y += rect.top;
        }
        return point;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        Rect rect;
        CGPoint cGPoint;
        int n5;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        Rect rect2 = new Rect();
        if (control != null) {
            n5 = OS.GetControlOwner(control.handle);
            cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, control.handle, 0);
            rectangle.x += (int)cGPoint.x;
            rectangle.y += (int)cGPoint.y;
            OS.GetWindowBounds(n5, (short)32, rect2);
            rectangle.x += rect2.left;
            rectangle.y += rect2.top;
            rect = control.getInset();
            rectangle.x -= rect.left;
            rectangle.y -= rect.top;
        }
        if (control2 != null) {
            n5 = OS.GetControlOwner(control2.handle);
            cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, control2.handle, 0);
            rectangle.x -= (int)cGPoint.x;
            rectangle.y -= (int)cGPoint.y;
            OS.GetWindowBounds(n5, (short)32, rect2);
            rectangle.x -= rect2.left;
            rectangle.y -= rect2.top;
            rect = control2.getInset();
            rectangle.x += rect.left;
            rectangle.y += rect.top;
        }
        return rectangle;
    }

    int menuProc(int n, int n2, int n3) {
        Object object;
        short s = 0;
        if (n3 != 0) {
            s = OS.GetMenuID(n3);
        } else {
            object = new int[1];
            OS.GetEventParameter(n2, 0x2D2D2D2D, 1835363957, null, 4, null, (int[])object);
            s = OS.GetMenuID((int)object[0]);
        }
        object = this.getMenu(s);
        if (object != null) {
            return ((Widget)object).menuProc(n, n2, n3);
        }
        return -9874;
    }

    int mouseProc(int n, int n2, int n3) {
        Object object;
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                short[] sArray = new short[1];
                OS.GetEventParameter(n2, 1835168878, 1835168878, null, 2, null, sArray);
                object = new int[1];
                OS.GetEventParameter(n2, 1667460724, 1835100014, null, 4, null, (int[])object);
                this.clickCount = this.clickCountButton == sArray[0] ? (int)object[0] : 1;
                this.clickCountButton = sArray[0];
                break;
            }
            case 5: 
            case 6: {
                this.mouseMoved = true;
            }
        }
        int n5 = 4;
        object = new Point();
        OS.GetEventParameter(n2, 1835822947, 1363439732, null, n5, null, (Point)object);
        int[] nArray = new int[1];
        short s = OS.FindWindow((Point)object, nArray);
        switch (s) {
            case 1: {
                if (n4 != 1) break;
                this.clearMenuFlags();
                if (this.menuBar == null || this.menuBar.isEnabled()) {
                    OS.MenuSelect((Point)object);
                }
                this.clearMenuFlags();
                return 0;
            }
            case 3: {
                Rect rect = new Rect();
                OS.GetWindowBounds(nArray[0], (short)33, rect);
                CGPoint cGPoint = new CGPoint();
                cGPoint.x = ((Point)object).h - rect.left;
                cGPoint.y = ((Point)object).v - rect.top;
                int n6 = OS.HIViewGetRoot(nArray[0]);
                int[] nArray2 = new int[1];
                OS.HIViewGetViewForMouseEvent(n6, n2, nArray2);
                int n7 = nArray2[0];
                OS.HIViewFindByID(n6, OS.kHIViewWindowContentID(), nArray2);
                int n8 = nArray2[0];
                while (n7 != 0 && n7 != n8 && !OS.IsControlEnabled(n7)) {
                    n7 = OS.HIViewGetSuperview(n7);
                }
                Widget widget = null;
                boolean bl = false;
                do {
                    if ((widget = this.getWidget(n7)) == null) continue;
                    if (widget.isEnabled()) break;
                    bl = true;
                } while ((n7 = OS.HIViewGetSuperview(n7)) != 0 && n7 != n8);
                if (widget == null || !widget.contains((int)cGPoint.x, (int)cGPoint.y)) break;
                int n9 = n3 != 0 ? widget.mouseProc(n, n2, n3) : -9874;
                return bl ? 0 : n9;
            }
        }
        switch (n4) {
            case 5: 
            case 6: {
                OS.InitCursor();
            }
        }
        return -9874;
    }

    int mouseHoverProc(int n, int n2) {
        OS.RemoveEventLoopTimer(n);
        this.mouseHoverID = 0;
        this.mouseMoved = false;
        if (this.currentControl != null && !this.currentControl.isDisposed()) {
            int n3 = OS.GetCurrentEventButtonState();
            int n4 = OS.GetCurrentEventKeyModifiers();
            org.eclipse.swt.graphics.Point point = this.currentControl.toControl(this.getCursorLocation());
            this.currentControl.sendMouseEvent(32, (short)0, 0, true, n3, (short)point.x, (short)point.y, n4);
        }
        return 0;
    }

    int observerProc(int n, int n2, int n3) {
        switch (n2) {
            case 32: {
                if (!this.runAsyncMessages || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return 0;
    }

    int readImageRef(int n) {
        int n2 = 0;
        int n3 = OS.CFURLCreateFromFileSystemRepresentation(0, n, OS.strlen(n), false);
        if (n3 != 0) {
            int n4 = OS.CFURLCopyPathExtension(n3);
            if (n4 != 0) {
                byte[] byArray;
                byte[] byArray2;
                int n5 = OS.CFStringGetLength(n4);
                char[] cArray = new char[n5];
                CFRange cFRange = new CFRange();
                cFRange.length = n5;
                OS.CFStringGetCharacters(n4, cFRange, cArray);
                String string = new String(cArray);
                if (string.equalsIgnoreCase("png")) {
                    int n6 = OS.CGDataProviderCreateWithURL(n3);
                    if (n6 != 0) {
                        n2 = OS.CGImageCreateWithPNGDataProvider(n6, null, true, 0);
                        OS.CGDataProviderRelease(n6);
                    }
                } else if (string.equalsIgnoreCase("jpeg") || string.equals("jpg")) {
                    int n7 = OS.CGDataProviderCreateWithURL(n3);
                    if (n7 != 0) {
                        n2 = OS.CGImageCreateWithJPEGDataProvider(n7, null, true, 0);
                        OS.CGDataProviderRelease(n7);
                    }
                } else if (string.equalsIgnoreCase("icns") && OS.CFURLGetFSRef(n3, byArray2 = new byte[80]) && OS.FSGetCatalogInfo(byArray2, 0, null, null, byArray = new byte[70], null) == 0) {
                    int[] nArray = new int[1];
                    OS.ReadIconFile(byArray, nArray);
                    if (nArray[0] != 0) {
                        n2 = this.createImageFromFamily(nArray[0], 1769222962, 1949855083, 128, 128)[0];
                        OS.DisposeHandle(nArray[0]);
                    }
                }
                OS.CFRelease(n4);
            }
            OS.CFRelease(n3);
        }
        return n2;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        boolean bl = false;
        bl |= this.runSettings();
        bl |= this.runTimers();
        bl |= this.runPopups();
        int[] nArray = new int[1];
        int n = OS.ReceiveNextEvent(0, null, 0.0, true, nArray);
        if (n == 0) {
            bl = true;
            OS.SendEventToEventTarget(nArray[0], OS.GetEventDispatcherTarget());
            OS.ReleaseEvent(nArray[0]);
            if (this.focusCombo != null && !this.focusCombo.isDisposed()) {
                this.focusCombo.checkSelection();
            }
        }
        if (bl |= this.runPaint()) {
            this.runDeferredEvents();
            this.runEnterExit();
            return true;
        }
        return this.runAsyncMessages(false);
    }

    static synchronized void register(Display display) {
        int n = 0;
        while (n < Displays.length) {
            if (Displays[n] == null) {
                Display.Displays[n] = display;
                return;
            }
            ++n;
        }
        Display[] displayArray = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
        displayArray[Display.Displays.length] = display;
        Displays = displayArray;
    }

    protected void release() {
        this.disposing = true;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n = 0;
            while (n < this.disposeList.length) {
                if (this.disposeList[n] != null) {
                    this.disposeList[n].run();
                }
                ++n;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n;
        this.disposeWindows();
        if (this.gcWindow != 0) {
            OS.DisposeWindow(this.gcWindow);
        }
        this.gcWindow = 0;
        if (this.caretID != 0) {
            OS.RemoveEventLoopTimer(this.caretID);
        }
        if (this.mouseHoverID != 0) {
            OS.RemoveEventLoopTimer(this.mouseHoverID);
        }
        this.mouseHoverID = 0;
        this.caretID = 0;
        if (this.timerIds != null) {
            n = 0;
            while (n < this.timerIds.length) {
                if (this.timerIds[n] != 0 && this.timerIds[n] != -1) {
                    OS.RemoveEventLoopTimer(this.timerIds[n]);
                }
                ++n;
            }
        }
        this.timerIds = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.infoImage = null;
        this.errorImage = null;
        n = 0;
        while (n < this.cursors.length) {
            if (this.cursors[n] != null) {
                this.cursors[n].dispose();
            }
            ++n;
        }
        this.cursors = null;
        if (this.dockImage != 0) {
            OS.CGImageRelease(this.dockImage);
        }
        this.dockImage = 0;
        if (this.runLoopSource != 0) {
            OS.CFRunLoopSourceInvalidate(this.runLoopSource);
            OS.CFRelease(this.runLoopSource);
        }
        this.runLoopSource = 0;
        this.runLoop = 0;
        this.releaseCallback.dispose();
        this.actionCallback.dispose();
        this.appleEventCallback.dispose();
        this.caretCallback.dispose();
        this.clockCallback.dispose();
        this.commandCallback.dispose();
        this.controlCallback.dispose();
        this.accessibilityCallback.dispose();
        this.drawItemCallback.dispose();
        this.itemCompareCallback.dispose();
        this.itemDataCallback.dispose();
        this.itemNotificationCallback.dispose();
        this.helpCallback.dispose();
        this.hitTestCallback.dispose();
        this.keyboardCallback.dispose();
        this.menuCallback.dispose();
        this.mouseHoverCallback.dispose();
        this.mouseCallback.dispose();
        this.trackingCallback.dispose();
        this.windowCallback.dispose();
        this.colorCallback.dispose();
        this.textInputCallback.dispose();
        this.appearanceCallback.dispose();
        this.trayItemCallback.dispose();
        this.observerCallback.dispose();
        this.sourceCallback.dispose();
        this.searchCallback.dispose();
        this.coreEventCallback.dispose();
        this.appearanceCallback = null;
        this.commandCallback = null;
        this.caretCallback = null;
        this.appleEventCallback = null;
        this.actionCallback = null;
        this.itemNotificationCallback = null;
        this.itemDataCallback = null;
        this.drawItemCallback = null;
        this.controlCallback = null;
        this.clockCallback = null;
        this.accessibilityCallback = null;
        this.trayItemCallback = null;
        this.searchCallback = null;
        this.itemCompareCallback = null;
        this.menuCallback = null;
        this.keyboardCallback = null;
        this.hitTestCallback = null;
        this.helpCallback = null;
        this.sourceCallback = null;
        this.observerCallback = null;
        this.colorCallback = null;
        this.windowCallback = null;
        this.trackingCallback = null;
        this.mouseCallback = null;
        this.mouseHoverCallback = null;
        this.coreEventCallback = null;
        this.textInputCallback = null;
        this.trayItemProc = 0;
        this.searchProc = 0;
        this.appearanceProc = 0;
        this.commandProc = 0;
        this.caretProc = 0;
        this.appleEventProc = 0;
        this.actionProc = 0;
        this.itemCompareProc = 0;
        this.itemNotificationProc = 0;
        this.itemDataProc = 0;
        this.drawItemProc = 0;
        this.controlProc = 0;
        this.clockProc = 0;
        this.accessibilityProc = 0;
        this.releaseProc = 0;
        this.sourceProc = 0;
        this.observerProc = 0;
        this.menuProc = 0;
        this.keyboardProc = 0;
        this.hitTestProc = 0;
        this.helpProc = 0;
        this.coreEventProc = 0;
        this.colorProc = 0;
        this.windowProc = 0;
        this.trackingProc = 0;
        this.mouseProc = 0;
        this.mouseHoverProc = 0;
        this.textInputProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.timerProc = 0;
        this.focusCombo = null;
        this.focusControl = null;
        this.currentControl = null;
        this.activeShell = null;
        this.helpWidget = null;
        if (this.helpString != 0) {
            OS.CFRelease(this.helpString);
        }
        this.helpString = 0;
        this.popups = null;
        this.menus = null;
        this.menuBar = null;
    }

    int releaseDataProc(int n, int n2, int n3) {
        OS.DisposePtr(n2);
        return 0;
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        this.menus[menu.id - 1001] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n = 0;
        while (n < this.popups.length) {
            if (this.popups[n] == menu) {
                this.popups[n] = null;
                return;
            }
            ++n;
        }
    }

    Widget removeWidget(int n) {
        if (n == 0) {
            return null;
        }
        Widget widget = null;
        this.property[0] = 0;
        OS.GetControlProperty(n, 1937208368, 1937208368, 4, null, this.property);
        int n2 = this.property[0] - 1;
        if (n2 >= 0 && n2 < this.widgetTable.length) {
            widget = this.widgetTable[n2];
            this.widgetTable[n2] = null;
            this.indexTable[n2] = this.freeSlot;
            this.freeSlot = n2;
            OS.RemoveControlProperty(n, 1937208368, 1937208368);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runEnterExit() {
        Object object;
        CGPoint cGPoint;
        Object object2;
        boolean bl = false;
        Widget widget = null;
        int[] nArray = new int[1];
        Point point = new Point();
        OS.GetGlobalMouse(point);
        int[] nArray2 = new int[1];
        if (OS.FindWindow(point, nArray2) == 3 && nArray2[0] != 0) {
            Control control;
            Widget widget2;
            object2 = new Rect();
            OS.GetWindowBounds(nArray2[0], (short)33, (Rect)object2);
            cGPoint = new CGPoint();
            cGPoint.x = point.h - ((Rect)object2).left;
            cGPoint.y = point.v - ((Rect)object2).top;
            object = new int[1];
            OS.GetRootControl(nArray2[0], object);
            OS.HIViewGetSubviewHit(object[0], cGPoint, true, nArray);
            while (nArray[0] != 0 && !OS.IsControlEnabled(nArray[0])) {
                OS.GetSuperControl(nArray[0], nArray);
            }
            boolean bl2 = true;
            if (nArray[0] != 0) {
                do {
                    if ((widget2 = this.getWidget(nArray[0])) != null && widget2 instanceof Control && (control = (Control)widget2).isEnabled()) {
                        if (!control.isEnabledModal()) break;
                        if (widget2.isTrimHandle(nArray[0])) {
                            bl2 = false;
                            break;
                        }
                        widget = control;
                        break;
                    }
                    OS.GetSuperControl(nArray[0], nArray);
                } while (nArray[0] != 0);
            }
            if (widget == null && bl2) {
                nArray[0] = object[0];
                widget2 = this.getWidget(nArray[0]);
                if (widget2 != null && widget2 instanceof Control && (control = (Control)widget2).isEnabled() && control.isEnabledModal()) {
                    widget = control;
                    nArray[0] = ((Control)widget).handle;
                }
            }
            if (widget != null && !widget.contains((int)cGPoint.x, (int)cGPoint.y)) {
                widget = null;
            }
        }
        if (widget != this.currentControl) {
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                bl = true;
                int n = OS.GetCurrentEventButtonState();
                int n2 = OS.GetCurrentEventKeyModifiers();
                object = this.currentControl.toControl(point.h, point.v);
                this.currentControl.sendMouseEvent(7, (short)0, 0, true, n, (short)object.x, (short)object.y, n2);
                if (this.mouseHoverID != 0) {
                    OS.RemoveEventLoopTimer(this.mouseHoverID);
                }
                this.mouseHoverID = 0;
                this.mouseMoved = false;
            }
            if (widget != null && widget.isDisposed()) {
                widget = null;
            }
            if ((this.currentControl = widget) != null) {
                bl = true;
                int n = OS.GetCurrentEventButtonState();
                int n3 = OS.GetCurrentEventKeyModifiers();
                object = this.currentControl.toControl(point.h, point.v);
                this.currentControl.sendMouseEvent(6, (short)0, 0, true, n, (short)object.x, (short)object.y, n3);
            }
        }
        if (widget != null && this.mouseMoved) {
            object2 = new int[1];
            OS.HMGetTagDelay((int[])object2);
            if (this.mouseHoverID != 0) {
                OS.SetEventLoopTimerNextFireTime(this.mouseHoverID, (double)object2[0] / 1000.0);
            } else {
                int n = OS.GetCurrentEventLoop();
                object = new int[1];
                OS.InstallEventLoopTimer(n, (double)object2[0] / 1000.0, 0.0, this.mouseHoverProc, 0, object);
                this.mouseHoverID = object[0];
            }
            this.mouseMoved = false;
        }
        if (!OS.StillDown() && nArray2[0] != 0 && nArray[0] != 0) {
            object2 = new Rect();
            OS.GetWindowBounds(nArray2[0], (short)33, (Rect)object2);
            cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, nArray[0], 0);
            point.h = (short)(point.h - (int)cGPoint.x);
            point.v = (short)(point.v - (int)cGPoint.y);
            OS.GetWindowBounds(nArray2[0], (short)32, (Rect)object2);
            point.h = (short)(point.h - ((Rect)object2).left);
            point.v = (short)(point.v - ((Rect)object2).top);
            int n = OS.GetCurrentEventKeyModifiers();
            boolean[] blArray = new boolean[1];
            OS.HandleControlSetCursor(nArray[0], point, (short)n, blArray);
            if (!blArray[0]) {
                OS.SetThemeCursor(0);
            }
        }
        return bl;
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            widget2.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runEventLoopTimers() {
        this.allowTimers = false;
        boolean bl = OS.ReceiveNextEvent(0, null, 0.0, false, null) == 0;
        this.allowTimers = true;
        return bl;
    }

    boolean runPaint() {
        if (!this.needsPaint) {
            return false;
        }
        this.needsPaint = false;
        int n = 0;
        while (n < this.widgetTable.length) {
            Widget widget = this.widgetTable[n];
            if (widget != null && widget instanceof Shell) {
                Shell shell = (Shell)widget;
                if (shell.invalRgn != 0) {
                    int n2 = shell.invalRgn;
                    shell.invalRgn = 0;
                    shell.redrawChildren(OS.HIViewGetRoot(shell.shellHandle), n2);
                    OS.DisposeRgn(n2);
                }
            }
            ++n;
        }
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.clearMenuFlags();
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            this.clearMenuFlags();
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.initializeInsets();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++n;
        }
        return true;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.timerList.length) {
            if (this.timerIds[n] == -1) {
                Runnable runnable = this.timerList[n];
                this.timerList[n] = null;
                this.timerIds[n] = 0;
                if (runnable != null) {
                    bl = true;
                    runnable.run();
                }
            }
            ++n;
        }
        return bl;
    }

    int searchProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget != null) {
            return widget.searchProc(n, n2, n3);
        }
        return -9874;
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretID != 0) {
            OS.RemoveEventLoopTimer(this.caretID);
        }
        this.caretID = 0;
        this.currentCaret = caret;
        if (this.currentCaret != null) {
            int n = this.currentCaret.blinkRate;
            int[] nArray = new int[1];
            double d = (double)n / 1000.0;
            int n2 = OS.GetCurrentEventLoop();
            OS.InstallEventLoopTimer(n2, d, d, this.caretProc, 0, nArray);
            this.caretID = nArray[0];
        }
    }

    void setCursor(int n) {
        switch (n) {
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                OS.SetThemeCursor(n);
                break;
            }
            default: {
                if (OS.VERSION >= 4160) {
                    Cocoa.objc_msgSend(n, Cocoa.S_set);
                    break;
                }
                OS.SetCursor(n);
            }
        }
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = n;
        cGPoint.y = n2;
        OS.CGWarpMouseCursorPosition(cGPoint);
    }

    public void setCursorLocation(org.eclipse.swt.graphics.Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        Object[] objectArray;
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray2 = (Object[])object;
            int n = (Integer)objectArray2[0];
            objectArray = (Object[])objectArray2[1];
            if (objectArray == null) {
                this.removeWidget(n);
            } else {
                this.addWidget(n, (Widget)objectArray);
            }
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n = 0;
            while (n < this.keys.length && !this.keys[n].equals(string)) {
                ++n;
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                this.values[n] = object;
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray3 = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray3, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray3[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray3;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages(true);
        }
        this.synchronizer = synchronizer;
    }

    void setMenuBar(Menu menu) {
        if (menu == this.menuBar) {
            return;
        }
        int n = 0;
        if (menu == null) {
            int[] nArray = new int[1];
            OS.CreateNewMenu((short)1000, 0, nArray);
            n = nArray[0];
        } else {
            n = menu.handle;
        }
        OS.SetRootMenu(n);
        if (menu == null) {
            OS.ClearMenuBar();
            OS.DisposeMenu(n);
        }
        this.menuBar = menu;
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.disposeWindows();
        if (this.eventTable != null && this.eventTable.hooks(39)) {
            RGBColor rGBColor = new RGBColor();
            int n = 0;
            int n2 = this.getDepth();
            do {
                this.runAsyncMessages = false;
                this.allowTimers = false;
                n = OS.CFRunLoopRunInMode(OS.kCFRunLoopDefaultMode(), 0.5, true);
                this.runAsyncMessages = true;
                this.allowTimers = true;
                if (n != 3) continue;
                OS.GetThemeBrushAsColor((short)-3, (short)n2, true, rGBColor);
                if (this.highlightColor.red == rGBColor.red && this.highlightColor.green == rGBColor.green && this.highlightColor.blue == rGBColor.blue) continue;
                this.highlightColor = rGBColor;
                this.runSettings = true;
                return true;
            } while (n == 3);
            return n == 4;
        }
        this.runAsyncMessages = false;
        this.allowTimers = false;
        int n = OS.CFRunLoopRunInMode(OS.kCFRunLoopDefaultMode(), 86400.0, true);
        this.runAsyncMessages = true;
        this.allowTimers = true;
        return n == 4;
    }

    int sourceProc(int n) {
        return 0;
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    int textInputProc(int n, int n2, int n3) {
        int n4 = OS.GetUserFocusWindow();
        if (n4 != 0) {
            int[] nArray = new int[1];
            OS.GetKeyboardFocus(n4, nArray);
            Widget widget = this.getWidget(nArray[0]);
            if (widget != null) {
                OS.GetWindowDefaultButton(n4, nArray);
                OS.SetWindowDefaultButton(n4, 0);
                int n5 = widget.textInputProc(n, n2, n3);
                if (n5 == -9874) {
                    n5 = OS.CallNextEventHandler(n, n2);
                }
                OS.SetWindowDefaultButton(n4, nArray[0]);
                return n5;
            }
        }
        return -9874;
    }

    public void timerExec(int n, Runnable runnable) {
        Object[] objectArray;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int n2 = 0;
        while (n2 < this.timerList.length) {
            if (this.timerList[n2] == runnable) break;
            ++n2;
        }
        if (n2 != this.timerList.length) {
            int n3 = this.timerIds[n2];
            if (n < 0) {
                OS.RemoveEventLoopTimer(n3);
                this.timerList[n2] = null;
                this.timerIds[n2] = 0;
            } else {
                OS.SetEventLoopTimerNextFireTime(n3, (double)n / 1000.0);
            }
            return;
        }
        if (n < 0) {
            return;
        }
        n2 = 0;
        while (n2 < this.timerList.length) {
            if (this.timerList[n2] == null) break;
            ++n2;
        }
        if (n2 == this.timerList.length) {
            objectArray = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, objectArray, 0, this.timerList.length);
            this.timerList = (Runnable[])objectArray;
            int[] nArray = new int[this.timerIds.length + 4];
            System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
            this.timerIds = nArray;
        }
        objectArray = new int[1];
        int n4 = OS.GetCurrentEventLoop();
        OS.InstallEventLoopTimer(n4, (double)n / 1000.0, 0.0, this.timerProc, n2, objectArray);
        if (objectArray[0] != 0) {
            this.timerIds[n2] = objectArray[0];
            this.timerList[n2] = runnable;
        }
    }

    int timerProc(int n, int n2) {
        OS.RemoveEventLoopTimer(n);
        if (this.timerList == null) {
            return 0;
        }
        if (n2 >= 0 && n2 < this.timerList.length) {
            if (this.allowTimers) {
                Runnable runnable = this.timerList[n2];
                this.timerList[n2] = null;
                this.timerIds[n2] = 0;
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                this.timerIds[n2] = -1;
                this.wakeThread();
            }
        }
        return 0;
    }

    int trackingProc(int n, int n2, int n3, int n4, int n5, int n6) {
        Widget widget = this.getWidget(n);
        if (widget != null) {
            return widget.trackingProc(n, n2, n3, n4, n5, n6);
        }
        return 0;
    }

    int trayItemProc(int n, int n2, int n3, int n4) {
        TrayItem trayItem = (TrayItem)OS.JNIGetObject(n2);
        if (trayItem != null) {
            return trayItem.trayItemProc(n, n2, n3, n4);
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++n;
        }
    }

    void updateQuitMenu() {
        boolean bl = true;
        Shell[] shellArray = this.getShells();
        int n = 229376;
        int n2 = 0;
        while (n2 < shellArray.length) {
            Shell shell = shellArray[n2];
            if ((shell.style & n) != 0 && shell.isVisible()) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            OS.EnableMenuCommand(0, 1903520116);
        } else {
            OS.DisableMenuCommand(0, 1903520116);
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        this.wakeThread();
    }

    void wakeThread() {
        OS.CFRunLoopSourceSignal(this.runLoopSource);
        OS.CFRunLoopWakeUp(this.runLoop);
    }

    int windowProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 0x2D2D2D2D, 2003398244, null, 4, null, nArray);
            int[] nArray2 = new int[1];
            OS.GetRootControl(nArray[0], nArray2);
            widget = this.getWidget(nArray2[0]);
        }
        if (widget != null) {
            return widget.windowProc(n, n2, n3);
        }
        return -9874;
    }
}

