/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CGFunctionCallbacks;
import org.eclipse.swt.internal.carbon.CGPatternCallbacks;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public class Pattern
extends Resource {
    int jniRef;
    Image image;
    float[] color1;
    float[] color2;
    int alpha1;
    int alpha2;
    float x1;
    float y1;
    float x2;
    float y2;
    int shading;
    CGRect drawRect;

    public Pattern(Device device, Image image) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        this.image = image;
        device.createPatternCallbacks();
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Pattern(Device device, float f, float f2, float f3, float f4, Color color, Color color2) {
        this(device, f, f2, f3, f4, color, 255, color2, 255);
    }

    public Pattern(Device device, float f, float f2, float f3, float f4, Color color, int n, Color color2, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
        this.color1 = color.handle;
        this.color2 = color2.handle;
        this.alpha1 = n;
        this.alpha2 = n2;
        device.createPatternCallbacks();
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = f;
        cGPoint.y = f2;
        CGPoint cGPoint2 = new CGPoint();
        cGPoint2.x = f3;
        cGPoint2.y = f4;
        CGFunctionCallbacks cGFunctionCallbacks = new CGFunctionCallbacks();
        cGFunctionCallbacks.evaluate = device.axialShadingProc;
        int n3 = OS.CGFunctionCreate(this.jniRef, 1, new float[]{0.0f, 1.0f}, 4, new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f}, cGFunctionCallbacks);
        if (n3 == 0) {
            SWT.error(2);
        }
        this.shading = OS.CGShadingCreateAxial(device.colorspace, cGPoint, cGPoint2, n3, true, true);
        OS.CGFunctionRelease(n3);
        if (this.shading == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int axialShadingProc(int n, int n2, int n3) {
        float[] fArray = new float[4];
        OS.memmove(fArray, n2, 4);
        float f = fArray[0];
        float f2 = 1.0f - f;
        float[] fArray2 = this.color1;
        float[] fArray3 = this.color2;
        float f3 = (float)(this.alpha1 & 0xFF) / 255.0f;
        float f4 = (float)(this.alpha2 & 0xFF) / 255.0f;
        fArray[0] = fArray3[0] * f + fArray2[0] * f2;
        fArray[1] = fArray3[1] * f + fArray2[1] * f2;
        fArray[2] = fArray3[2] * f + fArray2[2] * f2;
        fArray[3] = f4 * f + f3 * f2;
        OS.memmove(n3, fArray, fArray.length * 4);
        return 0;
    }

    int createPattern(int n) {
        float[] fArray = new float[6];
        OS.CGContextGetCTM(n, fArray);
        CGRect cGRect = new CGRect();
        if (this.image != null) {
            int n2 = this.image.handle;
            cGRect.width = OS.CGImageGetWidth(n2);
            cGRect.height = OS.CGImageGetHeight(n2);
        } else {
            cGRect.x = this.x1 - 0.5f;
            cGRect.y = this.y1 - 0.5f;
            cGRect.width = this.x2 - this.x1 + 1.0f;
            cGRect.height = this.y2 - this.y1 + 1.0f;
        }
        CGPatternCallbacks cGPatternCallbacks = new CGPatternCallbacks();
        cGPatternCallbacks.drawPattern = this.device.drawPatternProc;
        int n3 = OS.CGPatternCreate(this.jniRef, cGRect, fArray, cGRect.width, cGRect.height, 0, 0, cGPatternCallbacks);
        if (n3 == 0) {
            SWT.error(2);
        }
        return n3;
    }

    public void dispose() {
        if (this.jniRef == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        if (this.shading != 0) {
            OS.CGShadingRelease(this.shading);
        }
        this.shading = 0;
        this.jniRef = 0;
        this.image = null;
        this.color2 = null;
        this.color1 = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    int drawPatternProc(int n, int n2) {
        if (this.image != null) {
            if (this.image.isDisposed()) {
                return 0;
            }
            int n3 = this.image.handle;
            int n4 = OS.CGImageGetWidth(n3);
            int n5 = OS.CGImageGetHeight(n3);
            CGRect cGRect = new CGRect();
            cGRect.width = n4;
            cGRect.height = n5;
            OS.CGContextScaleCTM(n2, 1.0f, -1.0f);
            if (this.drawRect != null && this.drawRect.x % (float)n4 + this.drawRect.width < (float)n4 && this.drawRect.y % (float)n5 + this.drawRect.height < (float)n5) {
                cGRect.x = this.drawRect.x % (float)n4;
                cGRect.y = this.drawRect.y % (float)n5;
                cGRect.width = this.drawRect.width;
                cGRect.height = this.drawRect.height;
                if (OS.VERSION >= 4160) {
                    n3 = OS.CGImageCreateWithImageInRect(n3, cGRect);
                } else {
                    int n6 = (int)this.drawRect.x;
                    int n7 = (int)this.drawRect.y;
                    int n8 = (int)this.drawRect.width;
                    int n9 = (int)this.drawRect.height;
                    int n10 = OS.CGImageGetBitsPerComponent(n3);
                    int n11 = OS.CGImageGetBitsPerPixel(n3);
                    int n12 = OS.CGImageGetBytesPerRow(n3);
                    int n13 = OS.CGImageGetColorSpace(n3);
                    int n14 = OS.CGImageGetAlphaInfo(n3);
                    int n15 = this.image.data + n7 * n12 + n6 * 4;
                    int n16 = OS.CGDataProviderCreateWithData(0, n15, n9 * n12, 0);
                    if (n16 != 0) {
                        n3 = OS.CGImageCreate(n8, n9, n10, n11, n12, n13, n14, n16, null, true, 0);
                        OS.CGDataProviderRelease(n16);
                    }
                }
            }
            OS.CGContextTranslateCTM(n2, 0.0f, -(cGRect.height + 2.0f * cGRect.y));
            OS.CGContextDrawImage(n2, cGRect, n3);
            if (n3 != 0 && n3 != this.image.handle) {
                OS.CGImageRelease(n3);
            }
        } else {
            OS.CGContextDrawShading(n2, this.shading);
        }
        return 0;
    }

    public boolean isDisposed() {
        return this.jniRef == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.jniRef + "}";
    }
}

