/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;

public class Transform
extends Resource {
    public float[] handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] fArray) {
        this(device, Transform.checkTransform(fArray)[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public Transform(Device device, float f, float f2, float f3, float f4, float f5, float f6) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = new float[6];
        OS.CGAffineTransformMake(f, f2, f3, f4, f5, f6, this.handle);
        if (this.handle == null) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static float[] checkTransform(float[] fArray) {
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        return fArray;
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getElements(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        System.arraycopy(this.handle, 0, fArray, 0, this.handle.length);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.handle[0] * this.handle[3] - this.handle[1] * this.handle[2] == 0.0f) {
            SWT.error(10);
        }
        OS.CGAffineTransformInvert(this.handle, this.handle);
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle[0] == 1.0f && this.handle[1] == 0.0f && this.handle[2] == 0.0f && this.handle[3] == 1.0f && this.handle[4] == 0.0f && this.handle[5] == 0.0f;
    }

    public void multiply(Transform transform) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        OS.CGAffineTransformConcat(transform.handle, this.handle, this.handle);
    }

    public void rotate(float f) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformRotate(this.handle, f * (float)Compatibility.PI / 180.0f, this.handle);
    }

    public void scale(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformScale(this.handle, f, f2, this.handle);
    }

    public void setElements(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformMake(f, f2, f3, f4, f5, f6, this.handle);
    }

    public void transform(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        CGPoint cGPoint = new CGPoint();
        int n = fArray.length / 2;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            cGPoint.x = fArray[n3];
            cGPoint.y = fArray[n3 + 1];
            OS.CGPointApplyAffineTransform(cGPoint, this.handle, cGPoint);
            fArray[n3] = cGPoint.x;
            fArray[n3 + 1] = cGPoint.y;
            ++n2;
            n3 += 2;
        }
    }

    public void translate(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformTranslate(this.handle, f, f2, this.handle);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] fArray = new float[6];
        this.getElements(fArray);
        return "Transform {" + fArray[0] + ", " + fArray[1] + ", " + fArray[2] + ", " + fArray[3] + ", " + fArray[4] + ", " + fArray[5] + "}";
    }
}

