/**
 * OverwriteDialog : 파일 덮어쓰기 대화상자 
 */
package net.kldp.jzip;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;

/**
 * 파일 덮어쓰기 대화상자
 * 
 * @author jeongseungwon
 * 
 */
public class OverwriteDialog {

	/**
	 * 예
	 */
	public static final int YES = 0;

	/**
	 * 아니오
	 */
	public static final int NO = 1;

	/**
	 * 모두 예
	 */
	public static final int ALL_YES = 2;

	/**
	 * 모두 아니오
	 */
	public static final int ALL_NO = 3;

	/**
	 * 취소
	 */
	public static final int CANCEL = 4;

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="18,27"

	private Label label = null;

	private int overwrite;

	private Composite composite = null;

	private Button buttonYes = null;

	private Button buttonNo = null;

	private Button buttonAllYes = null;

	private Button buttonAllNo = null;

	private Label icon = null;

	/**
	 * {@link OverwriteDialog} 생성자
	 */
	public OverwriteDialog() {
		overwrite = NO;
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData11 = new GridData();
		gridData11.horizontalAlignment = GridData.CENTER;
		gridData11.verticalAlignment = GridData.CENTER;
		GridData gridData = new GridData();
		gridData.verticalAlignment = GridData.CENTER;
		gridData.heightHint = -1;
		gridData.widthHint = 360;
		gridData.horizontalAlignment = GridData.BEGINNING;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.verticalSpacing = 10;
		gridLayout.horizontalSpacing = 10;
		gridLayout.makeColumnsEqualWidth = false;
		sShell = new Shell(SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM);
		sShell.setLayout(gridLayout);
		sShell.setText("덮어쓸까요?");
		icon = new Label(sShell, SWT.NONE);
		icon.setImage(sShell.getDisplay().getSystemImage(SWT.ICON_QUESTION));
		icon.setLayoutData(gridData11);
		label = new Label(sShell, SWT.HORIZONTAL | SWT.WRAP);
		label.setText(" 파일 또는 디렉토리가 이미 존재합니다.\n\n덮어쓸까요?");
		label.setLayoutData(gridData);
		createComposite();
		sShell.setSize(new Point(428, 100));
		sShell.addShellListener(new org.eclipse.swt.events.ShellAdapter() {
			public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
				overwrite = CANCEL;
			}
		});
	}

	/**
	 * 파일 덮어쓰기 확인 대화상자를 화면에 표시하는 메소드
	 * 
	 * @param parent
	 *            부모 쉘
	 * @param fileName
	 *            덮어쓸 파일명
	 * @return 사용자의 응답
	 */
	public int open(Shell parent, String fileName) {
		createSShell();

		label.setText(fileName + label.getText());

		sShell.setParent(parent);
		
		sShell.pack();
		
		buttonYes.setFocus();
		
		sShell.open();
		Display display = parent.getDisplay();
		while (!sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		return overwrite;
	}

	/**
	 * This method initializes composite	
	 *
	 */
	private void createComposite() {
		GridData gridData1 = new GridData();
		gridData1.verticalAlignment = GridData.CENTER;
		gridData1.horizontalSpan = 2;
		gridData1.horizontalAlignment = GridData.END;
		composite = new Composite(sShell, SWT.NONE);
		composite.setLayout(new RowLayout());
		composite.setLayoutData(gridData1);
		buttonYes = new Button(composite, SWT.NONE);
		buttonYes.setText("예(&Y)");
		buttonYes.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				overwrite = YES;
				
				sShell.dispose();
			}
		});
		buttonYes.addKeyListener(new org.eclipse.swt.events.KeyAdapter() {
			public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
				if (e.keyCode == SWT.ESC) {
					overwrite = CANCEL;
					
					sShell.dispose();
				} else if (e.keyCode == SWT.ARROW_RIGHT) {
					buttonNo.setFocus();
				}
			}
		});
		buttonNo = new Button(composite, SWT.NONE);
		buttonNo.setText("아니오(&N)");
		buttonNo.addKeyListener(new org.eclipse.swt.events.KeyAdapter() {
			public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
				if (e.keyCode == SWT.ESC) {
					overwrite = CANCEL;
					
					sShell.dispose();
				} else if (e.keyCode == SWT.ARROW_LEFT) {
					buttonYes.setFocus();
				} else if (e.keyCode == SWT.ARROW_RIGHT) {
					buttonAllYes.setFocus();
				}
			}
		});
		buttonNo.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				overwrite = NO;
				
				sShell.dispose();
			}
		});
		buttonAllYes = new Button(composite, SWT.NONE);
		buttonAllYes.setText("모두 예(&A)");
		buttonAllYes
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						overwrite = ALL_YES;
						
						sShell.dispose();
					}
				});
		buttonAllYes.addKeyListener(new org.eclipse.swt.events.KeyAdapter() {
			public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
				if (e.keyCode == SWT.ESC) {
					overwrite = CANCEL;
					
					sShell.dispose();
				} else if (e.keyCode == SWT.ARROW_LEFT) {
					buttonNo.setFocus();
				} else if (e.keyCode == SWT.ARROW_RIGHT) {
					buttonAllNo.setFocus();
				}
			}
		});
		buttonAllNo = new Button(composite, SWT.NONE);
		buttonAllNo.setText("모두 아니오");
		buttonAllNo.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				overwrite = ALL_NO;
				
				sShell.dispose();
			}
		});
		buttonAllNo.addKeyListener(new org.eclipse.swt.events.KeyAdapter() {
			public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
				if (e.keyCode == SWT.ESC) {
					overwrite = CANCEL;
					
					sShell.dispose();
				} else if (e.keyCode == SWT.ARROW_LEFT) {
					buttonAllYes.setFocus();
				}
			}
		});
	}

}
