/**
 * RenameDialog : 이름 바꾸기 대화상자
 */
package net.kldp.jzip;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * 이름 바꾸기 대화상자 클래스
 * 
 * @author jeongseungwon
 * 
 */
public class RenameDialog {

	/**
	 * {@link KeyAdapter}를 구현하는 클래스
	 * 
	 * @author jeongseungwon
	 *
	 */
	private final class CancelAdaptor extends org.eclipse.swt.events.KeyAdapter {
		public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
			if (e.keyCode == SWT.ESC) {
				// ESC 키를 누른 경우
				fileName = null;
				
				sShell.dispose();
			}	
		}
	}

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="98,32"

	private Label label = null;

	private Text text = null;

	private String fileName = null;

	private Composite composite = null;

	private Button buttonOk = null;

	private Button buttonCancel = null;

	/**
	 * RenameDialog 클래스의 생성자
	 * 
	 * @param fileName
	 */
	public RenameDialog(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * This method initializes sShell
	 * 
	 */
	private void createSShell() {
		GridData gridData1 = new GridData();
		gridData1.verticalAlignment = GridData.CENTER;
		gridData1.widthHint = 200;
		gridData1.grabExcessHorizontalSpace = false;
		gridData1.horizontalAlignment = GridData.CENTER;
		GridData gridData = new GridData();
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.marginWidth = 10;
		gridLayout.verticalSpacing = 9;
		gridLayout.marginHeight = 8;
		gridLayout.makeColumnsEqualWidth = false;
		sShell = new Shell(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		sShell.setText("이름 바꾸기");
		sShell.setSize(new Point(230, 119));
		sShell.setLayout(gridLayout);
		sShell.addShellListener(new org.eclipse.swt.events.ShellAdapter() {
			@Override
			public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
				fileName = null;
			}
		});
		sShell.addKeyListener(new CancelAdaptor());
		label = new Label(sShell, SWT.NONE);
		label.setText("새로운 이름 :");
		label.setLayoutData(gridData);
		text = new Text(sShell, SWT.BORDER);
		text.setLayoutData(gridData1);
		text.addKeyListener(new org.eclipse.swt.events.KeyAdapter() {
			public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
				final int keyCode = e.keyCode;

				if (keyCode == SWT.ESC) {
					fileName = null;

					sShell.dispose();
				}
			}
		});
		text.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {
				// 엔터 키를 입력한 경우
				fileName = text.getText().trim();
				
				sShell.dispose();
			}
		});
		createComposite();
	}

	/**
	 * {@link RenameDialog}를 여는 메소드
	 * 
	 * @param parent
	 *            부모 {@link Shell}
	 * @return 새로운 이름
	 */
	public String open(Shell parent) {
		createSShell();

		text.setText(fileName);
		text.selectAll();
		text.setFocus();

		sShell.setParent(parent);
		
		sShell.pack();
		
		sShell.open();
		Display display = parent.getDisplay();
		while (!sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		return fileName;
	}

	/**
	 * This method initializes composite	
	 *
	 */
	private void createComposite() {
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = GridData.END;
		gridData2.verticalAlignment = GridData.CENTER;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 2;
		composite = new Composite(sShell, SWT.NONE);
		composite.setLayout(gridLayout1);
		composite.setLayoutData(gridData2);
		buttonOk = new Button(composite, SWT.NONE);
		buttonOk.setText("확인(&O)");
		buttonOk.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				fileName = text.getText().trim();
				
				sShell.dispose();
			}
		});
		buttonOk.addKeyListener(new CancelAdaptor());
		buttonCancel = new Button(composite, SWT.NONE);
		buttonCancel.setText("취소(&C)");
		buttonCancel.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				fileName = null;
				
				sShell.dispose();
			}
		});
		buttonCancel.addKeyListener(new CancelAdaptor());
	}
}
