/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StyledTextDropTargetEffect
extends DropTargetEffect {
    static final int CARET_WIDTH = 2;
    static final int SCROLL_HYSTERESIS = 100;
    static final int SCROLL_TOLERANCE = 20;
    int currentOffset = -1;
    long scrollBeginTime;
    int scrollX = -1;
    int scrollY = -1;
    Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            if (StyledTextDropTargetEffect.this.currentOffset != -1) {
                StyledText styledText = (StyledText)StyledTextDropTargetEffect.this.getControl();
                Point point = styledText.getLocationAtOffset(StyledTextDropTargetEffect.this.currentOffset);
                int n = styledText.getLineHeight(StyledTextDropTargetEffect.this.currentOffset);
                event.gc.setBackground(event.display.getSystemColor(2));
                event.gc.fillRectangle(point.x, point.y, 2, n);
            }
        }
    };

    public StyledTextDropTargetEffect(StyledText styledText) {
        super(styledText);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.currentOffset = -1;
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
        this.getControl().removeListener(9, this.paintListener);
        this.getControl().addListener(9, this.paintListener);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        StyledText styledText = (StyledText)this.getControl();
        if (this.currentOffset != -1) {
            this.refreshCaret(styledText, this.currentOffset, -1);
        }
        styledText.removeListener(9, this.paintListener);
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5 = dropTargetEvent.feedback;
        StyledText styledText = (StyledText)this.getControl();
        Point point = styledText.getDisplay().map(null, styledText, dropTargetEvent.x, dropTargetEvent.y);
        if ((n5 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (styledText.getCharCount() == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.scrollX != -1 && this.scrollY != -1 && this.scrollBeginTime != 0L && (point.x >= this.scrollX && point.x <= this.scrollX + 20 || point.y >= this.scrollY && point.y <= this.scrollY + 20)) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                object = styledText.getClientArea();
                Rectangle rectangle = styledText.getTextBounds(0, 0);
                n4 = rectangle.width;
                n3 = 10 * n4;
                if (point.x < ((Rectangle)object).x + 3 * n4) {
                    n2 = styledText.getHorizontalPixel();
                    styledText.setHorizontalPixel(n2 - n3);
                    if (styledText.getHorizontalPixel() != n2) {
                        styledText.redraw();
                    }
                }
                if (point.x > ((Rectangle)object).width - 3 * n4) {
                    n2 = styledText.getHorizontalPixel();
                    styledText.setHorizontalPixel(n2 + n3);
                    if (styledText.getHorizontalPixel() != n2) {
                        styledText.redraw();
                    }
                }
                if (point.y < ((Rectangle)object).y + (n2 = rectangle.height)) {
                    n = styledText.getTopPixel();
                    styledText.setTopPixel(n - n2);
                    if (styledText.getTopPixel() != n) {
                        styledText.redraw();
                    }
                }
                if (point.y > ((Rectangle)object).height - n2) {
                    n = styledText.getTopPixel();
                    styledText.setTopPixel(n + n2);
                    if (styledText.getTopPixel() != n) {
                        styledText.redraw();
                    }
                }
                this.scrollBeginTime = 0L;
                this.scrollY = -1;
                this.scrollX = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 100L;
            this.scrollX = point.x;
            this.scrollY = point.y;
        }
        if ((n5 & 1) != 0) {
            object = styledText.getContent();
            int n6 = -1;
            try {
                n6 = styledText.getOffsetAtLocation(point);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n4 = object.getCharCount();
                Point point2 = styledText.getLocationAtOffset(n4);
                if (point.y >= point2.y) {
                    try {
                        n6 = styledText.getOffsetAtLocation(new Point(point.x, point2.y));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        n6 = n4;
                    }
                }
                try {
                    n2 = styledText.getOffsetAtLocation(new Point(0, point.y));
                    n = n4;
                    int n7 = object.getLineAtOffset(n2);
                    int n8 = object.getLineCount();
                    if (n7 + 1 < n8) {
                        n = object.getOffsetAtLine(n7 + 1) - 1;
                    }
                    int n9 = styledText.getLineHeight(n2);
                    int n10 = n;
                    while (n10 >= n2) {
                        Point point3 = styledText.getLocationAtOffset(n10);
                        if (point3.x < point.x && point3.y < point.y && point3.y + n9 > point.y) {
                            n6 = n10;
                        }
                        --n10;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    n6 = -1;
                }
            }
            if (n6 != -1 && n6 != this.currentOffset) {
                n4 = object.getLineAtOffset(n6);
                n3 = object.getOffsetAtLine(n4);
                n2 = n6 - n3;
                if (n2 > object.getLine(n4).length()) {
                    n6 = Math.max(0, n6 - 1);
                }
                this.refreshCaret(styledText, this.currentOffset, n6);
                this.currentOffset = n6;
            }
        }
    }

    void refreshCaret(StyledText styledText, int n, int n2) {
        if (n != n2) {
            int n3;
            Point point;
            if (n != -1) {
                point = styledText.getLocationAtOffset(n);
                n3 = styledText.getLineHeight(n);
                styledText.redraw(point.x, point.y, 2, n3, false);
            }
            if (n2 != -1) {
                point = styledText.getLocationAtOffset(n2);
                n3 = styledText.getLineHeight(n2);
                styledText.redraw(point.x, point.y, 2, n3, false);
            }
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        if (this.currentOffset != -1) {
            StyledText styledText = (StyledText)this.getControl();
            styledText.setSelection(this.currentOffset);
            this.currentOffset = -1;
        }
    }
}

