/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int accelerator;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        menu.createItem(this, menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        menu.createItem(this, n2);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    int createEmptyMenu() {
        if ((this.parent.style & 2) != 0) {
            int[] nArray = new int[1];
            if (OS.CreateNewMenu((short)0, 0, nArray) != 0) {
                this.error(2);
            }
            return nArray[0];
        }
        return 0;
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if ((this.parent.style & 2) != 0) {
            int n = this.parent.indexOf(this);
            if (n == -1) {
                return new Rectangle(0, 0, 0, 0);
            }
            Menu menu = this.display.getMenuBar();
            if (this.parent != menu) {
                return new Rectangle(0, 0, 0, 0);
            }
            int[] nArray = new int[1];
            if (OS.GetMenuItemHierarchicalMenu(menu.handle, (short)(n + 1), nArray) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            Rect rect = new Rect();
            int n2 = rect.right - rect.left;
            int n3 = rect.bottom - rect.top;
            return new Rectangle(rect.left, rect.top, n2, n3);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return false;
        }
        short[] sArray = new short[1];
        OS.GetItemMark(this.parent.handle, (short)(n + 1), sArray);
        return sArray[0] != 0;
    }

    int kEventProcessCommand(int n, int n2, int n3) {
        if (!this.isEnabled()) {
            return 0;
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray);
        Event event = new Event();
        this.setInputState(event, 0, OS.GetCurrentEventButtonState(), nArray[0]);
        this.postEvent(13, event);
        return 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    int keyGlyph(int n) {
        switch (n) {
            case 8: {
                return 23;
            }
            case 13: {
                return 11;
            }
            case 127: {
                return 10;
            }
            case 27: {
                return 27;
            }
            case 10: {
                return 11;
            }
            case 9: {
                return 2;
            }
            case 32: {
                return 97;
            }
            case 65536: {
                return 7;
            }
            case 131072: {
                return 5;
            }
            case 262144: {
                return 138;
            }
            case 0x400000: {
                return 17;
            }
            case 0x1000001: {
                return 104;
            }
            case 0x1000002: {
                return 106;
            }
            case 0x1000003: {
                return 100;
            }
            case 0x1000004: {
                return 101;
            }
            case 0x1000005: {
                return 98;
            }
            case 0x1000006: {
                return 107;
            }
            case 0x100000A: {
                return 111;
            }
            case 0x100000B: {
                return 112;
            }
            case 0x100000C: {
                return 113;
            }
            case 0x100000D: {
                return 114;
            }
            case 0x100000E: {
                return 115;
            }
            case 0x100000F: {
                return 116;
            }
            case 0x1000010: {
                return 117;
            }
            case 0x1000011: {
                return 118;
            }
            case 0x1000012: {
                return 119;
            }
            case 0x1000013: {
                return 120;
            }
            case 0x1000014: {
                return 121;
            }
            case 0x1000015: {
                return 122;
            }
        }
        return 0;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void select() {
        Menu menu;
        this.checkWidget();
        Menu menu2 = this.parent;
        while (menu2.cascade != null && (menu = menu2.cascade.parent) != null) {
            if ((menu.style & 2) != 0) break;
            menu2 = menu;
        }
        if (menu2 == null) {
            return;
        }
        OS.HiliteMenu(OS.GetMenuID(menu2.handle));
        int[] nArray = new int[1];
        OS.CreateEvent(0, 1668113523, 1, 0.0, 0, nArray);
        if (nArray[0] != 0) {
            int n = this.parent.handle;
            HICommand hICommand = new HICommand();
            hICommand.attributes = 1;
            hICommand.menu_menuRef = n;
            hICommand.menu_menuItemIndex = (short)(this.parent.indexOf(this) + 1);
            OS.SetEventParameter(nArray[0], 0x2D2D2D2D, 1751346532, 14, hICommand);
            OS.SendEventToEventTarget(nArray[0], OS.GetApplicationEventTarget());
            OS.ReleaseEvent(nArray[0]);
        }
    }

    void selectRadio() {
        int n = 0;
        MenuItem[] menuItemArray = this.parent.getItems();
        while (n < menuItemArray.length && menuItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && menuItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < menuItemArray.length && menuItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        boolean bl = this.accelerator == 0 && n != 0 || this.accelerator != 0 && n == 0;
        this.accelerator = n;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n != 0) {
            int n6;
            n5 = n & 0x100FFFF;
            n4 = this.keyGlyph(n5);
            int s = Display.untranslateKey(n5);
            if (n5 == 32) {
                n6 = 49;
            }
            if (n6 != 0) {
                bl2 = true;
                n5 = n6;
            } else {
                n5 = Character.toUpperCase((char)n5);
            }
            n3 = 8;
            if ((n & 0x20000) != 0) {
                n3 |= 1;
            }
            if ((n & 0x40000) != 0) {
                n3 |= 4;
            }
            if ((n & 0x400000) != 0) {
                n3 &= 0xFFFFFFF7;
            }
            if ((n & 0x10000) != 0) {
                n3 |= 2;
            }
        }
        short s = (short)(n2 + 1);
        OS.SetMenuItemModifiers(this.parent.handle, s, (byte)n3);
        OS.SetMenuItemCommandKey(this.parent.handle, s, bl2, (char)n5);
        OS.SetMenuItemKeyGlyph(this.parent.handle, s, (short)n4);
        if (bl) {
            this.updateText(s);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        int[] nArray = new int[1];
        short s = (short)(n + 1);
        OS.GetMenuItemHierarchicalMenu(this.parent.handle, s, nArray);
        if (bl) {
            this.state &= 0xFFFFFFF7;
            if (nArray[0] != 0) {
                OS.EnableMenuItem(nArray[0], (short)0);
            }
            OS.EnableMenuItem(this.parent.handle, s);
        } else {
            this.state |= 8;
            if (nArray[0] != 0) {
                OS.DisableMenuItem(nArray[0], (short)0);
            }
            OS.DisableMenuItem(this.parent.handle, s);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setImage(image);
        int n2 = image != null ? image.handle : 0;
        byte by = image != null ? (byte)7 : 0;
        OS.SetMenuItemIconHandle(this.parent.handle, (short)(n + 1), by, n2);
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        int n2 = 0;
        if (menu == null) {
            n2 = this.createEmptyMenu();
        } else {
            menu.cascade = this;
            n2 = menu.handle;
        }
        short s = (short)(n + 1);
        if (n2 != 0) {
            int[] nArray = new int[1];
            if (OS.CopyMenuItemTextAsCFString(this.parent.handle, s, nArray) != 0) {
                this.error(29);
            }
            OS.SetMenuTitleWithCFString(n2, nArray[0]);
            OS.CFRelease(nArray[0]);
        }
        if (menu2 != null) {
            OS.RetainMenu(menu2.handle);
        }
        if (OS.SetMenuItemHierarchicalMenu(this.parent.handle, s, n2) != 0) {
            this.error(29);
        }
        if (n2 != 0) {
            OS.ReleaseMenu(n2);
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        int n2 = bl ? ((this.style & 0x10) != 0 ? 19 : 18) : 0;
        OS.SetItemMark(this.parent.handle, (short)(n + 1), (short)n2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setText(string);
        this.updateText((short)(n + 1));
    }

    void updateText(short s) {
        int n;
        if ((this.style & 2) != 0) {
            return;
        }
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\t') break;
            if ((cArray[n3++] = cArray[n2++]) != '&' || n2 == cArray.length) continue;
            if (cArray[n2] == '&') {
                ++n2;
                continue;
            }
            --n3;
        }
        if ((n = OS.CFStringCreateWithCharacters(0, cArray, n3)) == 0) {
            this.error(13);
        }
        OS.SetMenuItemTextWithCFString(this.parent.handle, s, n);
        int[] nArray = new int[1];
        OS.GetMenuItemHierarchicalMenu(this.parent.handle, s, nArray);
        if (nArray[0] != 0) {
            OS.SetMenuTitleWithCFString(nArray[0], n);
        }
        OS.CFRelease(n);
    }
}

