/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.CloneableCompatibility;

public class StyleRange
extends TextStyle
implements CloneableCompatibility {
    public int start;
    public int length;
    public int fontStyle = 0;

    public StyleRange() {
        super(null, null, null);
    }

    public StyleRange(int n, int n2, Color color, Color color2) {
        super(null, color, color2);
        this.start = n;
        this.length = n2;
    }

    public StyleRange(int n, int n2, Color color, Color color2, int n3) {
        this(n, n2, color, color2);
        this.fontStyle = n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StyleRange) {
            StyleRange styleRange = (StyleRange)object;
            if (this.start != styleRange.start) {
                return false;
            }
            if (this.length != styleRange.length) {
                return false;
            }
            return this.similarTo(styleRange);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.fontStyle;
    }

    boolean isVariableHeight() {
        return this.font != null || this.metrics != null || this.rise != 0;
    }

    public boolean isUnstyled() {
        if (this.font != null) {
            return false;
        }
        if (this.rise != 0) {
            return false;
        }
        if (this.metrics != null) {
            return false;
        }
        if (this.foreground != null) {
            return false;
        }
        if (this.background != null) {
            return false;
        }
        if (this.fontStyle != 0) {
            return false;
        }
        if (this.underline) {
            return false;
        }
        return !this.strikeout;
    }

    public boolean similarTo(StyleRange styleRange) {
        if (!super.equals(styleRange)) {
            return false;
        }
        return this.fontStyle == styleRange.fontStyle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StyleRange {");
        stringBuffer.append(this.start);
        stringBuffer.append(", ");
        stringBuffer.append(this.length);
        stringBuffer.append(", fontStyle=");
        switch (this.fontStyle) {
            case 1: {
                stringBuffer.append("bold");
                break;
            }
            case 2: {
                stringBuffer.append("italic");
                break;
            }
            case 3: {
                stringBuffer.append("bold-italic");
                break;
            }
            default: {
                stringBuffer.append("normal");
            }
        }
        String string = super.toString();
        int n = string.indexOf(123);
        string = string.substring(n + 1);
        if (string.length() > 1) {
            stringBuffer.append(", ");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

