/**
 * OverwriteDialog : 파일 덮어쓰기 대화상자 
 */
package net.kldp.jzip;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;

/**
 * 파일 덮어쓰기 대화상자
 * 
 * @author jeongseungwon
 * 
 */
public class OverwriteDialog {

	/**
	 * {@link KeyAdapter}를 구현하는 클래스
	 * 
	 * @author jeongseungwon
	 *
	 */
	private final class CancelAdaptor extends org.eclipse.swt.events.KeyAdapter {
		public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
			if (e.keyCode == SWT.ESC) {
				// ESC 키를 누른 경우
				overwrite = CANCEL;
				
				sShell.dispose();
			}				
		}
	}

	/**
	 * 예
	 */
	public static final int YES = 0;

	/**
	 * 아니오
	 */
	public static final int NO = 1;

	/**
	 * 모두 예
	 */
	public static final int ALL_YES = 2;

	/**
	 * 모두 아니오
	 */
	public static final int ALL_NO = 3;

	/**
	 * 취소
	 */
	public static final int CANCEL = 4;

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="18,27"

	private Label label = null;

	/**
	 * 덮어쓰기 여부
	 */
	private int overwrite;

	private Composite composite = null;

	private Button buttonYes = null;

	private Button buttonNo = null;

	private Button buttonAllYes = null;

	private Button buttonAllNo = null;

	/**
	 * OverwriteDialog의 생성자
	 */
	public OverwriteDialog() {
		overwrite = NO;
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData = new GridData();
		gridData.verticalAlignment = GridData.FILL;
		gridData.widthHint = 380;
		gridData.heightHint = 90;
		gridData.grabExcessHorizontalSpace = false;
		gridData.grabExcessVerticalSpace = false;
		gridData.horizontalAlignment = GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = false;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.verticalSpacing = 15;
		gridLayout1.marginWidth = 9;
		gridLayout1.marginHeight = 15;
		gridLayout1.makeColumnsEqualWidth = false;
		sShell = new Shell(SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM);
		sShell.setLayout(gridLayout);
		sShell.setSize(new Point(390, 141));
		sShell.setText("파일을 덮어쓸까요?");
		label = new Label(sShell, SWT.HORIZONTAL | SWT.WRAP);
		label.setText(" 파일이 이미 존재합니다.\n\n이 파일을 덮어쓸까요?");
		label.setLayoutData(gridData);
		createComposite();
		sShell.setLayout(gridLayout1);
		sShell.setSize(new Point(400, 155));
		sShell.addShellListener(new org.eclipse.swt.events.ShellAdapter() {
			public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
				overwrite = CANCEL;
			}
		});
		sShell.addKeyListener(new CancelAdaptor());
	}

	/**
	 * 파일 덮어쓰기 확인 대화상자를 화면에 표시하는 메소드
	 * 
	 * @param parent
	 *            부모 쉘
	 * @param fileName
	 *            덮어쓸 파일명
	 * @return 사용자의 응답
	 */
	public int open(Shell parent, String fileName) {
		createSShell();

		label.setText(fileName + label.getText());

		sShell.setParent(parent);
		
		sShell.pack();
		
		sShell.open();
		Display display = parent.getDisplay();
		while (!sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		return overwrite;
	}

	/**
	 * This method initializes composite	
	 *
	 */
	private void createComposite() {
		GridData gridData1 = new GridData();
		gridData1.verticalAlignment = GridData.END;
		gridData1.horizontalAlignment = GridData.END;
		composite = new Composite(sShell, SWT.NONE);
		composite.setLayout(new RowLayout());
		composite.setLayoutData(gridData1);
		composite.addKeyListener(new CancelAdaptor());
		buttonYes = new Button(composite, SWT.NONE);
		buttonYes.setText("예(&Y)");
		buttonYes.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				overwrite = YES;
				
				sShell.dispose();
			}
		});
		buttonYes.addKeyListener(new CancelAdaptor());
		buttonNo = new Button(composite, SWT.NONE);
		buttonNo.setText("아니오(&N)");
		buttonNo.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				overwrite = NO;
				
				sShell.dispose();
			}
		});
		buttonNo.addKeyListener(new CancelAdaptor());
		buttonAllYes = new Button(composite, SWT.NONE);
		buttonAllYes.setText("모두 예(&A)");
		buttonAllYes
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						overwrite = ALL_YES;
						
						sShell.dispose();
					}
				});
		buttonAllYes.addKeyListener(new CancelAdaptor());
		buttonAllNo = new Button(composite, SWT.NONE);
		buttonAllNo.setText("모두 아니오");
		buttonAllNo.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				overwrite = ALL_NO;
				
				sShell.dispose();
			}
		});
		buttonAllNo.addKeyListener(new CancelAdaptor());
	}

}
