/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jzip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Zip {
    private File file;
    private ZipEntry[] zipEntries;
    private ZipFile zipFile;

    public static String getNewName(ZipEntry originalEntry, String newName) {
        File file = new File(originalEntry.getName());
        String parent = file.getParent();
        if (parent == null) {
            return newName;
        }
        File newFile = new File(parent, newName);
        return newFile.getPath();
    }

    public static String getSizeString(long size) {
        int n = 1024;
        int n2 = 0x100000;
        int n3 = 0x40000000;
        double newSize = size;
        String sizeString = "";
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        sizeString = size >= 0x40000000L ? String.valueOf(nf.format(newSize /= 1.073741824E9)) + " GB" : (size >= 0x100000L ? String.valueOf(nf.format(newSize /= 1048576.0)) + " MB" : (size >= 1024L ? String.valueOf(nf.format(newSize /= 1024.0)) + " KB" : String.valueOf(size) + " \ubc14\uc774\ud2b8"));
        return sizeString;
    }

    public static String getTimeString(long time) {
        String timeString = null;
        if (time != -1L) {
            Date date = new Date(time);
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            timeString = df.format(date);
        } else {
            timeString = "\uc54c \uc218 \uc5c6\uc74c";
        }
        return timeString;
    }

    public Zip(File file, ZipFile zipFile) {
        this.file = file;
        this.zipFile = zipFile;
        Enumeration entries = zipFile.getEntries();
        int i = 0;
        i = 0;
        while (entries.hasMoreElements()) {
            entries.nextElement();
            ++i;
        }
        this.zipEntries = new ZipEntry[i];
        entries = zipFile.getEntries();
        i = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry;
            this.zipEntries[i] = entry = (ZipEntry)entries.nextElement();
            ++i;
        }
    }

    public String getEncoding() {
        return this.zipFile.getEncoding();
    }

    public long getFileSize() {
        return this.file.length();
    }

    public InputStream getInputStream(ZipEntry entry) {
        InputStream is = null;
        try {
            is = this.zipFile.getInputStream(entry);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    public String[] getStrings(int index) {
        String name = this.getZipEntryName(index);
        String size = Zip.getSizeString(this.getZipEntrySize(index));
        String type = this.getZipEntryType(index);
        String time = Zip.getTimeString(this.getZipEntryTime(index));
        String path = this.getZipEntryPath(index);
        return new String[]{name, size, type, time, path};
    }

    public ZipEntry getZipEntry(int i) {
        return this.zipEntries[i];
    }

    public String getZipEntryName(int index) {
        File file = new File(this.getZipEntry(index).getName());
        return file.getName();
    }

    private String getZipEntryName(ZipEntry entry) {
        File file = new File(entry.getName());
        return file.getName();
    }

    private String getZipEntryPath(int index) {
        File file = new File(this.getZipEntry(index).getName());
        String parent = file.getParent();
        if (parent != null) {
            return "/" + parent;
        }
        return "/";
    }

    private String getZipEntryPath(ZipEntry entry) {
        File file = new File(entry.getName());
        String parent = file.getParent();
        if (parent != null) {
            return "/" + parent;
        }
        return "/";
    }

    public long getZipEntrySize(int index) {
        return this.getZipEntry(index).getSize();
    }

    private long getZipEntryTime(int index) {
        return this.getZipEntry(index).getTime();
    }

    private String getZipEntryType(int index) {
        String type = null;
        type = this.getZipEntry(index).isDirectory() ? "\ub514\ub809\ud1a0\ub9ac" : "\ud30c\uc77c";
        return type;
    }

    public String getZipFileName() {
        return this.file.getName();
    }

    public String getZipFilePath() {
        return this.file.getParent();
    }

    public long getZipFileSize() {
        long zipFileSize = 0L;
        int i = 0;
        while (i < this.zipEntries.length) {
            zipFileSize += this.getZipEntrySize(i);
            ++i;
        }
        return zipFileSize;
    }

    public ZipOutputStream getZipOutputStream() {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zos;
    }

    public int getZipSize() {
        return this.zipEntries.length;
    }

    public void sort(String string, boolean reverse) {
        if (string.equals("\uc774\ub984")) {
            Arrays.sort(this.zipEntries, new NameComparator(reverse));
        } else if (string.equals("\ud06c\uae30")) {
            Arrays.sort(this.zipEntries, new SizeComparator(reverse));
        } else if (string.equals("\ud615\uc2dd")) {
            Arrays.sort(this.zipEntries, new TypeComparator(reverse));
        } else if (string.equals("\ubc14\ub010 \uc2dc\uac04")) {
            Arrays.sort(this.zipEntries, new TimeComparator(reverse));
        } else if (string.equals("\uc704\uce58")) {
            Arrays.sort(this.zipEntries, new PathComparator(reverse));
        }
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public File getFile() {
        return this.file;
    }

    private final class NameComparator
    implements Comparator<ZipEntry> {
        private final boolean reverse;

        private NameComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            String name1 = Zip.this.getZipEntryName(o1);
            String name2 = Zip.this.getZipEntryName(o2);
            if (!this.reverse) {
                return name1.compareTo(name2);
            }
            return name2.compareTo(name1);
        }
    }

    private final class PathComparator
    implements Comparator<ZipEntry> {
        private final boolean reverse;

        private PathComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            String path1 = Zip.this.getZipEntryPath(o1);
            String path2 = Zip.this.getZipEntryPath(o2);
            if (!this.reverse) {
                return path2.compareTo(path1);
            }
            return path1.compareTo(path2);
        }
    }

    private final class SizeComparator
    implements Comparator<ZipEntry> {
        private final boolean reverse;

        private SizeComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            long size2;
            long size1 = o1.getSize();
            if (size1 == (size2 = o2.getSize())) {
                return 0;
            }
            if (!this.reverse) {
                return size1 > size2 ? 1 : -1;
            }
            return size1 < size2 ? 1 : -1;
        }
    }

    private final class TimeComparator
    implements Comparator<ZipEntry> {
        private final boolean reverse;

        private TimeComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            long time2;
            long time1 = o1.getTime();
            if (time1 == (time2 = o2.getTime())) {
                return 0;
            }
            if (!this.reverse) {
                return time1 > time2 ? 1 : -1;
            }
            return time1 < time2 ? 1 : -1;
        }
    }

    private final class TypeComparator
    implements Comparator<ZipEntry> {
        private final boolean reverse;

        private TypeComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            String type1 = null;
            type1 = o1.isDirectory() ? "\ub514\ub809\ud1a0\ub9ac" : "\ud30c\uc77c";
            String type2 = null;
            type2 = o2.isDirectory() ? "\ub514\ub809\ud1a0\ub9ac" : "\ud30c\uc77c";
            if (!this.reverse) {
                return type1.compareTo(type2);
            }
            return type2.compareTo(type1);
        }
    }
}

