/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    String text = "";
    Image image;
    boolean isImage;

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Label.checkBits(n, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                n3 = 64;
                n4 = 3;
            } else {
                n3 = 3;
                n4 = 64;
            }
        } else if (this.isImage && this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            n3 = rectangle.width;
            n4 = rectangle.height;
        } else {
            int[] nArray = new int[1];
            OS.GetControlData(this.handle, (short)0, 1667658612, 4, nArray, null);
            Point point = this.textExtent(nArray[0], (this.style & 0x40) != 0 && n != -1 ? n : 0);
            if (nArray[0] != 0) {
                OS.CFRelease(nArray[0]);
            }
            n3 = point.x;
            n4 = point.y;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        this.state |= 0x820;
        int[] nArray = new int[1];
        int n = OS.GetControlOwner(this.parent.handle);
        if ((this.style & 2) != 0) {
            OS.CreateSeparatorControl(n, null, nArray);
        } else {
            int n2 = -2;
            if ((this.style & 0x1000000) != 0) {
                n2 = 1;
            }
            if ((this.style & 0x20000) != 0) {
                n2 = -1;
            }
            ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 0x40);
            controlFontStyleRec.just = (short)n2;
            OS.CreateStaticTextControl(n, null, 0, controlFontStyleRec, nArray);
        }
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 105;
    }

    void drawBackground(int n, int n2) {
        this.fillBackground(n, n2, null);
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        if (this.isImage && this.image != null) {
            GCData gCData = new GCData();
            gCData.paintEvent = n5;
            gCData.visibleRgn = n4;
            GC gC = GC.carbon_new(this, gCData);
            int n6 = 0;
            Point point = this.getSize();
            Rectangle rectangle = this.image.getBounds();
            if ((this.style & 0x1000000) != 0) {
                n6 = (point.x - rectangle.width) / 2;
            }
            if ((this.style & 0x20000) != 0) {
                n6 = point.x - rectangle.width;
            }
            gC.drawImage(this.image, n6, 0);
            gC.dispose();
        }
        super.drawWidget(n, n2, n3, n4, n5);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return (this.style & 0x800) != 0 ? 1 : 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n2 = -2;
        if ((n & 0x1000000) != 0) {
            n2 = 1;
        }
        if ((n & 0x20000) != 0) {
            n2 = -1;
        }
        ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
        OS.GetControlData(this.handle, (short)0, 1718578804, 24, controlFontStyleRec, null);
        controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 0x40);
        controlFontStyleRec.just = (short)n2;
        OS.SetControlFontStyle(this.handle, controlFontStyleRec);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.isImage = true;
        if (image == null) {
            this.setText(this.text);
            return;
        }
        if (this.text.length() > 0) {
            int n = OS.CFStringCreateWithCharacters(0, null, 0);
            if (n == 0) {
                this.error(13);
            }
            OS.SetControlData(this.handle, 0, 1667658612, 4, new int[]{n});
            OS.CFRelease(n);
        }
        this.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.isImage = false;
        this.text = string;
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        if (n2 == 0) {
            this.error(13);
        }
        OS.SetControlData(this.handle, 0, 1667658612, 4, new int[]{n2});
        OS.CFRelease(n2);
        this.redraw();
    }
}

