/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jzip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import net.kldp.jzip.OverwriteDialog;
import net.kldp.jzip.RenameDialog;
import net.kldp.jzip.Zip;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class JZip {
    private final int BUFFER_SIZE = 8192;
    private MenuItem checkReverse = null;
    private MenuItem checkStatusLine = null;
    private String defaultPath = null;
    private final String jzip = "JZip 0.3";
    private Menu menuBar = null;
    private MenuItem pushAddFile = null;
    private MenuItem pushClose = null;
    private MenuItem pushDeselectAll = null;
    private MenuItem pushExtract = null;
    private MenuItem pushProperty = null;
    private MenuItem pushRefresh = null;
    private MenuItem pushSaveAs = null;
    private MenuItem pushSelectAll = null;
    private MenuItem radioMs949 = null;
    private MenuItem radioName = null;
    private MenuItem radioPath = null;
    private MenuItem radioSize = null;
    private MenuItem radioTime = null;
    private MenuItem radioType = null;
    private MenuItem radioUtf8 = null;
    private DragSource source = null;
    private Shell sShell = null;
    private Label statusLine = null;
    private Label statusSeparator = null;
    private Menu submenuAlignment = null;
    private Menu submenuArchive = null;
    private Menu submenuEdit = null;
    private Menu submenuHelp = null;
    private MenuItem submenuItemAlignment = null;
    private Menu submenuView = null;
    private Table table = null;
    private TableColumn tableColumnName = null;
    private TableColumn tableColumnPath = null;
    private TableColumn tableColumnSize = null;
    private TableColumn tableColumnTime = null;
    private TableColumn tableColumnType = null;
    private DropTarget target = null;
    private File tempDirectory = null;
    private Zip zip = null;
    private MenuItem pushRename = null;
    private MenuItem pushDelete = null;
    private Menu contextMenu = null;
    private MenuItem itemRename = null;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        JZip thisClass = new JZip();
        thisClass.createSShell();
        thisClass.tempDirectory = new File(System.getProperty("java.io.tmpdir"), "JZip");
        thisClass.defaultPath = System.getProperty("user.home");
        thisClass.showStatusLine();
        thisClass.setDnD();
        thisClass.setContextMenu();
        if (args.length == 1 && args[0] != null) {
            thisClass.openArchive(args[0]);
        }
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void about() {
        StringBuffer message = new StringBuffer(70);
        message.append("JZip 0.3\n");
        message.append("\n\uc774 \ud504\ub85c\uadf8\ub7a8\uc740 Zip \ud30c\uc77c\uc758 \uc555\ucd95\uc744 \ud480\uc5b4\uc8fc\ub294 \ud504\ub85c\uadf8\ub7a8\uc785\ub2c8\ub2e4.");
        message.append("\n\uc708\ub3c4\uc6b0\ub098 \ub9ac\ub205\uc2a4\uc5d0\uc11c \uc555\ucd95\ub41c Zip \ud30c\uc77c\uc744 \ud55c\uae00 \ud30c\uc77c\uba85\uc774 \uae68\uc9c0\ub294 \ubb38\uc81c \uc5c6\uc774 \ud480 \uc218 \uc788\uc2b5\ub2c8\ub2e4.\n");
        message.append("\n\uc800\uc791\uad8c\t:  GNU General Public License");
        message.append("\n\ud648\ud398\uc774\uc9c0\t:  http://jzip.kldp.net");
        message.append("\n\uac1c\ubc1c\uc790\t:  \uc815\uc2b9\uc6d0 (jeongseungwon@hanmail.net)");
        this.dialog("JZip \uc815\ubcf4", message.toString(), 2);
    }

    private void addFile(ZipOutputStream zos, String parent, String fileName) {
        File file = new File(parent, fileName);
        String string = "\ud30c\uc77c \ub354\ud558\uae30  \uc2e4\ud328!";
        String message = null;
        if (!file.exists()) {
            message = String.valueOf(fileName) + " \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
            this.dialog("\ud30c\uc77c \ub354\ud558\uae30  \uc2e4\ud328!", message, 1);
            return;
        }
        if (!file.canRead()) {
            message = String.valueOf(fileName) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc77d\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            this.dialog("\ud30c\uc77c \ub354\ud558\uae30  \uc2e4\ud328!", message, 1);
            return;
        }
        ZipEntry entry = this.newZipEntry(file);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.saveEntry(zos, entry, is);
    }

    private boolean addFiles(String parent, String[] fileNames) {
        String encoding = this.zip.getEncoding();
        if (!this.tempDirectory.exists()) {
            this.tempDirectory.mkdirs();
        }
        File tempFile = new File(this.tempDirectory, this.zip.getZipFileName());
        this.copyFile(this.zip.getFile(), tempFile);
        ZipFile tempZipFile = null;
        try {
            tempZipFile = new ZipFile(tempFile, encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Zip tempZip = new Zip(tempFile, tempZipFile);
        ZipOutputStream zos = this.zip.getZipOutputStream();
        zos.setEncoding(encoding);
        this.copyZipFile(tempZip, zos);
        String[] stringArray = fileNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String element = stringArray[n];
            this.addFile(zos, parent, element);
            ++n;
        }
        try {
            zos.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void addFilesToArchive() {
        if (this.zip == null) {
            return;
        }
        if (!this.zip.canWrite()) {
            String text = "\uc774\ub984 \ubc14\uafb8\uae30 \uc2e4\ud328!";
            String message = String.valueOf(this.zip.getName()) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return;
        }
        FileDialog dialog = new FileDialog(this.sShell, 4098);
        dialog.setText("\uc555\ucd95 \ud30c\uc77c\uc5d0 \ub354\ud560 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        dialog.setFilterPath(this.defaultPath);
        dialog.open();
        String parent = dialog.getFilterPath();
        String[] files = dialog.getFileNames();
        if (files != null) {
            this.statusLine.setText("\ud30c\uc77c\uc744 \ub354\ud558\ub294 \uc911\uc785\ub2c8\ub2e4.");
            this.statusLine.update();
            if (this.addFiles(parent, files)) {
                this.refresh();
            } else {
                this.setStatusLine();
            }
        }
    }

    private void closeArchive() {
        if (this.zip == null) {
            return;
        }
        this.zip = null;
        this.table.removeAll();
        this.table.setVisible(false);
        this.disableMenus();
        this.setStatusLine();
        this.sShell.setText("JZip 0.3");
    }

    private void copyFile(File file1, File file2) {
        try {
            FileInputStream fis = new FileInputStream(file1);
            FileOutputStream fos = new FileOutputStream(file2);
            byte[] buffer = new byte[8192];
            int read = 0;
            read = fis.read(buffer);
            while (read != -1) {
                fos.write(buffer, 0, read);
                read = fis.read(buffer);
            }
            fis.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyZipFile(Zip tempZip, ZipOutputStream zos) {
        int i = 0;
        while (i < tempZip.getZipSize()) {
            ZipEntry originalEntry = tempZip.getZipEntry(i);
            ZipEntry entry = this.newZipEntry(originalEntry);
            this.saveEntry(zos, entry, tempZip.getInputStream(originalEntry));
            ++i;
        }
    }

    private void createNewArchive() {
        FileDialog dialog = new FileDialog(this.sShell, 8192);
        dialog.setText("\uc0c8\ub85c \ub9cc\ub4e4 \uc555\ucd95 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        dialog.setFilterPath(this.defaultPath);
        dialog.setFilterExtensions(new String[]{"*.zip", "*.jar", "*.*"});
        dialog.setFilterNames(new String[]{"Zip \ud30c\uc77c (*.zip)", "Jar \ud30c\uc77c (*.jar)", "\ubaa8\ub4e0 \ud30c\uc77c (*.*)"});
        String file = dialog.open();
        if (file != null && this.saveArchive(file)) {
            this.radioMs949.setSelection(true);
            this.radioUtf8.setSelection(false);
            this.openArchive(file);
        }
    }

    private void createSShell() {
        this.sShell = new Shell();
        this.sShell.setText("JZip 0.3");
        this.sShell.setLayout(new FormLayout());
        this.sShell.setSize(new Point(720, 400));
        this.menuBar = new Menu(this.sShell, 2);
        MenuItem submenuItemArchive = new MenuItem(this.menuBar, 64);
        submenuItemArchive.setText("\uc555\ucd95 \ud30c\uc77c(&A)");
        MenuItem submenuItemEdit = new MenuItem(this.menuBar, 64);
        submenuItemEdit.setText("\ud3b8\uc9d1(&E)");
        this.submenuEdit = new Menu(submenuItemEdit);
        this.pushAddFile = new MenuItem(this.submenuEdit, 8);
        this.pushAddFile.setText("\ud30c\uc77c \ub354\ud558\uae30(&F)...");
        this.pushAddFile.setEnabled(false);
        this.pushAddFile.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc555\ucd95 \ud30c\uc77c\uc5d0 \ud30c\uc77c\uc744 \ub354\ud569\ub2c8\ub2e4.");
            }
        });
        this.pushAddFile.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.addFilesToArchive();
            }
        });
        MenuItem menuSeparator2 = new MenuItem(this.submenuEdit, 2);
        this.pushRename = new MenuItem(this.submenuEdit, 8);
        this.pushRename.setText("\uc774\ub984 \ubc14\uafb8\uae30(&R)...\tF2");
        this.pushRename.setAccelerator(0x100000B);
        this.pushRename.setEnabled(false);
        this.pushRename.addArmListener(new RenameArmListener());
        this.pushRename.addSelectionListener(new RenameSelectionListener());
        this.pushDelete = new MenuItem(this.submenuEdit, 8);
        this.pushDelete.setText("\uc9c0\uc6b0\uae30(&D)...\tDel");
        this.pushDelete.setAccelerator(127);
        this.pushDelete.setEnabled(false);
        this.pushDelete.addArmListener(new DeleteArmListener());
        this.pushDelete.addSelectionListener(new DeleteSelectionListener());
        MenuItem menuSeparator4 = new MenuItem(this.submenuEdit, 2);
        this.pushSelectAll = new MenuItem(this.submenuEdit, 8);
        this.pushDeselectAll = new MenuItem(this.submenuEdit, 8);
        this.pushDeselectAll.setEnabled(false);
        this.pushDeselectAll.setText("\ubaa8\ub450 \uc120\ud0dd \ud574\uc81c(&U)");
        this.pushDeselectAll.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ubaa8\ub4e0 \ud56d\ubaa9\uc744 \uc120\ud0dd \ud574\uc81c\ud569\ub2c8\ub2e4.");
            }
        });
        this.pushDeselectAll.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.deselectAll();
            }
        });
        this.submenuEdit.addMenuListener(new MenuListener(){

            @Override
            public void menuHidden(MenuEvent e) {
                JZip.this.setStatusLine();
            }

            @Override
            public void menuShown(MenuEvent e) {
            }
        });
        this.pushSelectAll.setText("\ubaa8\ub450 \uc120\ud0dd(&A)\tCtrl+A");
        this.pushSelectAll.setAccelerator(262209);
        this.pushSelectAll.setEnabled(false);
        this.pushSelectAll.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.selectAll();
            }
        });
        this.pushSelectAll.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ubaa8\ub4e0 \ud56d\ubaa9\uc744 \uc120\ud0dd\ud569\ub2c8\ub2e4.");
            }
        });
        submenuItemEdit.setMenu(this.submenuEdit);
        MenuItem submenuItemView = new MenuItem(this.menuBar, 64);
        submenuItemView.setText("\ubcf4\uae30(&V)");
        MenuItem submenuItemHelp = new MenuItem(this.menuBar, 64);
        submenuItemHelp.setText("\ub3c4\uc6c0\ub9d0(&H)");
        this.submenuView = new Menu(submenuItemView);
        this.pushRefresh = new MenuItem(this.submenuView, 8);
        this.pushRefresh.setText("\uc0c8\ub85c \uace0\uce68(&R)\tF5");
        this.pushRefresh.setEnabled(false);
        this.pushRefresh.setAccelerator(0x100000E);
        this.pushRefresh.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.refresh();
            }
        });
        this.pushRefresh.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc555\ucd95 \ud30c\uc77c\uc744 \ub2e4\uc2dc \ubd88\ub7ec\uc635\ub2c8\ub2e4.");
            }
        });
        MenuItem separator1 = new MenuItem(this.submenuView, 2);
        this.radioMs949 = new MenuItem(this.submenuView, 16);
        this.submenuView.addMenuListener(new MenuListener(){

            @Override
            public void menuHidden(MenuEvent e) {
                JZip.this.setStatusLine();
            }

            @Override
            public void menuShown(MenuEvent e) {
            }
        });
        this.radioUtf8 = new MenuItem(this.submenuView, 16);
        this.radioUtf8.setText("UTF-8 (\ub9ac\ub205\uc2a4)(&U)");
        this.radioUtf8.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!JZip.this.radioUtf8.getSelection()) {
                    JZip.this.refresh();
                }
            }
        });
        this.radioUtf8.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc778\ucf54\ub529\uc744 UTF-8(\ub9ac\ub205\uc2a4)\ub85c \ubcc0\uacbd\ud569\ub2c8\ub2e4.");
            }
        });
        this.radioMs949.setText("MS949 (\uc708\ub3c4\uc6b0)(&M)");
        this.radioMs949.setSelection(true);
        this.radioMs949.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!JZip.this.radioMs949.getSelection()) {
                    JZip.this.refresh();
                }
            }
        });
        this.radioMs949.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc778\ucf54\ub529\uc744 MS949(\uc708\ub3c4\uc6b0)\ub85c \ubcc0\uacbd\ud569\ub2c8\ub2e4.");
            }
        });
        MenuItem menuSeparator1 = new MenuItem(this.submenuView, 2);
        this.checkStatusLine = new MenuItem(this.submenuView, 32);
        this.checkStatusLine.setText("\uc0c1\ud0dc \ud45c\uc2dc\uc904(&S)");
        this.checkStatusLine.setSelection(true);
        MenuItem separator = new MenuItem(this.submenuView, 2);
        this.submenuItemAlignment = new MenuItem(this.submenuView, 64);
        this.submenuItemAlignment.setText("\ud56d\ubaa9 \uc815\ub82c(&A)");
        this.submenuItemAlignment.setEnabled(false);
        this.submenuAlignment = new Menu(this.submenuItemAlignment);
        this.radioName = new MenuItem(this.submenuAlignment, 16);
        this.radioName.setText("\uc774\ub984(&N)");
        this.radioName.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.sortByName();
            }
        });
        this.radioName.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc774\ub984\uc5d0 \ub530\ub77c \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        this.radioSize = new MenuItem(this.submenuAlignment, 16);
        this.radioSize.setText("\ud06c\uae30(&S)");
        this.radioSize.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.sortBySize();
            }
        });
        this.radioSize.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ud06c\uae30\uc5d0 \ub530\ub77c \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        this.radioType = new MenuItem(this.submenuAlignment, 16);
        this.radioType.setText("\ud615\uc2dd(&T)");
        this.radioType.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.sortByType();
            }
        });
        this.radioType.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ud615\uc2dd\uc5d0 \ub530\ub77c \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        this.radioTime = new MenuItem(this.submenuAlignment, 16);
        this.radioTime.setText("\ubc14\ub010 \uc2dc\uac04(&D)");
        this.radioTime.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.sortByTime();
            }
        });
        this.radioTime.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ubc14\ub010 \uc2dc\uac04\uc5d0 \ub530\ub77c \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        this.radioPath = new MenuItem(this.submenuAlignment, 16);
        this.radioPath.setText("\uc704\uce58(&P)");
        this.radioPath.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.sortByPath();
            }
        });
        this.radioPath.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc704\uce58\uc5d0 \ub530\ub77c \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        MenuItem menuSeparator3 = new MenuItem(this.submenuAlignment, 2);
        this.checkReverse = new MenuItem(this.submenuAlignment, 32);
        this.checkReverse.setText("\uc5ed\uc21c(&R)");
        this.checkReverse.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.sortReverse();
            }
        });
        this.checkReverse.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uac70\uafb8\ub85c \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        this.submenuItemAlignment.setMenu(this.submenuAlignment);
        this.submenuItemAlignment.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ud56d\ubaa9\uc744 \uc815\ub82c\ud569\ub2c8\ub2e4.");
            }
        });
        this.checkStatusLine.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.toggleStatusLine();
            }
        });
        this.checkStatusLine.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc0c1\ud0dc \ud45c\uc2dc\uc904\uc744 \ubcf4\uc774\uac70\ub098 \uac10\ucda5\ub2c8\ub2e4.");
            }
        });
        submenuItemView.setMenu(this.submenuView);
        this.submenuHelp = new Menu(submenuItemHelp);
        this.submenuHelp.addMenuListener(new MenuListener(){

            @Override
            public void menuHidden(MenuEvent e) {
                JZip.this.setStatusLine();
            }

            @Override
            public void menuShown(MenuEvent e) {
            }
        });
        MenuItem pushAbout = new MenuItem(this.submenuHelp, 8);
        pushAbout.setText("JZip \uc815\ubcf4(&A)...");
        pushAbout.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.about();
            }
        });
        pushAbout.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ud504\ub85c\uadf8\ub7a8 \uc815\ubcf4\ub97c \ubcf4\uc5ec\uc90d\ub2c8\ub2e4.");
            }
        });
        submenuItemHelp.setMenu(this.submenuHelp);
        this.submenuArchive = new Menu(submenuItemArchive);
        MenuItem pushNew = new MenuItem(this.submenuArchive, 8);
        pushNew.setText("\uc0c8\ub85c \ub9cc\ub4e4\uae30(&N)...\tCtrl+N");
        pushNew.setAccelerator(262222);
        pushNew.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc0c8\ub85c\uc6b4 \uc555\ucd95 \ud30c\uc77c\uc744 \uc0dd\uc131\ud569\ub2c8\ub2e4.");
            }
        });
        pushNew.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.createNewArchive();
            }
        });
        this.submenuArchive.addMenuListener(new MenuListener(){

            @Override
            public void menuHidden(MenuEvent e) {
                JZip.this.setStatusLine();
            }

            @Override
            public void menuShown(MenuEvent e) {
            }
        });
        MenuItem pushOpen = new MenuItem(this.submenuArchive, 8);
        pushOpen.setText("\uc5f4\uae30(&O)...\tCtrl+O");
        pushOpen.setAccelerator(262223);
        this.pushSaveAs = new MenuItem(this.submenuArchive, 8);
        this.pushSaveAs.setText("\ub2e4\ub978 \uc774\ub984\uc73c\ub85c \uc800\uc7a5(&S)...\tCtrl+S");
        this.pushSaveAs.setEnabled(false);
        this.pushSaveAs.setAccelerator(262227);
        this.pushSaveAs.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc120\ud0dd\ub41c \ud56d\ubaa9\uc744 \ub2e4\ub978 \uc774\ub984\uc744 \uac00\uc9c4 \uc555\ucd95 \ud30c\uc77c\ub85c \uc800\uc7a5\ud569\ub2c8\ub2e4.");
            }
        });
        this.pushSaveAs.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.saveAs();
            }
        });
        pushOpen.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.open();
            }
        });
        pushOpen.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc555\ucd95 \ud30c\uc77c\uc744 \uc5fd\ub2c8\ub2e4.");
            }
        });
        this.pushExtract = new MenuItem(this.submenuArchive, 8);
        this.pushExtract.setText("\uc555\ucd95 \ud480\uae30(&E)...\tCtrl+E");
        this.pushExtract.setAccelerator(262213);
        this.pushExtract.setEnabled(false);
        this.pushProperty = new MenuItem(this.submenuArchive, 8);
        this.pushProperty.setText("\uc18d\uc131(&P)...");
        this.pushProperty.setEnabled(false);
        this.pushProperty.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc555\ucd95 \ud30c\uc77c\uc758 \uc18d\uc131\uc744 \ubcf4\uc5ec\uc90d\ub2c8\ub2e4.");
            }
        });
        this.pushProperty.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.showProperty();
            }
        });
        this.pushExtract.addSelectionListener(new ExtractSelectionListener());
        this.pushExtract.addArmListener(new ExtractArmListener());
        this.pushClose = new MenuItem(this.submenuArchive, 8);
        this.pushClose.setText("\ub2eb\uae30(&C)");
        this.pushClose.setEnabled(false);
        this.pushClose.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.closeArchive();
            }
        });
        this.pushClose.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\uc555\ucd95 \ud30c\uc77c\uc744 \ub2eb\uc2b5\ub2c8\ub2e4.");
            }
        });
        MenuItem menuSeparator = new MenuItem(this.submenuArchive, 2);
        MenuItem pushQuit = new MenuItem(this.submenuArchive, 8);
        pushQuit.setText("\ud504\ub85c\uadf8\ub7a8 \uc885\ub8cc(&Q)\tCtrl+Q");
        pushQuit.setAccelerator(262225);
        pushQuit.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                JZip.this.deleteAllFiles(JZip.this.tempDirectory);
                System.exit(0);
            }
        });
        pushQuit.addArmListener(new ArmListener(){

            @Override
            public void widgetArmed(ArmEvent e) {
                JZip.this.statusLine.setText("\ud504\ub85c\uadf8\ub7a8\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4.");
            }
        });
        submenuItemArchive.setMenu(this.submenuArchive);
        this.sShell.setMenuBar(this.menuBar);
        this.sShell.addShellListener(new ShellAdapter(){

            @Override
            public void shellClosed(ShellEvent e) {
                JZip.this.deleteAllFiles(JZip.this.tempDirectory);
            }
        });
        this.table = new Table(this.sShell, 0x10000002);
        this.table.addListener(36, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = JZip.this.table.indexOf(item);
                item.setText(JZip.this.zip.getStrings(index));
            }
        });
        this.statusSeparator = new Label(this.sShell, 258);
        this.statusLine = new Label(this.sShell, 0);
        this.statusLine.setText("");
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setVisible(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    JZip.this.contextMenu.setVisible(true);
                    JZip.this.table.setMenu(JZip.this.contextMenu);
                }
            }
        });
        this.table.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                int selectionCount = JZip.this.table.getSelectionCount();
                if (selectionCount == 0) {
                    JZip.this.pushDeselectAll.setEnabled(false);
                    JZip.this.pushDelete.setEnabled(false);
                } else {
                    JZip.this.pushDeselectAll.setEnabled(true);
                    JZip.this.pushDelete.setEnabled(true);
                }
                if (selectionCount == 1) {
                    JZip.this.pushRename.setEnabled(true);
                    JZip.this.itemRename.setEnabled(true);
                } else {
                    JZip.this.pushRename.setEnabled(false);
                    JZip.this.itemRename.setEnabled(false);
                }
                if (selectionCount == JZip.this.table.getItemCount()) {
                    JZip.this.pushSelectAll.setEnabled(false);
                } else {
                    JZip.this.pushSelectAll.setEnabled(true);
                }
                JZip.this.setStatusLine();
            }
        });
        this.tableColumnName = new TableColumn(this.table, 16384);
        this.tableColumnName.setText("\uc774\ub984");
        this.tableColumnName.setWidth(200);
        this.tableColumnName.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (JZip.this.table.getSortColumn() == JZip.this.tableColumnName) {
                    if (JZip.this.table.getSortDirection() == 128) {
                        JZip.this.table.setSortColumn(null);
                    } else {
                        JZip.this.sortTable(JZip.this.tableColumnName, true);
                        JZip.this.table.setSortColumn(JZip.this.tableColumnName);
                        JZip.this.table.setSortDirection(128);
                        JZip.this.setAlignmentMenu(JZip.this.radioName, true);
                    }
                } else {
                    JZip.this.sortTable(JZip.this.tableColumnName, false);
                    JZip.this.table.setSortColumn(JZip.this.tableColumnName);
                    JZip.this.table.setSortDirection(1024);
                    JZip.this.setAlignmentMenu(JZip.this.radioName, false);
                }
            }
        });
        this.tableColumnSize = new TableColumn(this.table, 131072);
        this.tableColumnSize.setText("\ud06c\uae30");
        this.tableColumnSize.setWidth(90);
        this.tableColumnSize.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (JZip.this.table.getSortColumn() == JZip.this.tableColumnSize) {
                    if (JZip.this.table.getSortDirection() == 128) {
                        JZip.this.table.setSortColumn(null);
                    } else {
                        JZip.this.sortTable(JZip.this.tableColumnSize, true);
                        JZip.this.table.setSortColumn(JZip.this.tableColumnSize);
                        JZip.this.table.setSortDirection(128);
                        JZip.this.setAlignmentMenu(JZip.this.radioSize, true);
                    }
                } else {
                    JZip.this.sortTable(JZip.this.tableColumnSize, false);
                    JZip.this.table.setSortColumn(JZip.this.tableColumnSize);
                    JZip.this.table.setSortDirection(1024);
                    JZip.this.setAlignmentMenu(JZip.this.radioSize, false);
                }
            }
        });
        this.tableColumnType = new TableColumn(this.table, 131072);
        this.tableColumnType.setText("\ud615\uc2dd");
        this.tableColumnType.setWidth(80);
        this.tableColumnType.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (JZip.this.table.getSortColumn() == JZip.this.tableColumnType) {
                    if (JZip.this.table.getSortDirection() == 128) {
                        JZip.this.table.setSortColumn(null);
                    } else {
                        JZip.this.sortTable(JZip.this.tableColumnType, true);
                        JZip.this.table.setSortColumn(JZip.this.tableColumnType);
                        JZip.this.table.setSortDirection(128);
                        JZip.this.setAlignmentMenu(JZip.this.radioType, true);
                    }
                } else {
                    JZip.this.sortTable(JZip.this.tableColumnType, false);
                    JZip.this.table.setSortColumn(JZip.this.tableColumnType);
                    JZip.this.table.setSortDirection(1024);
                    JZip.this.setAlignmentMenu(JZip.this.radioSize, false);
                }
            }
        });
        this.tableColumnTime = new TableColumn(this.table, 16384);
        this.tableColumnTime.setText("\ubc14\ub010 \uc2dc\uac04");
        this.tableColumnTime.setWidth(270);
        this.tableColumnTime.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (JZip.this.table.getSortColumn() == JZip.this.tableColumnTime) {
                    if (JZip.this.table.getSortDirection() == 128) {
                        JZip.this.table.setSortColumn(null);
                    } else {
                        JZip.this.sortTable(JZip.this.tableColumnTime, true);
                        JZip.this.table.setSortColumn(JZip.this.tableColumnTime);
                        JZip.this.table.setSortDirection(128);
                        JZip.this.setAlignmentMenu(JZip.this.radioTime, true);
                    }
                } else {
                    JZip.this.sortTable(JZip.this.tableColumnTime, false);
                    JZip.this.table.setSortColumn(JZip.this.tableColumnTime);
                    JZip.this.table.setSortDirection(1024);
                    JZip.this.setAlignmentMenu(JZip.this.radioTime, false);
                }
            }
        });
        this.tableColumnPath = new TableColumn(this.table, 16384);
        this.tableColumnPath.setWidth(150);
        this.tableColumnPath.setText("\uc704\uce58");
        this.tableColumnPath.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (JZip.this.table.getSortColumn() == JZip.this.tableColumnPath) {
                    if (JZip.this.table.getSortDirection() == 128) {
                        JZip.this.table.setSortColumn(null);
                    } else {
                        JZip.this.sortTable(JZip.this.tableColumnPath, true);
                        JZip.this.table.setSortColumn(JZip.this.tableColumnPath);
                        JZip.this.table.setSortDirection(128);
                        JZip.this.setAlignmentMenu(JZip.this.radioPath, true);
                    }
                } else {
                    JZip.this.sortTable(JZip.this.tableColumnPath, false);
                    JZip.this.table.setSortColumn(JZip.this.tableColumnPath);
                    JZip.this.table.setSortDirection(1024);
                    JZip.this.setAlignmentMenu(JZip.this.radioPath, false);
                }
            }
        });
    }

    private File createTempZipFile(int selectionIndex, String newName) {
        if (!this.tempDirectory.exists()) {
            this.tempDirectory.mkdirs();
        }
        File tempFile = new File(this.tempDirectory, this.zip.getZipFileName());
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        zos.setEncoding(this.zip.getEncoding());
        int i = 0;
        while (i < this.zip.getZipSize()) {
            ZipEntry originalEntry = this.zip.getZipEntry(i);
            ZipEntry entry = null;
            entry = i == selectionIndex ? this.newZipEntry(originalEntry, newName) : this.newZipEntry(originalEntry);
            this.saveEntry(zos, entry, this.zip.getInputStream(originalEntry));
            ++i;
        }
        try {
            zos.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempFile;
    }

    private File createTempZipFile(int[] index) {
        if (!this.tempDirectory.exists()) {
            this.tempDirectory.mkdirs();
        }
        File tempFile = new File(this.tempDirectory, this.zip.getZipFileName());
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        zos.setEncoding(this.zip.getEncoding());
        int i = 0;
        while (i < this.zip.getZipSize()) {
            boolean delete = false;
            int[] nArray = index;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int j = nArray[n];
                if (i == j) {
                    delete = true;
                    break;
                }
                ++n;
            }
            if (!delete) {
                ZipEntry originalEntry = this.zip.getZipEntry(i);
                ZipEntry entry = this.newZipEntry(originalEntry);
                this.saveEntry(zos, entry, this.zip.getInputStream(originalEntry));
            }
            ++i;
        }
        try {
            zos.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempFile;
    }

    private void delete() {
        if (this.table.getSelectionCount() == 0) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.sShell, 196);
        messageBox.setText("\uc815\ub9d0\ub85c \uc0ad\uc81c\ud560\uae4c\uc694?");
        String message = "\uc120\ud0dd\ub41c \ud56d\ubaa9\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4.\n\ud55c \ubc88 \uc0ad\uc81c\ub418\uba74 \ub2e4\uc2dc \ub418\ub3cc\ub9b4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n\n\uacc4\uc18d \ud560\uae4c\uc694?";
        messageBox.setMessage(message);
        if (messageBox.open() != 64) {
            return;
        }
        if (!this.zip.canWrite()) {
            String string = "\uc9c0\uc6b0\uae30 \uc2e4\ud328!";
            message = String.valueOf(this.zip.getName()) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            this.dialog("\uc9c0\uc6b0\uae30 \uc2e4\ud328!", message, 1);
            return;
        }
        this.statusLine.setText("\uc120\ud0dd\ub41c \ud56d\ubaa9\uc744 \uc0ad\uc81c\ud558\ub294 \uc911\uc785\ub2c8\ub2e4.");
        this.statusLine.update();
        int[] indices = this.table.getSelectionIndices();
        File tempFile = this.createTempZipFile(indices);
        if (tempFile == null) {
            return;
        }
        this.copyFile(tempFile, this.zip.getFile());
        this.refresh();
    }

    private void deleteAllFiles(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File element = fileArray[n];
                this.deleteAllFiles(element);
                ++n;
            }
        }
        file.delete();
    }

    private void deselectAll() {
        this.table.deselectAll();
        this.pushSelectAll.setEnabled(true);
        this.pushDeselectAll.setEnabled(false);
        this.pushRename.setEnabled(false);
        this.pushDelete.setEnabled(false);
        this.setStatusLine();
    }

    private void dialog(String text, String message, int icon) {
        MessageBox messageBox = new MessageBox(this.sShell, 0x20 | icon);
        messageBox.setText(text);
        messageBox.setMessage(message);
        messageBox.open();
    }

    private void disableMenus() {
        this.pushExtract.setEnabled(false);
        this.pushClose.setEnabled(false);
        this.pushRefresh.setEnabled(false);
        this.pushSelectAll.setEnabled(false);
        this.pushDeselectAll.setEnabled(false);
        this.pushProperty.setEnabled(false);
        this.pushSaveAs.setEnabled(false);
        this.pushAddFile.setEnabled(false);
        this.pushRename.setEnabled(false);
        this.pushDelete.setEnabled(false);
        this.submenuItemAlignment.setEnabled(false);
    }

    private void enablemenus() {
        this.pushExtract.setEnabled(true);
        this.pushClose.setEnabled(true);
        this.pushRefresh.setEnabled(true);
        this.pushSelectAll.setEnabled(true);
        this.pushProperty.setEnabled(true);
        this.pushSaveAs.setEnabled(true);
        this.pushAddFile.setEnabled(true);
        this.submenuItemAlignment.setEnabled(true);
    }

    private void extract() {
        if (this.zip == null) {
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.sShell);
        dialog.setText("\uc555\ucd95\uc744 \ud480 \ub514\ub809\ud1a0\ub9ac\ub97c \uc120\ud0dd\ud558\uc138\uc694.");
        dialog.setMessage("\uc555\ucd95\uc744 \ud480 \ub514\ub809\ud1a0\ub9ac\ub97c \uc120\ud0dd\ud558\uc138\uc694.");
        dialog.setFilterPath(this.defaultPath);
        String directory = dialog.open();
        if (directory != null) {
            this.statusLine.setText("\uc555\ucd95 \ud574\uc81c \uc911\uc785\ub2c8\ub2e4.");
            this.statusLine.update();
            if (this.extractArchive(directory)) {
                String text = "\uc555\ucd95 \ud574\uc81c \uc644\ub8cc!";
                String message = "\uc555\ucd95 \ud574\uc81c\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                this.dialog(text, message, 2);
            }
            this.setStatusLine();
        }
    }

    private boolean extractArchive(String directory) {
        File directoryFile = new File(directory);
        String text = "\uc555\ucd95 \ud574\uc81c \uc2e4\ud328!";
        String message = null;
        if (!directoryFile.exists() && !directoryFile.mkdirs()) {
            message = String.valueOf(directory) + " \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return false;
        }
        if (!directoryFile.canWrite()) {
            message = String.valueOf(directory) + " \ub514\ub809\ud1a0\ub9ac\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return false;
        }
        int overwrite = 1;
        if (this.table.getSelectionCount() >= 1) {
            int[] selectionIndices;
            int[] nArray = selectionIndices = this.table.getSelectionIndices();
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int element = nArray[n];
                overwrite = this.extractEntry(this.zip.getZipEntry(element), directory, overwrite);
                if (overwrite == 4) {
                    return false;
                }
                ++n;
            }
        } else {
            int i = 0;
            while (i < this.zip.getZipSize()) {
                overwrite = this.extractEntry(this.zip.getZipEntry(i), directory, overwrite);
                if (overwrite == 4) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private int extractEntry(ZipEntry entry, String directory, int overwrite) {
        String entryName = entry.getName();
        File entryFile = new File(directory, entryName);
        String string = "\uc555\ucd95 \ud574\uc81c \uc2e4\ud328";
        String message = null;
        if (entryFile.isDirectory()) {
            if (entryFile.mkdirs()) {
                return overwrite;
            }
            message = String.valueOf(entryFile.getAbsolutePath()) + " \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
            this.dialog("\uc555\ucd95 \ud574\uc81c \uc2e4\ud328", message, 1);
            return overwrite;
        }
        File parentDir = entryFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            message = String.valueOf(parentDir.getAbsolutePath()) + " \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
            this.dialog("\uc555\ucd95 \ud574\uc81c \uc2e4\ud328", message, 1);
            return overwrite;
        }
        return this.extractEntryFile(entry, overwrite, entryFile);
    }

    private int extractEntryFile(ZipEntry entry, int overwrite, File entryFile) {
        if (entryFile.exists()) {
            if (overwrite == 3) {
                return overwrite;
            }
            if (overwrite == 2) {
                if (!entryFile.canWrite()) {
                    String string = "\uc555\ucd95 \ud574\uc81c \uc2e4\ud328!";
                    String message = String.valueOf(entryFile.getAbsolutePath()) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                    this.dialog("\uc555\ucd95 \ud574\uc81c \uc2e4\ud328!", message, 1);
                    return overwrite;
                }
            } else {
                OverwriteDialog overwriteDialog = new OverwriteDialog();
                overwrite = overwriteDialog.open(this.sShell, entryFile.getAbsolutePath());
                if (overwrite == 4) {
                    String string = "\uc555\ucd95 \ud574\uc81c\uac00 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                    this.dialog("\uc555\ucd95 \ud574\uc81c \ucde8\uc18c!", "\uc555\ucd95 \ud574\uc81c\uac00 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 2);
                    return overwrite;
                }
                if (overwrite == 0 || overwrite == 2) {
                    if (!entryFile.canWrite()) {
                        String string = "\uc555\ucd95 \ud574\uc81c \uc2e4\ud328!";
                        String message = String.valueOf(entryFile.getAbsolutePath()) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                        this.dialog("\uc555\ucd95 \ud574\uc81c \uc2e4\ud328!", message, 1);
                        return overwrite;
                    }
                } else {
                    return overwrite;
                }
            }
        }
        this.saveContents(entry, entryFile);
        return overwrite;
    }

    private String extractTempEntry(ZipEntry entry) {
        File entryFile;
        String entryName = entry.getName();
        if (!this.tempDirectory.exists()) {
            this.tempDirectory.mkdirs();
        }
        if ((entryFile = new File(this.tempDirectory, entryName)).isDirectory()) {
            entryFile.mkdirs();
        } else {
            File parentDir = entryFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            this.saveContents(entry, entryFile);
        }
        return entryFile.getAbsolutePath();
    }

    private void hideStatusLine() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.table.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(0);
        formData.bottom = new FormAttachment(0);
        this.statusSeparator.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(0);
        formData.bottom = new FormAttachment(0);
        this.statusLine.setLayoutData(formData);
        this.sShell.layout();
    }

    private ZipEntry newZipEntry(File file) {
        ZipEntry entry = new ZipEntry(file.getName());
        entry.setTime(file.lastModified());
        return entry;
    }

    private ZipEntry newZipEntry(ZipEntry originalEntry) {
        ZipEntry entry = new ZipEntry(originalEntry.getName());
        entry.setTime(originalEntry.getTime());
        return entry;
    }

    private ZipEntry newZipEntry(ZipEntry originalEntry, String newName) {
        ZipEntry entry = new ZipEntry(Zip.getNewName(originalEntry, newName));
        entry.setTime(originalEntry.getTime());
        return entry;
    }

    private void open() {
        FileDialog dialog = new FileDialog(this.sShell, 4096);
        dialog.setText("\ubd88\ub7ec\uc62c \uc555\ucd95 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        dialog.setFilterPath(this.defaultPath);
        dialog.setFilterExtensions(new String[]{"*.zip", "*.jar", "*.*"});
        dialog.setFilterNames(new String[]{"Zip \ud30c\uc77c (*.zip)", "Jar \ud30c\uc77c (*.jar)", "\ubaa8\ub4e0 \ud30c\uc77c (*.*)"});
        String file = dialog.open();
        if (file != null) {
            this.openArchive(file);
        }
    }

    private void openArchive(String fileName) {
        File file = new File(fileName);
        String text = "\uc555\ucd95  \ud30c\uc77c \uc5f4\uae30 \uc2e4\ud328!";
        String message = null;
        if (!file.exists()) {
            message = String.valueOf(fileName) + " \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return;
        }
        if (!file.canRead()) {
            message = String.valueOf(fileName) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc77d\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return;
        }
        String encoding = null;
        encoding = this.radioMs949.getSelection() ? "MS949" : "UTF8";
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file, encoding);
        }
        catch (IOException e1) {
            message = String.valueOf(fileName) + " \ud30c\uc77c\uc744 \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\nZip \ud30c\uc77c\uc774 \uc544\ub2cc \uac83 \uac19\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return;
        }
        this.zip = new Zip(file, zipFile);
        this.table.removeAll();
        this.table.setItemCount(this.zip.getZipSize());
        this.sortTable(this.tableColumnName, false);
        this.table.setVisible(true);
        this.enablemenus();
        this.setAlignmentMenu(this.radioName, false);
        this.setStatusLine();
        this.sShell.setText(String.valueOf(this.zip.getZipFileName()) + " - " + "JZip 0.3");
    }

    private void refresh() {
        if (this.zip != null) {
            this.openArchive(this.zip.getName());
        }
    }

    private void rename() {
        if (this.table.getSelectionCount() != 1) {
            return;
        }
        if (!this.zip.canWrite()) {
            String text = "\uc774\ub984 \ubc14\uafb8\uae30 \uc2e4\ud328!";
            String message = String.valueOf(this.zip.getName()) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return;
        }
        int index = this.table.getSelectionIndex();
        String originalName = this.zip.getZipEntryName(index);
        RenameDialog renameDialog = new RenameDialog(originalName);
        String newName = renameDialog.open(this.sShell);
        if (newName == null || newName.equals(originalName)) {
            return;
        }
        this.statusLine.setText("\uc120\ud0dd\ub41c \ud56d\ubaa9\uc758 \uc774\ub984\uc744 \ubc14\uafb8\ub294 \uc911\uc785\ub2c8\ub2e4.");
        this.statusLine.update();
        File tempFile = this.createTempZipFile(index, newName);
        if (tempFile == null) {
            return;
        }
        this.copyFile(tempFile, this.zip.getFile());
        this.refresh();
    }

    private boolean saveArchive(String fileName) {
        File file = new File(fileName);
        File parent = file.getParentFile();
        String text = "\uc555\ucd95 \ud30c\uc77c \uc800\uc7a5 \uc2e4\ud328!";
        String message = null;
        if (parent.exists()) {
            if (!parent.canWrite()) {
                message = String.valueOf(parent.getAbsolutePath()) + " \ub514\ub809\ud1a0\ub9ac\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                this.dialog(text, message, 1);
                return false;
            }
        } else if (!parent.mkdirs()) {
            message = String.valueOf(parent.getAbsolutePath()) + " \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
            this.dialog(text, message, 1);
            return false;
        }
        if (file.exists()) {
            MessageBox messageBox = new MessageBox(this.sShell, 196);
            messageBox.setText("\ud30c\uc77c\uc744 \ub36e\uc5b4\uc4f8\uae4c\uc694?");
            messageBox.setMessage(String.valueOf(fileName) + " \ud30c\uc77c\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4.\n\n\uc774 \ud30c\uc77c\uc744 \ub36e\uc5b4\uc4f8\uae4c\uc694?");
            if (messageBox.open() == 64) {
                if (!file.canWrite()) {
                    message = String.valueOf(fileName) + " \ud30c\uc77c\uc5d0 \ub300\ud55c \uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                    this.dialog(text, message, 1);
                    return false;
                }
            } else {
                message = "\uc555\ucd95 \ud30c\uc77c \uc800\uc7a5\uc774 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                this.dialog("\uc555\ucd95 \ud30c\uc77c \uc800\uc7a5 \ucde8\uc18c!", message, 2);
                return false;
            }
        }
        this.saveArchiveFile(file);
        return true;
    }

    private void saveArchiveFile(File file) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        zos.setEncoding("MS949");
        if (this.zip != null) {
            if (this.table.getSelectionCount() >= 1) {
                int[] selectionIndices;
                int[] nArray = selectionIndices = this.table.getSelectionIndices();
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int index = nArray[n];
                    ZipEntry originalEntry = this.zip.getZipEntry(index);
                    ZipEntry entry = this.newZipEntry(originalEntry);
                    this.saveEntry(zos, entry, this.zip.getInputStream(originalEntry));
                    ++n;
                }
            } else {
                int i = 0;
                while (i < this.zip.getZipSize()) {
                    ZipEntry originalEntry = this.zip.getZipEntry(i);
                    ZipEntry entry = this.newZipEntry(originalEntry);
                    this.saveEntry(zos, entry, this.zip.getInputStream(originalEntry));
                    ++i;
                }
            }
        }
        try {
            zos.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveAs() {
        if (this.zip == null) {
            return;
        }
        FileDialog dialog = new FileDialog(this.sShell, 8192);
        dialog.setText("\uc800\uc7a5\ud560 \uc555\ucd95 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        dialog.setFilterPath(this.defaultPath);
        dialog.setFilterExtensions(new String[]{"*.zip", "*.jar", "*.*"});
        dialog.setFilterNames(new String[]{"Zip \ud30c\uc77c (*.zip)", "Jar \ud30c\uc77c (*.jar)", "\ubaa8\ub4e0 \ud30c\uc77c (*.*)"});
        String file = dialog.open();
        if (file != null) {
            this.statusLine.setText("\uc555\ucd95\ud558\ub294 \uc911\uc785\ub2c8\ub2e4.");
            this.statusLine.update();
            if (this.saveArchive(file)) {
                String message = String.valueOf(file) + " \ud30c\uc77c \uc0dd\uc131\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                this.dialog("\uc555\ucd95 \uc644\ub8cc!", message, 2);
            }
            this.setStatusLine();
        }
    }

    private void saveContents(ZipEntry entry, File entryFile) {
        try {
            InputStream is = this.zip.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(entryFile);
            byte[] buffer = new byte[8192];
            int read = 0;
            read = is.read(buffer);
            while (read != -1) {
                fos.write(buffer, 0, read);
                read = is.read(buffer);
            }
            is.close();
            fos.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void saveEntry(ZipOutputStream zos, ZipEntry entry, InputStream is) {
        try {
            zos.putNextEntry(entry);
            byte[] buffer = new byte[8192];
            int read = 0;
            read = is.read(buffer);
            while (read != -1) {
                zos.write(buffer, 0, read);
                read = is.read(buffer);
            }
            is.close();
            zos.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void selectAll() {
        this.table.selectAll();
        this.pushSelectAll.setEnabled(false);
        this.pushDeselectAll.setEnabled(true);
        this.pushRename.setEnabled(false);
        this.pushDelete.setEnabled(true);
        this.setStatusLine();
    }

    private void setAlignmentMenu(MenuItem menu, boolean reverse) {
        menu.setSelection(true);
        if (menu != this.radioName) {
            this.radioName.setSelection(false);
        }
        if (menu != this.radioSize) {
            this.radioSize.setSelection(false);
        }
        if (menu != this.radioType) {
            this.radioType.setSelection(false);
        }
        if (menu != this.radioTime) {
            this.radioTime.setSelection(false);
        }
        if (menu != this.radioPath) {
            this.radioPath.setSelection(false);
        }
        this.checkReverse.setSelection(reverse);
    }

    private void setContextMenu() {
        this.contextMenu = new Menu(this.sShell, 8);
        this.contextMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuHidden(MenuEvent e) {
                JZip.this.setStatusLine();
            }

            @Override
            public void menuShown(MenuEvent e) {
            }
        });
        MenuItem itemExtract = new MenuItem(this.contextMenu, 8);
        itemExtract.setText("\uc555\ucd95 \ud480\uae30(&E)...");
        itemExtract.addArmListener(new ExtractArmListener());
        itemExtract.addSelectionListener(new ExtractSelectionListener());
        MenuItem itemSeparator = new MenuItem(this.contextMenu, 2);
        this.itemRename = new MenuItem(this.contextMenu, 8);
        this.itemRename.setText("\uc774\ub984 \ubc14\uafb8\uae30(&R)...");
        this.itemRename.addArmListener(new RenameArmListener());
        this.itemRename.addSelectionListener(new RenameSelectionListener());
        MenuItem itemDelete = new MenuItem(this.contextMenu, 8);
        itemDelete.setText("\uc9c0\uc6b0\uae30(&R)...");
        itemDelete.addArmListener(new DeleteArmListener());
        itemDelete.addSelectionListener(new DeleteSelectionListener());
    }

    private void setDnD() {
        int operations = 7;
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        this.target = new DropTarget(this.sShell, operations);
        this.target.setTransfer(types);
        DropListener dropListener = new DropListener();
        this.target.addDropListener(dropListener);
        operations = 3;
        this.source = new DragSource(this.table, operations);
        this.source.setTransfer(types);
        this.source.addDragListener(new DragListener(dropListener));
    }

    private void setStatusLine() {
        String text = null;
        if (this.zip != null) {
            text = "\uc804\uccb4 " + this.zip.getZipSize() + " \ud56d\ubaa9 (" + Zip.getSizeString(this.zip.getZipFileSize()) + ")";
            if (this.table.getSelectionCount() >= 1) {
                int[] selectionIndices;
                long size = 0L;
                int[] nArray = selectionIndices = this.table.getSelectionIndices();
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int element = nArray[n];
                    size += this.zip.getZipEntrySize(element);
                    ++n;
                }
                text = String.valueOf(text) + ", " + selectionIndices.length + " \ud56d\ubaa9 \uc120\ud0dd\ub428 (" + Zip.getSizeString(size) + ")";
            }
        } else {
            text = "";
        }
        this.statusLine.setText(text);
    }

    private void showProperty() {
        if (this.zip == null) {
            return;
        }
        double ratio = (double)this.zip.getZipFileSize() / (double)this.zip.getFileSize();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        StringBuffer message = new StringBuffer(70);
        message.append("\ud30c\uc77c \uc774\ub984\t:  " + this.zip.getZipFileName() + "\n");
        message.append("\ud30c\uc77c \uacbd\ub85c\t:  " + this.zip.getZipFilePath() + "\n");
        message.append("\ubc14\ub010 \uc2dc\uac04\t:  " + Zip.getTimeString(this.zip.getLastModified()) + "\n");
        message.append("\uc555\ucd95 \ud06c\uae30\t:  " + Zip.getSizeString(this.zip.getFileSize()) + "\n");
        message.append("\uc2e4\uc81c \ud06c\uae30\t:  " + Zip.getSizeString(this.zip.getZipFileSize()) + "\n");
        message.append("\uc555\ucd95 \uc815\ub3c4\t:  " + nf.format(ratio) + "\n");
        message.append("\ud56d\ubaa9 \uac1c\uc218\t:  " + this.zip.getZipSize());
        String text = String.valueOf(this.zip.getZipFileName()) + " \uc18d\uc131";
        this.dialog(text, message.toString(), 2);
    }

    private void showStatusLine() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.statusLine.setLayoutData(formData);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(this.statusLine);
        this.statusSeparator.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(this.statusSeparator);
        this.table.setLayoutData(formData);
        this.sShell.layout();
    }

    private void sortByName() {
        if (this.table.getSortColumn() == this.tableColumnName) {
            return;
        }
        boolean reverse = this.checkReverse.getSelection();
        this.sortTable(this.tableColumnName, reverse);
        this.table.setSortColumn(this.tableColumnName);
        if (reverse) {
            this.table.setSortDirection(128);
        } else {
            this.table.setSortDirection(1024);
        }
    }

    private void sortByPath() {
        if (this.table.getSortColumn() == this.tableColumnPath) {
            return;
        }
        boolean reverse = this.checkReverse.getSelection();
        this.sortTable(this.tableColumnPath, reverse);
        this.table.setSortColumn(this.tableColumnPath);
        if (reverse) {
            this.table.setSortDirection(128);
        } else {
            this.table.setSortDirection(1024);
        }
    }

    private void sortBySize() {
        if (this.table.getSortColumn() == this.tableColumnSize) {
            return;
        }
        boolean reverse = this.checkReverse.getSelection();
        this.sortTable(this.tableColumnSize, reverse);
        this.table.setSortColumn(this.tableColumnSize);
        if (reverse) {
            this.table.setSortDirection(128);
        } else {
            this.table.setSortDirection(1024);
        }
    }

    private void sortByTime() {
        if (this.table.getSortColumn() == this.tableColumnTime) {
            return;
        }
        boolean reverse = this.checkReverse.getSelection();
        this.sortTable(this.tableColumnTime, reverse);
        this.table.setSortColumn(this.tableColumnTime);
        if (reverse) {
            this.table.setSortDirection(128);
        } else {
            this.table.setSortDirection(1024);
        }
    }

    private void sortByType() {
        if (this.table.getSortColumn() == this.tableColumnType) {
            return;
        }
        boolean reverse = this.checkReverse.getSelection();
        this.sortTable(this.tableColumnType, reverse);
        this.table.setSortColumn(this.tableColumnType);
        if (reverse) {
            this.table.setSortDirection(128);
        } else {
            this.table.setSortDirection(1024);
        }
    }

    private void sortReverse() {
        boolean reverse = this.checkReverse.getSelection();
        this.sortTable(this.table.getSortColumn(), reverse);
        if (reverse) {
            this.table.setSortDirection(128);
        } else {
            this.table.setSortDirection(1024);
        }
    }

    private void sortTable(TableColumn col, boolean reverse) {
        if (col == null) {
            return;
        }
        this.zip.sort(col.getText(), reverse);
        this.table.clearAll();
    }

    private void toggleStatusLine() {
        if (this.checkStatusLine.getSelection()) {
            this.showStatusLine();
        } else {
            this.hideStatusLine();
        }
    }

    private class DeleteArmListener
    implements ArmListener {
        private DeleteArmListener() {
        }

        @Override
        public void widgetArmed(ArmEvent e) {
            JZip.this.statusLine.setText("\uc120\ud0dd\ub41c \ud56d\ubaa9\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4.");
        }
    }

    private class DeleteSelectionListener
    implements SelectionListener {
        private DeleteSelectionListener() {
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            JZip.this.delete();
        }
    }

    private class DragListener
    implements DragSourceListener {
        private DropListener listener;

        private DragListener(DropListener listener) {
            this.listener = listener;
        }

        @Override
        public void dragFinished(DragSourceEvent event) {
            JZip.this.target.addDropListener(this.listener);
        }

        @Override
        public void dragSetData(DragSourceEvent event) {
            String[] files = null;
            int selectionCount = JZip.this.table.getSelectionCount();
            if (selectionCount >= 1) {
                files = new String[selectionCount];
                int[] selectionIndices = JZip.this.table.getSelectionIndices();
                int i = 0;
                while (i < selectionIndices.length) {
                    files[i] = JZip.this.extractTempEntry(JZip.this.zip.getZipEntry(selectionIndices[i]));
                    if (files[i] == null) {
                        event.doit = false;
                        event.data = null;
                        event.detail = 0;
                        return;
                    }
                    ++i;
                }
            } else {
                event.doit = false;
                event.data = null;
                event.detail = 0;
                return;
            }
            event.data = files;
        }

        @Override
        public void dragStart(DragSourceEvent event) {
            JZip.this.target.removeDropListener(this.listener);
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DropListener() {
        }

        @Override
        public void dragEnter(DropTargetEvent event) {
        }

        @Override
        public void dragLeave(DropTargetEvent event) {
        }

        @Override
        public void dragOperationChanged(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetEvent event) {
        }

        @Override
        public void drop(DropTargetEvent event) {
            if (event.data == null) {
                event.detail = 0;
                return;
            }
            String[] files = (String[])event.data;
            if (files.length != 1 || files[0] == null) {
                event.detail = 0;
                return;
            }
            JZip.this.openArchive(files[0]);
            JZip.this.sShell.forceActive();
        }

        @Override
        public void dropAccept(DropTargetEvent event) {
        }
    }

    private class ExtractArmListener
    implements ArmListener {
        private ExtractArmListener() {
        }

        @Override
        public void widgetArmed(ArmEvent e) {
            JZip.this.statusLine.setText("\uc120\ud0dd\ub41c \ud56d\ubaa9\uc744 \uc555\ucd95 \ud574\uc81c\ud569\ub2c8\ub2e4.");
        }
    }

    private class ExtractSelectionListener
    implements SelectionListener {
        private ExtractSelectionListener() {
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            JZip.this.extract();
        }
    }

    private class RenameArmListener
    implements ArmListener {
        private RenameArmListener() {
        }

        @Override
        public void widgetArmed(ArmEvent e) {
            JZip.this.statusLine.setText("\uc120\ud0dd\ub41c \ud56d\ubaa9\uc758 \uc774\ub984\uc744 \ubcc0\uacbd\ud569\ub2c8\ub2e4.");
        }
    }

    private class RenameSelectionListener
    implements SelectionListener {
        private RenameSelectionListener() {
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            JZip.this.rename();
        }
    }
}

