/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;

public final class Font
extends Resource {
    public int handle;

    Font() {
    }

    public Font(Device device, FontData fontData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, fontData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fontDataArray) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        int n = 0;
        while (n < fontDataArray.length) {
            if (fontDataArray[n] == null) {
                SWT.error(5);
            }
            ++n;
        }
        this.init(device, fontDataArray[0]);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String string, int n, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.init(device, new FontData(string, n, n2));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Font(Device device, String string, float f, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.init(device, new FontData(string, f, n));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.DeleteObject(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        OS.GetObject(this.handle, LOGFONT.sizeof, lOGFONT);
        return new FontData[]{FontData.win32_new(lOGFONT, this.device.computePoints(lOGFONT, this.handle))};
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, FontData fontData) {
        if (fontData == null) {
            SWT.error(4);
        }
        this.device = device;
        LOGFONT lOGFONT = fontData.data;
        int n = lOGFONT.lfHeight;
        lOGFONT.lfHeight = device.computePixels(fontData.height);
        this.handle = OS.CreateFontIndirect(lOGFONT);
        lOGFONT.lfHeight = n;
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    public static Font win32_new(Device device, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.handle = n;
        font.device = device;
        return font;
    }
}

