/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 200;
    static final int EXPAND_HYSTERESIS = 1000;
    int dropIndex;
    int scrollIndex;
    long scrollBeginTime;
    int expandIndex;
    long expandBeginTime;
    TreeItem insertItem;
    boolean insertBefore;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.dropIndex = -1;
        this.insertItem = null;
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Tree tree = (Tree)this.control;
        int n = tree.handle;
        if (this.dropIndex != -1) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = this.dropIndex;
            tVITEM.mask = 8;
            tVITEM.stateMask = 8;
            tVITEM.state = 0;
            OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
            this.dropIndex = -1;
        }
        if (this.insertItem != null) {
            tree.setInsertMark(null, false);
            this.insertItem = null;
        }
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        int n;
        Tree tree = (Tree)this.getControl();
        int n2 = this.checkEffect(dropTargetEvent.feedback);
        int n3 = tree.handle;
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = tree.toControl(point);
        TVHITTESTINFO tVHITTESTINFO = new TVHITTESTINFO();
        tVHITTESTINFO.x = point.x;
        tVHITTESTINFO.y = point.y;
        OS.SendMessage(n3, 4369, 0, tVHITTESTINFO);
        int n4 = tVHITTESTINFO.hItem;
        if ((n2 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (n4 != -1 && this.scrollIndex == n4 && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                n = OS.SendMessage(n3, 4362, 5, 0);
                int n5 = OS.SendMessage(n3, 4362, n4 == n ? 7 : 6, n4);
                boolean bl = true;
                if (n4 == n) {
                    bl = n5 != 0;
                } else {
                    RECT rECT = new RECT();
                    rECT.left = n5;
                    if (OS.SendMessage(n3, 4356, 1, rECT) != 0) {
                        RECT rECT2 = new RECT();
                        OS.GetClientRect(n3, rECT2);
                        POINT pOINT = new POINT();
                        pOINT.x = rECT.left;
                        pOINT.y = rECT.top;
                        if (OS.PtInRect(rECT2, pOINT)) {
                            pOINT.y = rECT.bottom;
                            if (OS.PtInRect(rECT2, pOINT)) {
                                bl = false;
                            }
                        }
                    }
                }
                if (bl) {
                    OS.SendMessage(n3, 4372, 0, n5);
                    tree.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = n4;
        }
        if ((n2 & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (n4 != -1 && this.expandIndex == n4 && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (OS.SendMessage(n3, 4362, 4, n4) != 0) {
                    TVITEM tVITEM = new TVITEM();
                    tVITEM.hItem = n4;
                    tVITEM.mask = 24;
                    OS.SendMessage(n3, OS.TVM_GETITEM, 0, tVITEM);
                    if ((tVITEM.state & 0x20) == 0) {
                        OS.SendMessage(n3, 4354, 2, n4);
                        tree.redraw();
                    }
                }
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandIndex = n4;
        }
        if (this.dropIndex != -1 && (this.dropIndex != n4 || (n2 & 1) == 0)) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = this.dropIndex;
            tVITEM.mask = 8;
            tVITEM.stateMask = 8;
            tVITEM.state = 0;
            OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
            this.dropIndex = -1;
        }
        if (n4 != -1 && n4 != this.dropIndex && (n2 & 1) != 0) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = n4;
            tVITEM.mask = 8;
            tVITEM.stateMask = 8;
            tVITEM.state = 8;
            OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
            this.dropIndex = n4;
        }
        if ((n2 & 2) != 0 || (n2 & 4) != 0) {
            n = (n2 & 2) != 0 ? 1 : 0;
            TreeItem treeItem = (TreeItem)tree.getDisplay().findWidget(tree.handle, n4);
            if (treeItem != null) {
                if (treeItem != this.insertItem || n != this.insertBefore) {
                    tree.setInsertMark(treeItem, n != 0);
                }
                this.insertItem = treeItem;
                this.insertBefore = n;
            } else {
                if (this.insertItem != null) {
                    tree.setInsertMark(null, false);
                }
                this.insertItem = null;
            }
        } else {
            if (this.insertItem != null) {
                tree.setInsertMark(null, false);
            }
            this.insertItem = null;
        }
    }
}

