/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    boolean visible = true;
    boolean highlight;
    int handle;
    int nsImage;
    int view;
    int jniRef;
    static final float BORDER = 8.0f;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        tray.createItem(this, tray.getItemCount());
        this.createWidget();
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget() {
        int n = Cocoa.objc_msgSend(Cocoa.C_NSStatusBar, Cocoa.S_systemStatusBar);
        this.handle = Cocoa.objc_msgSend(n, Cocoa.S_statusItemWithLength, 0.0f);
        if (this.handle == 0) {
            this.error(2);
        }
        Cocoa.objc_msgSend(this.handle, Cocoa.S_retain);
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setHighlightMode, 1);
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        NSRect nSRect = new NSRect();
        this.view = Cocoa.objc_msgSend(Cocoa.C_NSStatusItemImageView, Cocoa.S_alloc);
        if (this.view == 0) {
            this.error(2);
        }
        this.view = Cocoa.objc_msgSend(this.view, Cocoa.S_initWithProc_frame_user_data, this.display.trayItemProc, nSRect, this.jniRef);
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setView, this.view);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    Point getLocation() {
        NSPoint nSPoint = new NSPoint();
        Cocoa.objc_msgSend(this.view, Cocoa.S_getLocation, nSPoint);
        return new Point((int)nSPoint.x, (int)nSPoint.y);
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.handle = 0;
    }

    void releaseWidget() {
        int n = Cocoa.objc_msgSend(Cocoa.C_NSStatusBar, Cocoa.S_systemStatusBar);
        Cocoa.objc_msgSend(n, Cocoa.S_removeStatusItem, this.handle);
        Cocoa.objc_msgSend(this.nsImage, Cocoa.S_release, this.handle);
        if (this.nsImage != 0) {
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_release);
        }
        if (this.view != 0) {
            Cocoa.objc_msgSend(this.view, Cocoa.S_release);
        }
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
        this.view = 0;
        this.nsImage = 0;
        this.handle = 0;
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.nsImage != 0) {
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_release, this.nsImage);
        }
        this.nsImage = 0;
        if (image != null) {
            CGRect cGRect = new CGRect();
            cGRect.width = OS.CGImageGetWidth(image.handle);
            cGRect.height = OS.CGImageGetHeight(image.handle);
            NSSize nSSize = new NSSize();
            nSSize.width = cGRect.width;
            nSSize.height = cGRect.height;
            this.nsImage = Cocoa.objc_msgSend(Cocoa.C_NSImage, Cocoa.S_alloc);
            this.nsImage = Cocoa.objc_msgSend(this.nsImage, Cocoa.S_initWithSize, nSSize);
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_lockFocus);
            int n = Cocoa.objc_msgSend(Cocoa.C_NSGraphicsContext, Cocoa.S_currentContext);
            n = Cocoa.objc_msgSend(n, Cocoa.S_graphicsPort);
            OS.CGContextDrawImage(n, cGRect, image.handle);
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_unlockFocus);
        }
        Cocoa.objc_msgSend(this.view, Cocoa.S_setImage, this.nsImage);
        float f = image != null && this.visible ? (float)OS.CGImageGetWidth(image.handle) + 8.0f : 0.0f;
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setLength, f);
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this._setToolTipText(string);
    }

    void _setToolTipText(String string) {
        int n = 0;
        if (string != null) {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        }
        Cocoa.objc_msgSend(this.view, Cocoa.S_setToolTip, n);
        if (n != 0) {
            OS.CFRelease(n);
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.visible == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = bl;
        float f = this.image != null && bl ? (float)OS.CGImageGetWidth(this.image.handle) + 8.0f : 0.0f;
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setLength, f);
        if (!bl) {
            this.sendEvent(23);
        }
    }

    void showMenu() {
        this._setToolTipText(null);
        this.sendEvent(35);
        if (this.isDisposed()) {
            return;
        }
        this.display.runPopups();
        if (this.isDisposed()) {
            return;
        }
        this._setToolTipText(this.toolTipText);
    }

    int trayItemProc(int n, int n2, int n3, int n4) {
        switch (n3) {
            case 0: {
                int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_modifierFlags) & 0xFFFF0000;
                if (n5 == 262144) {
                    this.showMenu();
                    break;
                }
                this.highlight = true;
                Cocoa.objc_msgSend(this.view, Cocoa.S_setNeedsDisplay, 1);
                int n6 = Cocoa.objc_msgSend(n4, Cocoa.S_clickCount);
                this.postEvent(n6 == 2 ? 14 : 13);
                break;
            }
            case 1: {
                this.highlight = false;
                Cocoa.objc_msgSend(this.view, Cocoa.S_setNeedsDisplay, 1);
                break;
            }
            case 2: {
                this.showMenu();
                break;
            }
            case 3: {
                NSRect nSRect = new NSRect();
                Cocoa.memcpy(nSRect, n4, 16);
                Cocoa.objc_msgSend(this.handle, Cocoa.S_drawStatusBarBackgroundInRect_withHighlight, nSRect, this.highlight ? 1 : 0);
            }
        }
        return 0;
    }
}

