/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    boolean dragging;
    int lastX;
    int lastY;
    int startX;
    int startY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
        int n2 = (n & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    int callFocusEventHandler(int n, int n2) {
        return 0;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            n3 += 64;
            n4 += 5;
        } else {
            n3 += 5;
            n4 += 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        this.state |= 0x820;
        int n = 4;
        int[] nArray = new int[1];
        int n2 = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(n2, null, n, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    void drawBackground(int n, int n2) {
        this.fillBackground(n, n2, null);
    }

    int kEventControlClick(int n, int n2, int n3) {
        int n4 = super.kEventControlClick(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        return n4;
    }

    int kEventControlGetFocusPart(int n, int n2, int n3) {
        return 0;
    }

    int kEventControlSetCursor(int n, int n2, int n3) {
        int n4 = super.kEventControlSetCursor(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.display.setCursor(this.sizeCursor.handle);
        return 0;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        int n4 = super.kEventControlSetFocusPart(n, n2, n3);
        if (n4 == 0) {
            Point point = this.getLocation();
            this.lastX = point.x;
            this.lastY = point.y;
        }
        return n4;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        switch (nArray2[0]) {
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int n5 = 0;
                int n6 = 0;
                int n7 = 9;
                int[] nArray3 = new int[1];
                OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray3);
                if ((nArray3[0] & 0x1000) != 0) {
                    n7 = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (nArray2[0] == 126 || nArray2[0] == 125) break;
                    n5 = nArray2[0] == 123 ? -n7 : n7;
                } else {
                    if (nArray2[0] == 123 || nArray2[0] == 124) break;
                    n6 = nArray2[0] == 126 ? -n7 : n7;
                }
                Rectangle rectangle = this.getBounds();
                int n8 = rectangle.width;
                int n9 = rectangle.height;
                Rectangle rectangle2 = this.parent.getBounds();
                int n10 = rectangle2.width;
                int n11 = rectangle2.height;
                int n12 = this.lastX;
                int n13 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n12 = Math.min(Math.max(0, this.lastX + n5), n10 - n8);
                } else {
                    n13 = Math.min(Math.max(0, this.lastY + n6), n11 - n9);
                }
                if (n12 == this.lastX && n13 == this.lastY) {
                    return n4;
                }
                Event event = new Event();
                event.x = n12;
                event.y = n13;
                event.width = n8;
                event.height = n9;
                this.sendEvent(13, event);
                if (this.isDisposed() || !event.doit) break;
                this.setBounds(event.x, event.y, n8, n9);
                if (this.isDisposed()) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if (this.isDisposed()) {
                    return n4;
                }
                int n14 = event.x;
                int n15 = event.y;
                if ((this.style & 0x200) != 0) {
                    n15 += n9 / 2;
                } else {
                    n14 += n8 / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(n14, n15));
            }
        }
        return n4;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    boolean sendMouseEvent(int n, short s, int n2, int n3, boolean bl, int n4, short s2, short s3, int n5) {
        boolean bl2 = super.sendMouseEvent(n, s, n2, n3, bl, n4, s2, s3, n5);
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        short s4 = rect.left;
        short s5 = rect.top;
        int n6 = rect.right - rect.left;
        int n7 = rect.bottom - rect.top;
        OS.GetControlBounds(this.parent.handle, rect);
        int n8 = rect.right - rect.left;
        int n9 = rect.bottom - rect.top;
        switch (n) {
            case 3: {
                if (s != 1 || n2 != 1) break;
                this.startX = s2;
                this.startY = s3;
                Event event = new Event();
                event.x = s4;
                event.y = s5;
                event.width = n6;
                event.height = n7;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return bl2;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                this.dragging = true;
                this.setBounds(event.x, event.y, n6, n7);
                break;
            }
            case 4: {
                if (!this.dragging) break;
                this.dragging = false;
                Event event = new Event();
                event.x = this.lastX;
                event.y = this.lastY;
                event.width = n6;
                event.height = n7;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return bl2;
                }
                if (!event.doit) break;
                this.setBounds(event.x, event.y, n6, n7);
                break;
            }
            case 5: {
                if (!this.dragging) break;
                int n10 = this.lastX;
                int n11 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n10 = Math.min(Math.max(0, s2 + s4 - this.startX), n8 - n6);
                } else {
                    n11 = Math.min(Math.max(0, s3 + s5 - this.startY), n9 - n7);
                }
                if (n10 == this.lastX && n11 == this.lastY) {
                    return bl2;
                }
                Event event = new Event();
                event.x = n10;
                event.y = n11;
                event.width = n6;
                event.height = n7;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return bl2;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                this.setBounds(event.x, event.y, n6, n7);
            }
        }
        return bl2;
    }

    int traversalCode(int n, int n2) {
        return 0;
    }
}

