/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.MenuTrackingData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int handle;
    short id;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean modified;
    boolean closed;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    MenuItem lastTarget;
    Decorations parent;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget();
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean bl) {
        if ((this.style & 6) != 0) {
            return;
        }
        if (!bl) {
            return;
        }
        Point point = new Point();
        if (this.hasLocation) {
            point.h = (short)this.x;
            point.v = (short)this.y;
        } else {
            OS.GetGlobalMouse(point);
        }
        OS.ContextualMenuSelect(this.handle, point, false, 3, null, null, new int[1], new short[1], new short[1]);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        int[] nArray = new int[1];
        OS.CreateNewMenu(this.id, 0, nArray);
        if (nArray[0] == 0) {
            this.display.removeMenu(this);
            this.error(2);
        }
        this.handle = nArray[0];
    }

    void createItem(MenuItem menuItem, int n) {
        int n2;
        this.checkWidget();
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        int n3 = 2560;
        if ((menuItem.style & 2) != 0) {
            n3 = 64;
        }
        if ((n2 = OS.InsertMenuItemTextWithCFString(this.handle, 0, (short)n, n3, 0)) != 0) {
            this.error(14);
        }
        if (this.itemCount == this.items.length) {
            MenuItem[] menuItemArray = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, menuItemArray, 0, this.items.length);
            this.items = menuItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = menuItem;
        this.modified = true;
        int n4 = menuItem.createEmptyMenu();
        if (n4 != 0) {
            OS.SetMenuItemHierarchicalMenu(this.handle, (short)(n + 1), n4);
            OS.ReleaseMenu(n4);
        }
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void destroyItem(MenuItem menuItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == menuItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.modified = true;
        OS.DeleteMenuItem(this.handle, (short)(n + 1));
    }

    void destroyWidget() {
        int n = this.handle;
        this.releaseHandle();
        if (n != 0) {
            OS.DisposeMenu(n);
        }
    }

    void fixMenus(Decorations decorations) {
        this.parent = decorations;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            Menu menu = this.display.getMenuBar();
            if (this != menu) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n = OS.GetMBarHeight();
            int n2 = OS.GetMainDevice();
            int[] nArray = new int[1];
            OS.memmove(nArray, n2, 4);
            GDevice gDevice = new GDevice();
            OS.memmove(gDevice, nArray[0], 62);
            return new Rectangle(0, 0, gDevice.right - gDevice.left, n);
        }
        OS.CalcMenuSize(this.handle);
        return new Rectangle(this.x, this.y, 0, 0);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] menuItemArray = new MenuItem[this.itemCount];
        int n = 0;
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.itemCount) {
                MenuItem menuItem = this.items[n2];
                if (menuItem != null && !menuItem.isDisposed()) {
                    menuItemArray[n++] = menuItem;
                }
                ++n2;
            }
        }
        if (n != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                string = String.valueOf(string) + menuItemArray[n2].getNameText() + ", ";
                ++n2;
            }
            string = String.valueOf(string) + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Object object;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            object = this.display.popups;
            if (object == null) {
                return false;
            }
            int n = 0;
            while (n < ((Menu[])object).length) {
                if (object[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        return OS.GetMenuTrackingData(this.handle, (MenuTrackingData)(object = new MenuTrackingData())) == 0;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.menuProc;
        int[] nArray = new int[]{1835363957, 1004, 1835363957, 5, 1835363957, 1005, 1835363957, 102, 1835363957, 103, 1835363957, 100, 1835363957, 4, 1835363957, 6};
        int n2 = OS.GetMenuEventTarget(this.handle);
        OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
    }

    int kEventMenuCalculateSize(int n, int n2, int n3) {
        int n4 = super.kEventMenuCalculateSize(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1668575852, 1668575852, null, 4, null, nArray);
        int n5 = this.display.menuProc;
        int[] nArray2 = new int[]{1835363957, 1006};
        int n6 = OS.GetControlEventTarget(nArray[0]);
        OS.InstallEventHandler(n6, n5, nArray2.length / 2, nArray2, this.handle, null);
        return n4;
    }

    int kEventMenuClosed(int n, int n2, int n3) {
        int n4 = super.kEventMenuClosed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.closed = true;
        this.sendEvent(23);
        return -9874;
    }

    int kEventMenuCreateFrameView(int n, int n2, int n3) {
        int n4 = super.kEventMenuCreateFrameView(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1668575852, 1668575852, null, 4, null, nArray);
        int n5 = this.display.menuProc;
        int[] nArray2 = new int[]{1835363957, 1006};
        int n6 = OS.GetControlEventTarget(nArray[0]);
        OS.InstallEventHandler(n6, n5, nArray2.length / 2, nArray2, this.handle, null);
        return -9874;
    }

    int kEventMenuDrawItem(int n, int n2, int n3) {
        int n4 = super.kEventMenuDrawItem(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        return -9874;
    }

    int kEventMenuDrawItemContent(int n, int n2, int n3) {
        String string;
        int n4;
        int n5;
        int n6 = super.kEventMenuDrawItemContent(n, n2, n3);
        if (n6 == 0) {
            return n6;
        }
        short[] sArray = new short[1];
        OS.GetEventParameter(n2, 1769235821, 1835623544, null, 2, null, sArray);
        MenuItem menuItem = this.items[sArray[0] - 1];
        if (menuItem.accelerator == 0 && (n5 = menuItem.text.indexOf(9)) != -1 && (n4 = (string = menuItem.text.substring(n5 + 1)).length()) != 0) {
            n6 = OS.CallNextEventHandler(n, n2);
            Rect rect = new Rect();
            OS.GetEventParameter(n2, 1835627618, 1902408308, null, 8, null, rect);
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1668183160, 1668183160, null, 4, null, nArray);
            int n7 = this.modifierIndex(string);
            char[] cArray = new char[n4 - n7 - 1];
            string.getChars(n7 + 1, n4, cArray, 0);
            int n8 = 101;
            if (cArray.length > 1) {
                n8 = 103;
            }
            byte[] byArray = new byte[256];
            short[] sArray2 = new short[1];
            byte[] byArray2 = new byte[1];
            OS.GetThemeFont((short)n8, (short)-1, byArray, sArray2, byArray2);
            short s = OS.FMGetFontFamilyFromName(byArray);
            int[] nArray2 = new int[1];
            OS.FMGetFontFromFontFamilyInstance(s, byArray2[0], nArray2, null);
            int n9 = OS.FMGetATSFontRefFromFont(nArray2[0]);
            ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
            OS.ATSFontGetVerticalMetrics(n9, 0, aTSFontMetrics);
            OS.ATSFontGetHorizontalMetrics(n9, 0, aTSFontMetrics);
            int[] nArray3 = new int[1];
            OS.GetThemeMetric(69, nArray3);
            int n10 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            Point point = new Point();
            OS.GetThemeTextDimensions(n10, (short)n8, 0, false, point, null);
            rect.left = (short)(rect.right - Math.max((int)(aTSFontMetrics.maxAdvanceWidth * (float)sArray2[0]), point.h) - nArray3[0]);
            OS.DrawThemeTextBox(n10, (short)n8, 1, false, rect, (short)-2, nArray[0]);
            OS.CFRelease(n10);
            if (n7 != -1) {
                cArray = new char[n7 + 1];
                string.getChars(0, cArray.length, cArray, 0);
                n10 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                OS.GetThemeTextDimensions(n10, (short)103, 0, false, point, null);
                rect.right = rect.left;
                rect.left = (short)(rect.right - point.h);
                OS.DrawThemeTextBox(n10, (short)103, 1, false, rect, (short)-2, nArray[0]);
                OS.CFRelease(n10);
            }
            return n6;
        }
        return -9874;
    }

    int kEventMenuGetFrameBounds(int n, int n2, int n3) {
        int n4 = super.kEventMenuGetFrameBounds(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        n4 = OS.CallNextEventHandler(n, n2);
        return n4;
    }

    int kEventMenuMeasureItemWidth(int n, int n2, int n3) {
        String string;
        int n4;
        int n5 = super.kEventMenuMeasureItemWidth(n, n2, n3);
        if (n5 == 0) {
            return n5;
        }
        short[] sArray = new short[1];
        OS.GetEventParameter(n2, 1769235821, 1835623544, null, 2, null, sArray);
        MenuItem menuItem = this.items[sArray[0] - 1];
        if (menuItem.accelerator == 0 && (n4 = menuItem.text.indexOf(9)) != -1 && (string = menuItem.text.substring(n4 + 1)).length() != 0) {
            n5 = OS.CallNextEventHandler(n, n2);
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n6 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            Point point = new Point();
            OS.GetThemeTextDimensions(n6, (short)103, 0, false, point, null);
            OS.CFRelease(n6);
            short[] sArray2 = new short[1];
            OS.GetEventParameter(n2, 1835627639, 1936224114, null, 2, null, sArray2);
            int[] nArray = new int[1];
            OS.GetThemeMetric(67, nArray);
            sArray2[0] = (short)(sArray2[0] + (nArray[0] + point.h));
            OS.SetEventParameter(n2, 1835627639, 1936224114, 2, sArray2);
            return n5;
        }
        return -9874;
    }

    int kEventMenuOpening(int n, int n2, int n3) {
        int n4 = super.kEventMenuOpening(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.closed = false;
        this.sendEvent(22);
        this.modified = false;
        return -9874;
    }

    int kEventMenuTargetItem(int n, int n2, int n3) {
        int n4 = super.kEventMenuTargetItem(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.lastTarget = null;
        short[] sArray = new short[1];
        if (OS.GetEventParameter(n2, 1769235821, 1835623544, null, 2, null, sArray) == 0) {
            if (sArray[0] > 0) {
                this.lastTarget = this.items[sArray[0] - 1];
            }
            if (this.lastTarget != null) {
                this.lastTarget.sendEvent(30);
            }
        }
        return -9874;
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == menuItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int modifierIndex(String string) {
        int n;
        int n2 = n = string.length() - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            switch (c) {
                case ' ': {
                    if (n2 == n) break;
                    return n2;
                }
                case '\u21e7': 
                case '\u2303': 
                case '\u2318': 
                case '\u2325': {
                    return n2;
                }
            }
            --n2;
        }
        return -1;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                MenuItem menuItem = this.items[n];
                if (menuItem != null && !menuItem.isDisposed()) {
                    menuItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.lastTarget = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem != null && menuItem.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = menuItem;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (bl) {
            this.state &= 0xFFFFFFF7;
            OS.EnableMenuItem(this.handle, (short)0);
        } else {
            this.state |= 8;
            OS.DisableMenuItem(this.handle, (short)0);
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

