/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    String[] items;
    int itemCount;
    int anchorFirst;
    int anchorLast;
    boolean ignoreSelect;
    static final int COLUMN_ID = 1024;
    static final int EXTRA_WIDTH = 25;
    static final int BORDER_INSET = 1;

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    public void add(String string) {
        int[] nArray;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (OS.AddDataBrowserItems(this.handle, 0, 1, nArray = new int[]{this.itemCount + 1}, 0) != 0) {
            this.error(14);
        }
        if (this.itemCount == this.items.length) {
            String[] stringArray = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
            this.items = stringArray;
        }
        this.items[this.itemCount++] = string;
    }

    public void add(String string, int n) {
        int[] nArray;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (OS.AddDataBrowserItems(this.handle, 0, 1, nArray = new int[]{this.itemCount + 1}, 0) != 0) {
            this.error(14);
        }
        if (n != this.itemCount) {
            this.fixSelection(n, true);
        }
        if (this.itemCount == this.items.length) {
            String[] stringArray = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
            this.items = stringArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = string;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    public org.eclipse.swt.graphics.Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        if (n == -1) {
            GC gC = new GC(this);
            int n4 = 0;
            while (n4 < this.itemCount) {
                org.eclipse.swt.graphics.Point point = gC.stringExtent(this.items[n4]);
                n3 = Math.max(n3, point.x);
                ++n4;
            }
            gC.dispose();
            n3 += 25;
        } else {
            n3 = n;
        }
        if (n3 <= 0) {
            n3 = 64;
        }
        int n5 = 0;
        n5 = n2 == -1 ? this.itemCount * this.getItemHeight() : n2;
        if (n5 <= 0) {
            n5 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n5);
        return new org.eclipse.swt.graphics.Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.getBorder();
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(n -= rect.left + n5, n2 -= rect.top + n5, n3 += rect.left + rect.right + n5 + n5, n4 += rect.top + rect.bottom + n5 + n5);
    }

    boolean contains(int n, int n2) {
        CGPoint cGPoint = new CGPoint();
        int[] nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), nArray);
        OS.HIViewConvertPoint(cGPoint, this.handle, nArray[0]);
        int n3 = n - (int)cGPoint.x;
        int n4 = n2 - (int)cGPoint.y;
        return this.getClientArea().contains(n3, n4);
    }

    void createHandle() {
        int[] nArray = new int[1];
        int n = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(n, null, 1819505782, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int n2 = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, n2);
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        DataBrowserListViewColumnDesc dataBrowserListViewColumnDesc = new DataBrowserListViewColumnDesc();
        dataBrowserListViewColumnDesc.headerBtnDesc_version = 0;
        dataBrowserListViewColumnDesc.propertyDesc_propertyID = 1024;
        dataBrowserListViewColumnDesc.propertyDesc_propertyType = 1952807028;
        dataBrowserListViewColumnDesc.propertyDesc_propertyFlags = 65536;
        dataBrowserListViewColumnDesc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        dataBrowserListViewColumnDesc.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, dataBrowserListViewColumnDesc, 0);
        OS.HIViewSetDrawingEnabled(this.handle, false);
        int n3 = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)n3;
        OS.SetControlBounds(this.handle, rect);
        int n4 = n3 * 4;
        int[] nArray2 = new int[1];
        int n5 = OS.NewPtr(n4 * n3);
        OS.NewGWorldFromPtr(nArray2, 32, rect, 0, 0, 0, n5, n4);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.GetGWorld(nArray3, nArray4);
        OS.SetGWorld(nArray2[0], nArray4[0]);
        OS.DrawControlInCurrentPort(this.handle);
        OS.SetGWorld(nArray3[0], nArray4[0]);
        OS.DisposeGWorld(nArray2[0]);
        OS.DisposePtr(n5);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds(this.handle, rect);
        OS.HIViewSetDrawingEnabled(this.handle, true);
    }

    void createWidget() {
        super.createWidget();
        this.items = new String[4];
    }

    ScrollBar createScrollBar(int n) {
        return this.createStandardBar(n);
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            int[] nArray = new int[]{n + 1};
            this.deselect(nArray, nArray.length);
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n2 < 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        int n3 = (n2 = Math.min(this.itemCount - 1, n2)) - n + 1;
        if (n3 <= 0) {
            return;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2 - n4 + 1;
            ++n4;
        }
        this.deselect(nArray, n3);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n - n2 - 1] + 1;
            ++n2;
        }
        this.deselect(nArray2, n);
    }

    void deselect(int[] nArray, int n) {
        this.ignoreSelect = true;
        int[] nArray2 = null;
        if ((this.style & 4) != 0) {
            nArray2 = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray2);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, n, nArray, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.deselect(null, 0);
    }

    void fixSelection(int n, boolean bl) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (!bl && nArray[n3] == n) {
                bl2 = true;
            } else {
                int n4 = n2++;
                nArray[n4] = nArray[n3] + 1;
                if (nArray[n4] - 1 >= n) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + (bl ? 1 : -1);
                    bl2 = true;
                }
            }
            ++n3;
        }
        if (bl2) {
            this.select(nArray, n2, true);
        }
    }

    int getBorder() {
        int n = 0;
        byte[] byArray = new byte[1];
        OS.GetControlData(this.handle, (short)0, 1651663986, 1, byArray, null);
        if (byArray[0] != 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(7, nArray);
            n += nArray[0] - 1;
        }
        return n;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int n = this.getBorder();
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, rect2);
        int n2 = Math.max(0, rect.right - rect.left - rect2.right - n - n);
        int n3 = Math.max(0, rect.bottom - rect.top - rect2.bottom - n - n);
        return new Rectangle(rect2.left + n, rect2.top + n, n2, n3);
    }

    public int getFocusIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GetDataBrowserSelectionAnchor(this.handle, nArray, nArray2) != 0) {
            return -1;
        }
        return nArray[0] - 1;
    }

    public String getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] sArray = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, sArray) != 0) {
            this.error(11);
        }
        return sArray[0];
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.itemCount];
        System.arraycopy(this.items, 0, stringArray, 0, this.itemCount);
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int n = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, n) != 0) {
            this.error(9);
        }
        int n2 = OS.GetHandleSize(n) / 4;
        String[] stringArray = new String[n2];
        if (n2 > 0) {
            OS.HLock(n);
            int[] nArray = new int[1];
            OS.memmove(nArray, n, 4);
            int n3 = nArray[0] + (n2 - 1) * 4;
            int n4 = 0;
            while (n4 < n2) {
                OS.memmove(nArray, n3, 4);
                stringArray[n4] = this.items[nArray[0] - 1];
                ++n4;
                n3 -= 4;
            }
            OS.HUnlock(n);
        }
        OS.DisposeHandle(n);
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] nArray = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, nArray) != 0) {
            this.error(36);
        }
        return nArray[0];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GetDataBrowserSelectionAnchor(this.handle, nArray, nArray2) != 0) {
            return -1;
        }
        return nArray[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, n) != 0) {
            this.error(9);
        }
        int n2 = OS.GetHandleSize(n) / 4;
        int[] nArray = new int[n2];
        if (n2 > 0) {
            OS.HLock(n);
            OS.memmove(nArray, n, 4);
            OS.memmove(nArray, nArray[0], n2 * 4);
            OS.HUnlock(n);
            int n3 = 0;
            int n4 = n2 - 1;
            while (n3 <= n4) {
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4] - 1;
                nArray[n4] = n5 - 1;
                ++n3;
                --n4;
            }
        }
        OS.DisposeHandle(n);
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        return nArray[0] / this.getItemHeight();
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        dataBrowserCallbacks.version = 0;
        OS.InitDataBrowserCallbacks(dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemDataCallback = this.display.itemDataProc;
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
    }

    int itemDataProc(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 - 1;
        switch (n3) {
            case 1024: {
                String string = this.items[n6];
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                int n7 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (n7 == 0) {
                    this.error(13);
                }
                OS.SetDataBrowserItemDataText(n4, n7);
                OS.CFRelease(n7);
            }
        }
        return 0;
    }

    int kEventControlGetClickActivation(int n, int n2, int n3) {
        OS.SetEventParameter(n2, 1668047203, 1668047203, 4, new int[]{3});
        return 0;
    }

    int kEventControlSetCursor(int n, int n2, int n3) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        if (this.isEnabledModal()) {
            Point point = new Point();
            int n4 = 4;
            OS.GetEventParameter(n2, 1835822947, 1363439732, null, n4, null, point);
            if (!this.contains(point.h, point.v)) {
                return -9874;
            }
        }
        return super.kEventControlSetCursor(n, n2, n3);
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        switch (nArray2[0]) {
            case 36: 
            case 76: {
                this.postEvent(14);
                break;
            }
            case 125: {
                int n5 = this.getSelectionIndex();
                this.setSelection(Math.min(this.itemCount - 1, n5 + 1), true);
                return 0;
            }
            case 126: {
                int n6 = this.getSelectionIndex();
                this.setSelection(Math.max(0, n6 - 1), true);
                return 0;
            }
        }
        return n4;
    }

    int itemNotificationProc(int n, int n2, int n3) {
        switch (n3) {
            case 5: 
            case 6: {
                if (this.ignoreSelect) break;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.GetDataBrowserSelectionAnchor(this.handle, nArray, nArray2);
                boolean bl = false;
                if ((this.style & 2) != 0) {
                    int n4 = OS.GetCurrentEventKeyModifiers();
                    bl = (n4 & 0x200) != 0 ? (n3 == 5 ? nArray[0] == n2 || nArray2[0] == n2 : n2 == this.anchorFirst || n2 == this.anchorLast) : ((n4 & 0x100) != 0 ? true : nArray[0] == nArray2[0]);
                } else {
                    boolean bl2 = bl = n3 == 5;
                }
                if (!bl) break;
                this.anchorFirst = nArray[0];
                this.anchorLast = nArray2[0];
                this.postEvent(13);
                break;
            }
            case 7: {
                if (this.display.clickCount != 2) break;
                this.postEvent(14);
            }
        }
        return 0;
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = n;
        while (n2 < this.itemCount) {
            if (this.items[n2].equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return false;
        }
        return OS.IsDataBrowserItemSelected(this.handle, n + 1);
    }

    public void remove(int n) {
        int[] nArray;
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, (nArray = new int[]{this.itemCount}).length, nArray, 0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = n2 - n + 1;
        int n4 = 0;
        while (n4 < n3) {
            this.remove(n);
            ++n4;
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = this.getItemCount();
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = -1;
        int n5 = 0;
        while (n5 < nArray2.length) {
            int n6 = nArray2[n5];
            if (n6 != n4) {
                this.remove(n6);
                n4 = n6;
            }
            ++n5;
        }
    }

    public void removeAll() {
        this.checkWidget();
        OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        this.items = new String[4];
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.itemCount = 0;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            int[] nArray = new int[]{n + 1};
            this.select(nArray, nArray.length, false);
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2 - n4 + 1;
            ++n4;
        }
        this.select(nArray, n3, false);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n - n3 - 1];
            if (n4 >= 0 && n4 < this.itemCount) {
                nArray2[n2++] = n4 + 1;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray2, n2, false);
        }
    }

    void select(int[] nArray, int n, boolean bl) {
        this.ignoreSelect = true;
        int[] nArray2 = null;
        if ((this.style & 4) != 0) {
            nArray2 = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray2);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0] & 0xFFFFFFBF);
        }
        int n2 = 1;
        if ((this.style & 2) != 0 && !bl) {
            n2 = 0;
        }
        OS.SetDataBrowserSelectedItems(this.handle, n, nArray, n2);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0]);
        }
        this.ignoreSelect = false;
    }

    void select(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.indexOf(stringArray[n - n2 - 1]) + 1;
            ++n2;
        }
        this.select(nArray, n, false);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.select(null, 0, false);
    }

    void setBackground(float[] fArray) {
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = -1;
        if (bl2) {
            Rectangle rectangle = this.getClientArea();
            if (rectangle.height < this.getItemHeight()) {
                n5 = this.getTopIndex();
            }
        }
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if (n5 != -1) {
            this.showIndex(n5);
        }
        return n6;
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        int[] nArray = new int[]{n + 1};
        this.items[n] = string;
        OS.UpdateDataBrowserItems(this.handle, 0, nArray.length, nArray, 0, 0);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        if (OS.AddDataBrowserItems(this.handle, 0, stringArray.length, null, 0) != 0) {
            this.error(14);
        }
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.itemCount = stringArray.length;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        if (n >= 0 && n < this.itemCount) {
            int[] nArray = new int[]{n + 1};
            this.select(nArray, nArray.length, true);
            this.showIndex(n);
            if (bl) {
                this.postEvent(13);
            }
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2 - n4 + 1;
            ++n4;
        }
        this.select(nArray, n3, true);
        if (nArray.length > 0) {
            this.showIndex(nArray[0] - 1);
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n - n3 - 1];
            if (n4 >= 0 && n4 < this.itemCount) {
                nArray2[n2++] = n4 + 1;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray2, n2, true);
            this.showIndex(nArray2[0] - 1);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            int n4;
            String string = stringArray[n - n3 - 1];
            if ((this.style & 4) != 0) {
                n4 = this.indexOf(string, 0);
                if (n4 != -1) {
                    n2 = 1;
                    nArray = new int[]{n4 + 1};
                }
            } else {
                n4 = 0;
                while ((n4 = this.indexOf(string, n4)) != -1) {
                    if (n2 == nArray.length) {
                        int[] nArray2 = new int[nArray.length + 4];
                        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                        nArray = nArray2;
                    }
                    nArray[n2++] = n4 + 1;
                    ++n4;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray, n2, true);
            this.showIndex(nArray[0] - 1);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int n2 = this.getItemHeight();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        nArray[0] = Math.max(0, Math.min(n2 * this.itemCount - this.getClientArea().height, n * n2));
        OS.SetDataBrowserScrollPosition(this.handle, nArray[0], nArray2[0]);
    }

    void showIndex(int n) {
        if (n >= 0 && n < this.itemCount) {
            short[] sArray = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, 1024, sArray);
            Rect rect = new Rect();
            Rect rect2 = new Rect();
            OS.GetControlBounds(this.handle, rect);
            OS.GetDataBrowserScrollBarInset(this.handle, rect2);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, 1024, (short)(rect.right - rect.left - rect2.left - rect2.right));
            OS.RevealDataBrowserItem(this.handle, n + 1, 1024, (byte)3);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, 1024, sArray[0]);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n >= 0) {
            this.showIndex(n);
        }
    }
}

