/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSLayoutRecord;
import org.eclipse.swt.internal.carbon.CGPathElement;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public class Path
extends Resource {
    public int handle;
    boolean moved;
    boolean closed = true;
    float originX;
    float originY;
    float[] point = new float[2];
    boolean first;
    CGPathElement element;
    int count;
    int typeCount;
    byte[] types;
    float[] points;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.CGPathCreateMutable();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float[] fArray = new float[6];
        OS.CGAffineTransformMake(f3 / 2.0f, 0.0f, 0.0f, f4 / 2.0f, f + f3 / 2.0f, f2 + f4 / 2.0f, fArray);
        if (f6 < 0.0f) {
            float f7 = -(f5 + f6) * (float)Compatibility.PI / 180.0f;
            if (this.closed) {
                OS.CGPathMoveToPoint(this.handle, fArray, (float)Math.cos(f7), (float)Math.sin(f7));
            }
            OS.CGPathAddArc(this.handle, fArray, 0.0f, 0.0f, 1.0f, f7, -f5 * (float)Compatibility.PI / 180.0f, true);
        } else {
            float f8 = -f5 * (float)Compatibility.PI / 180.0f;
            if (this.closed) {
                OS.CGPathMoveToPoint(this.handle, fArray, (float)Math.cos(f8), (float)Math.sin(f8));
            }
            OS.CGPathAddArc(this.handle, fArray, 0.0f, 0.0f, 1.0f, f8, -(f5 + f6) * (float)Compatibility.PI / 180.0f, true);
        }
        this.moved = true;
        this.closed = false;
        if (Math.abs(f6) >= 360.0f) {
            this.close();
        }
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        OS.CGPathAddPath(this.handle, null, path.handle);
        this.moved = false;
        this.closed = path.closed;
    }

    public void addRectangle(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        CGRect cGRect = new CGRect();
        cGRect.x = f;
        cGRect.y = f2;
        cGRect.width = f3;
        cGRect.height = f4;
        OS.CGPathAddRect(this.handle, null, cGRect);
        this.moved = false;
        this.closed = true;
    }

    int newPathProc(int n) {
        this.first = true;
        return 0;
    }

    int closePathProc(int n) {
        this.first = true;
        return 0;
    }

    int lineProc(int n, int n2, int n3) {
        if (this.first) {
            this.first = false;
            OS.memmove(this.point, n, 8);
            OS.CGPathMoveToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1]);
        }
        OS.memmove(this.point, n2, 8);
        OS.CGPathAddLineToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1]);
        return 0;
    }

    int curveProc(int n, int n2, int n3, int n4) {
        if (this.first) {
            this.first = false;
            OS.memmove(this.point, n, 8);
            OS.CGPathMoveToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1]);
        }
        OS.memmove(this.point, n3, 8);
        float f = this.point[0];
        float f2 = this.point[1];
        OS.memmove(this.point, n2, 8);
        OS.CGPathAddQuadCurveToPoint(this.handle, null, this.originX + this.point[0], this.originY + this.point[1], this.originX + f, this.originY + f2);
        return 0;
    }

    public void addString(String string, float f, float f2, Font font) {
        int n;
        Callback callback;
        int n2;
        Callback callback2;
        int n3;
        Callback callback3;
        int n4;
        int n5;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        if ((n5 = string.length()) == 0) {
            return;
        }
        this.moved = false;
        this.closed = true;
        Callback callback4 = new Callback(this, "newPathProc", 1);
        int n6 = callback4.getAddress();
        if (n6 == 0) {
            SWT.error(3);
        }
        if ((n4 = (callback3 = new Callback(this, "lineProc", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((n3 = (callback2 = new Callback(this, "curveProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((n2 = (callback = new Callback(this, "closePathProc", 1)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((n = font.atsuiStyle) == 0) {
            n = font.createStyle();
        }
        if (n == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        OS.ATSUCreateTextLayout(nArray);
        if (nArray[0] == 0) {
            SWT.error(2);
        }
        int n7 = nArray[0];
        char[] cArray = new char[n5];
        string.getChars(0, n5, cArray, 0);
        int n8 = OS.NewPtr(n5 * 2);
        if (n8 == 0) {
            SWT.error(2);
        }
        OS.memmove(n8, cArray, n5 * 2);
        OS.ATSUSetTextPointerLocation(n7, n8, 0, n5, n5);
        OS.ATSUSetRunStyle(n7, n, 0, n5);
        OS.ATSUSetTransientFontMatching(n7, true);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.ATSUGetUnjustifiedBounds(n7, 0, n5, null, null, nArray2, nArray3);
        f2 = (float)((double)f2 + OS.Fix2X(nArray2[0]));
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        int[] nArray7 = new int[1];
        OS.ATSUDirectGetLayoutDataArrayPtrFromTextLayout(n7, 0, 100, nArray4, nArray5);
        OS.ATSUDirectGetLayoutDataArrayPtrFromTextLayout(n7, 0, 1, nArray6, nArray7);
        int[] nArray8 = new int[1];
        int[] nArray9 = new int[1];
        ATSLayoutRecord aTSLayoutRecord = new ATSLayoutRecord();
        int n9 = 0;
        while (n9 < nArray5[0]) {
            OS.memmove(aTSLayoutRecord, nArray4[0] + n9 * 14, 14);
            this.originX = f + (float)OS.Fix2X(aTSLayoutRecord.realPos);
            if (nArray6[0] == 0) {
                this.originY = f2;
            } else {
                OS.memmove(nArray8, nArray6[0] + n9 * 4, 4);
                this.originY = f2 - (float)OS.Fix2X(nArray8[0]);
            }
            this.first = true;
            if (aTSLayoutRecord.glyphID != 65535) {
                OS.ATSUGlyphGetQuadraticPaths(n, aTSLayoutRecord.glyphID, n6, n4, n3, n2, 0, nArray9);
            }
            ++n9;
        }
        OS.CGPathCloseSubpath(this.handle);
        if (nArray6[0] != 0) {
            OS.ATSUDirectReleaseLayoutDataArrayPtr(0, 1, nArray6[0]);
        }
        OS.ATSUDirectReleaseLayoutDataArrayPtr(0, 100, nArray4[0]);
        if (n != font.atsuiStyle) {
            OS.ATSUDisposeStyle(n);
        }
        if (n7 != 0) {
            OS.ATSUDisposeTextLayout(n7);
        }
        if (n8 != 0) {
            OS.DisposePtr(n8);
        }
        callback4.dispose();
        callback3.dispose();
        callback2.dispose();
        callback.dispose();
    }

    int applierFunc(int n, int n2) {
        OS.memmove(this.element, n2, 8);
        int n3 = 0;
        int n4 = 1;
        switch (this.element.type) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                n4 = 2;
                break;
            }
            case 3: {
                n3 = 4;
                n4 = 3;
                break;
            }
            case 4: {
                n3 = 5;
                n4 = 0;
            }
        }
        if (this.types != null) {
            this.types[this.typeCount] = (byte)n3;
            if (n4 > 0) {
                OS.memmove(this.point, this.element.points, n4 * 8);
                System.arraycopy(this.point, 0, this.points, this.count, n4 * 2);
            }
        }
        ++this.typeCount;
        this.count += n4 * 2;
        return 0;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathCloseSubpath(this.handle);
        this.moved = false;
        this.closed = true;
    }

    public boolean contains(float f, float f2, GC gC, boolean bl) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(120);
        int n = OS.NewPtr(4);
        if (n == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[]{-1};
        OS.memmove(n, nArray, 4);
        int n2 = OS.CGBitmapContextCreate(n, 1, 1, 8, 4, this.device.colorspace, 6);
        if (n2 == 0) {
            OS.DisposePtr(n);
            SWT.error(2);
        }
        GCData gCData = gC.data;
        int n3 = 0;
        switch (gCData.lineCap) {
            case 2: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 0;
                break;
            }
            case 3: {
                n3 = 2;
            }
        }
        OS.CGContextSetLineCap(n2, n3);
        int n4 = 0;
        switch (gCData.lineJoin) {
            case 1: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 2;
            }
        }
        OS.CGContextSetLineJoin(n2, n4);
        OS.CGContextSetLineWidth(n2, gCData.lineWidth);
        OS.CGContextTranslateCTM(n2, -f + 0.5f, -f2 + 0.5f);
        OS.CGContextAddPath(n2, this.handle);
        if (bl) {
            OS.CGContextStrokePath(n2);
        } else if (gCData.fillRule == 2) {
            OS.CGContextFillPath(n2);
        } else {
            OS.CGContextEOFillPath(n2);
        }
        OS.CGContextRelease(n2);
        OS.memmove(nArray, n, 4);
        OS.DisposePtr(n);
        return nArray[0] != -1;
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            CGPoint cGPoint = new CGPoint();
            OS.CGPathGetCurrentPoint(this.handle, cGPoint);
            OS.CGPathMoveToPoint(this.handle, null, cGPoint.x, cGPoint.y);
            this.moved = true;
        }
        this.closed = false;
        OS.CGPathAddCurveToPoint(this.handle, null, f, f2, f3, f4, f5, f6);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        OS.CGPathRelease(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getBounds(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        CGRect cGRect = new CGRect();
        OS.CGPathGetBoundingBox(this.handle, cGRect);
        fArray[0] = cGRect.x;
        fArray[1] = cGRect.y;
        fArray[2] = cGRect.width;
        fArray[3] = cGRect.height;
    }

    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        CGPoint cGPoint = new CGPoint();
        OS.CGPathGetCurrentPoint(this.handle, cGPoint);
        fArray[0] = cGPoint.x;
        fArray[1] = cGPoint.y;
    }

    public PathData getPathData() {
        Callback callback;
        int n;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((n = (callback = new Callback(this, "applierFunc", 2)).getAddress()) == 0) {
            SWT.error(3);
        }
        this.typeCount = 0;
        this.count = 0;
        this.element = new CGPathElement();
        OS.CGPathApply(this.handle, 0, n);
        this.types = new byte[this.typeCount];
        this.points = new float[this.count];
        this.point = new float[6];
        this.typeCount = 0;
        this.count = 0;
        OS.CGPathApply(this.handle, 0, n);
        callback.dispose();
        PathData pathData = new PathData();
        pathData.types = this.types;
        pathData.points = this.points;
        this.element = null;
        this.types = null;
        this.points = null;
        this.point = null;
        return pathData;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void lineTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            CGPoint cGPoint = new CGPoint();
            OS.CGPathGetCurrentPoint(this.handle, cGPoint);
            OS.CGPathMoveToPoint(this.handle, null, cGPoint.x, cGPoint.y);
            this.moved = true;
        }
        this.closed = false;
        OS.CGPathAddLineToPoint(this.handle, null, f, f2);
    }

    public void moveTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathMoveToPoint(this.handle, null, f, f2);
        this.closed = true;
        this.moved = true;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (!this.moved) {
            CGPoint cGPoint = new CGPoint();
            OS.CGPathGetCurrentPoint(this.handle, cGPoint);
            OS.CGPathMoveToPoint(this.handle, null, cGPoint.x, cGPoint.y);
            this.moved = true;
        }
        this.closed = false;
        OS.CGPathAddQuadCurveToPoint(this.handle, null, f, f2, f3, f4);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

