/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class Safari
extends WebBrowser {
    int delegate;
    int webViewHandle;
    int windowBoundsHandler;
    boolean changingLocation;
    String lastHoveredLinkURL;
    String html;
    int identifier;
    int resourceCount;
    String url = "";
    org.eclipse.swt.graphics.Point location;
    org.eclipse.swt.graphics.Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String URI_FROMMEMORY = "file:///";
    static final String ABOUT_BLANK = "about:blank";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String BROWSER_WINDOW = "org.eclipse.swt.browser.Browser.Window";

    static {
        NativeClearSessions = new Runnable(){

            public void run() {
                int n = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int n2 = Cocoa.objc_msgSend(n, Cocoa.S_cookies);
                int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_count);
                int n4 = 0;
                while (n4 < n3) {
                    boolean bl;
                    int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_objectAtIndex, n4);
                    boolean bl2 = bl = Cocoa.objc_msgSend(n5, Cocoa.S_isSessionOnly) != 0;
                    if (bl) {
                        Cocoa.objc_msgSend(n, Cocoa.S_deleteCookie, n5);
                    }
                    ++n4;
                }
            }
        };
    }

    Safari() {
    }

    public void create(Composite composite, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (OS.VERSION < 4144) {
            this.browser.dispose();
            SWT.error(2);
        }
        int[] nArray2 = new int[1];
        try {
            Cocoa.HIWebViewCreate(nArray2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.browser.dispose();
            SWT.error(2);
        }
        this.webViewHandle = nArray2[0];
        if (this.webViewHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{new Integer(this.webViewHandle), this.browser});
        if (display.getData(BROWSER_WINDOW) == null) {
            Rect rect = new Rect();
            OS.SetRect(rect, (short)0, (short)0, (short)1, (short)1);
            nArray = new int[1];
            OS.CreateNewWindow(14, 0, rect, nArray);
            OS.ShowWindow(nArray[0]);
            display.disposeExec(new Runnable(){

                public void run() {
                    if (nArray[0] != 0) {
                        OS.DisposeWindow(nArray[0]);
                    }
                    nArray[0] = 0;
                }
            });
            display.setData(BROWSER_WINDOW, nArray);
        }
        int n4 = OS.GetControlOwner(this.browser.handle);
        nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), nArray);
        OS.HIViewAddSubview(nArray[0], this.webViewHandle);
        OS.HIViewChangeFeatures(this.webViewHandle, 0x2000000, 0);
        OS.HIViewSetVisible(this.webViewHandle, true);
        if (this.browser.getShell().isVisible()) {
            int[] nArray3 = new int[1];
            OS.CreateEvent(0, 2003398244, 24, 0.0, 1, nArray3);
            OS.SetEventParameter(nArray3[0], 0x2D2D2D2D, 2003398244, 4, new int[]{OS.GetControlOwner(this.browser.handle)});
            OS.SendEventToEventTarget(nArray3[0], OS.GetWindowEventTarget(n4));
            if (nArray3[0] != 0) {
                OS.ReleaseEvent(nArray3[0]);
            }
        }
        final int n5 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        final int n6 = Cocoa.objc_msgSend(Cocoa.C_NSNotificationCenter, Cocoa.S_defaultCenter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (Safari.this.ignoreDispose) {
                            Safari.this.ignoreDispose = false;
                            break;
                        }
                        Safari.this.ignoreDispose = true;
                        Safari.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        OS.RemoveEventHandler(Safari.this.windowBoundsHandler);
                        Safari.this.windowBoundsHandler = 0;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = new Integer(Safari.this.webViewHandle);
                        event.display.setData(Safari.ADD_WIDGET_KEY, objectArray);
                        Cocoa.objc_msgSend(n5, Cocoa.S_setFrameLoadDelegate, 0);
                        Cocoa.objc_msgSend(n5, Cocoa.S_setResourceLoadDelegate, 0);
                        Cocoa.objc_msgSend(n5, Cocoa.S_setUIDelegate, 0);
                        Cocoa.objc_msgSend(n5, Cocoa.S_setPolicyDelegate, 0);
                        Cocoa.objc_msgSend(n6, Cocoa.S_removeObserver, Safari.this.delegate);
                        Cocoa.objc_msgSend(Safari.this.delegate, Cocoa.S_release);
                        OS.DisposeControl(Safari.this.webViewHandle);
                        Safari.this.html = null;
                        Safari.this.lastHoveredLinkURL = null;
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        if (Callback3 == null) {
            Callback3 = new Callback(this.getClass(), "eventProc3", 3);
        }
        if ((n3 = Callback3.getAddress()) == 0) {
            SWT.error(3);
        }
        int[] nArray4 = new int[]{1801812322, 1, 1668183148, 4, 1668183148, 11, 1952807028, 2};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.webViewHandle), n3, nArray4.length / 2, nArray4, this.webViewHandle, null);
        int[] nArray5 = new int[]{1668183148, 154, 1668183148, 157, 1668183148, 159};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.browser.handle), n3, nArray5.length / 2, nArray5, this.browser.handle, null);
        int[] nArray6 = new int[]{2003398244, 27};
        int[] nArray7 = new int[1];
        OS.InstallEventHandler(OS.GetWindowEventTarget(n4), n3, nArray6.length / 2, nArray6, this.browser.handle, nArray7);
        this.windowBoundsHandler = nArray7[0];
        if (Callback7 == null) {
            Callback7 = new Callback(this.getClass(), "eventProc7", 7);
        }
        if ((n2 = Callback7.getAddress()) == 0) {
            SWT.error(3);
        }
        this.delegate = Cocoa.objc_msgSend(Cocoa.C_WebKitDelegate, Cocoa.S_alloc);
        this.delegate = Cocoa.objc_msgSend(this.delegate, Cocoa.S_initWithProc, n2, this.webViewHandle);
        Cocoa.objc_msgSend(n5, Cocoa.S_setFrameLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(n5, Cocoa.S_setResourceLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(n5, Cocoa.S_setUIDelegate, this.delegate);
        Cocoa.objc_msgSend(n6, Cocoa.S_addObserver_selector_name_object, this.delegate, Cocoa.S_handleNotification, 0, n5);
        Cocoa.objc_msgSend(n5, Cocoa.S_setPolicyDelegate, this.delegate);
        Cocoa.objc_msgSend(n5, Cocoa.S_setDownloadDelegate, this.delegate);
        if (!Initialized) {
            Initialized = true;
            int n7 = Cocoa.objc_msgSend(Cocoa.C_WebPreferences, Cocoa.S_standardPreferences);
            Cocoa.objc_msgSend(n7, Cocoa.S_setJavaEnabled, 0);
        }
    }

    static int eventProc3(int n, int n2, int n3) {
        Widget widget = Display.getCurrent().findWidget(n3);
        if (widget instanceof Browser) {
            return ((Safari)((Browser)widget).webBrowser).handleCallback(n, n2);
        }
        return -9874;
    }

    static int eventProc7(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Widget widget = Display.getCurrent().findWidget(n2);
        if (widget instanceof Browser) {
            return ((Safari)((Browser)widget).webBrowser).handleCallback(n3, n4, n5, n6, n7);
        }
        return 0;
    }

    public boolean back() {
        this.html = null;
        int n = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(n, Cocoa.S_goBack) != 0;
    }

    public boolean execute(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        int n3 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_stringByEvaluatingJavaScriptFromString, n2);
        OS.CFRelease(n2);
        return n4 != 0;
    }

    public boolean forward() {
        this.html = null;
        int n = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(n, Cocoa.S_goForward) != 0;
    }

    public String getUrl() {
        return this.url;
    }

    int handleCallback(int n, int n2) {
        int n3 = OS.GetEventKind(n2);
        switch (OS.GetEventClass(n2)) {
            case 1668183148: {
                Object[] objectArray;
                int[] nArray;
                Object object;
                switch (n3) {
                    case 11: {
                        return 0;
                    }
                    case 4: {
                        if (this.browser.isVisible()) break;
                        return 0;
                    }
                    case 159: {
                        int n4 = OS.GetControlOwner(this.browser.handle);
                        object = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), object);
                        OS.HIViewAddSubview(object[0], this.webViewHandle);
                        OS.RemoveEventHandler(this.windowBoundsHandler);
                        nArray = new int[]{2003398244, 27};
                        objectArray = new int[1];
                        OS.InstallEventHandler(OS.GetWindowEventTarget(n4), Callback3.getAddress(), nArray.length / 2, nArray, this.browser.handle, objectArray);
                        this.windowBoundsHandler = objectArray[0];
                        break;
                    }
                    case 154: 
                    case 157: {
                        CGRect cGRect = new CGRect();
                        if (!this.browser.isVisible()) {
                            cGRect.y = -16.0f;
                            cGRect.x = -16.0f;
                            cGRect.height = 16.0f;
                            cGRect.width = 16.0f;
                            OS.HIViewSetFrame(this.webViewHandle, cGRect);
                            break;
                        }
                        OS.HIViewGetBounds(this.browser.handle, cGRect);
                        object = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), object);
                        OS.HIViewConvertRect(cGRect, this.browser.handle, object[0]);
                        if (cGRect.width <= 16.0f) {
                            cGRect.width = 16.0f;
                        }
                        if (cGRect.height <= 16.0f) {
                            cGRect.height = 16.0f;
                        }
                        OS.HIViewSetFrame(this.webViewHandle, cGRect);
                    }
                }
            }
            case 2003398244: {
                int[] nArray;
                Object object;
                switch (n3) {
                    case 27: {
                        if (!this.browser.isVisible()) break;
                        CGRect cGRect = new CGRect();
                        OS.GetEventParameter(n2, 1869767540, 1751741027, null, 16, null, cGRect);
                        object = new CGRect();
                        OS.GetEventParameter(n2, 1668440948, 1751741027, null, 16, null, (CGRect)object);
                        if (cGRect.height == object.height) break;
                        OS.HIViewGetBounds(this.browser.handle, (CGRect)object);
                        nArray = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), nArray);
                        OS.HIViewConvertRect((CGRect)object, this.browser.handle, nArray[0]);
                        if (object.width <= 16.0f) {
                            object.width = 16.0f;
                        }
                        if (object.height <= 16.0f) {
                            object.height = 16.0f;
                        }
                        object.x += 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, (CGRect)object);
                        object.x -= 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, (CGRect)object);
                    }
                }
            }
            case 1801812322: {
                Object[] objectArray;
                int[] nArray;
                switch (n3) {
                    case 1: {
                        int[] nArray2 = new int[1];
                        int n5 = OS.GetEventParameter(n2, 1802858089, 1970567284, null, 4, nArray2, null);
                        if (n5 != 0 || nArray2[0] == 0) break;
                        nArray = new int[1];
                        OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray);
                        objectArray = new char[1];
                        OS.GetEventParameter(n2, 1802858089, 1970567284, null, 2, null, objectArray);
                        if ((nArray[0] & 0x100) == 0) break;
                        switch (objectArray[0]) {
                            case 'v': {
                                int n6 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
                                Cocoa.objc_msgSend(n6, Cocoa.S_paste);
                                return 0;
                            }
                            case 'c': {
                                int n7 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
                                Cocoa.objc_msgSend(n7, Cocoa.S_copy);
                                return 0;
                            }
                            case 'x': {
                                int n8 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
                                Cocoa.objc_msgSend(n8, Cocoa.S_cut);
                                return 0;
                            }
                        }
                    }
                }
            }
            case 1952807028: {
                switch (n3) {
                    default: 
                }
            }
        }
        return -9874;
    }

    int handleCallback(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        switch (n) {
            case 1: {
                this.didFailProvisionalLoadWithError(n2, n3);
                break;
            }
            case 2: {
                this.didFinishLoadForFrame(n2);
                break;
            }
            case 3: {
                this.didReceiveTitle(n2, n3);
                break;
            }
            case 4: {
                this.didStartProvisionalLoadForFrame(n2);
                break;
            }
            case 5: {
                this.didFinishLoadingFromDataSource(n2, n3);
                break;
            }
            case 6: {
                this.didFailLoadingWithError(n2, n3, n4);
                break;
            }
            case 7: {
                n6 = this.identifierForInitialRequest(n2, n3);
                break;
            }
            case 8: {
                n6 = this.willSendRequest(n2, n3, n4, n5);
                break;
            }
            case 9: {
                this.handleNotification(n2);
                break;
            }
            case 10: {
                this.didCommitLoadForFrame(n2);
                break;
            }
            case 11: {
                n6 = this.createWebViewWithRequest(n2);
                break;
            }
            case 12: {
                this.webViewShow(n2);
                break;
            }
            case 13: {
                this.setFrame(n2);
                break;
            }
            case 14: {
                this.webViewClose();
                break;
            }
            case 15: {
                n6 = this.contextMenuItemsForElement(n2, n3);
                break;
            }
            case 16: {
                this.setStatusBarVisible(n2);
                break;
            }
            case 17: {
                this.setResizable(n2);
                break;
            }
            case 18: {
                this.setToolbarsVisible(n2);
                break;
            }
            case 19: {
                this.decidePolicyForMIMEType(n2, n3, n4, n5);
                break;
            }
            case 20: {
                this.decidePolicyForNavigationAction(n2, n3, n4, n5);
                break;
            }
            case 21: {
                this.decidePolicyForNewWindowAction(n2, n3, n4, n5);
                break;
            }
            case 22: {
                this.unableToImplementPolicyWithError(n2, n3);
                break;
            }
            case 23: {
                this.setStatusText(n2);
                break;
            }
            case 24: {
                this.webViewFocus();
                break;
            }
            case 25: {
                this.webViewUnfocus();
                break;
            }
            case 26: {
                this.runJavaScriptAlertPanelWithMessage(n2);
                break;
            }
            case 27: {
                n6 = this.runJavaScriptConfirmPanelWithMessage(n2);
                break;
            }
            case 28: {
                this.runOpenPanelForFileButtonWithResultListener(n2);
                break;
            }
            case 29: {
                this.decideDestinationWithSuggestedFilename(n2, n3);
                break;
            }
            case 30: {
                this.mouseDidMoveOverElement(n2, n3);
            }
        }
        return n6;
    }

    public boolean isBackEnabled() {
        int n = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(n, Cocoa.S_canGoBack) != 0;
    }

    public boolean isForwardEnabled() {
        int n = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        return Cocoa.objc_msgSend(n, Cocoa.S_canGoForward) != 0;
    }

    public void refresh() {
        int n = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        Cocoa.objc_msgSend(n, Cocoa.S_reload, 0);
    }

    public boolean setText(String string) {
        if (this.changingLocation) {
            this.html = string;
        } else {
            this._setText(string);
        }
        return true;
    }

    void _setText(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        n = URI_FROMMEMORY.length();
        cArray = new char[n];
        URI_FROMMEMORY.getChars(0, n, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, n);
        int n4 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n3);
        OS.CFRelease(n3);
        int n5 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(n6, Cocoa.S_loadHTMLStringbaseURL, n2, n4);
        OS.CFRelease(n2);
    }

    public boolean setUrl(String string) {
        this.html = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(47) == 0) {
            stringBuffer.append("file://");
        } else if (string.indexOf(58) == -1) {
            stringBuffer.append("http://");
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == ' ') {
                stringBuffer.append("%20");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        int n3 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n2);
        OS.CFRelease(n2);
        int n4 = Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_requestWithURL, n3);
        int n5 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(n6, Cocoa.S_loadRequest, n4);
        return true;
    }

    public void stop() {
        this.html = null;
        int n = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        Cocoa.objc_msgSend(n, Cocoa.S_stopLoading, 0);
    }

    void didFailProvisionalLoadWithError(int n, int n2) {
        int n3 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        if (n2 == Cocoa.objc_msgSend(n3, Cocoa.S_mainFrame)) {
            this.identifier = 0;
        }
    }

    void didFinishLoadForFrame(int n) {
        int n2 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        if (n == Cocoa.objc_msgSend(n2, Cocoa.S_mainFrame)) {
            int n3;
            final Display display = this.browser.getDisplay();
            int n4 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
            if (n4 != 0 && (n3 = Cocoa.objc_msgSend(n4, Cocoa.S_pageTitle)) == 0) {
                final TitleEvent titleEvent = new TitleEvent(this.browser);
                titleEvent.display = display;
                titleEvent.widget = this.browser;
                titleEvent.title = this.url;
                int n5 = 0;
                while (n5 < this.titleListeners.length) {
                    final TitleListener titleListener = this.titleListeners[n5];
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                                titleListener.changed(titleEvent);
                            }
                        }
                    });
                    ++n5;
                }
            }
            final ProgressEvent progressEvent = new ProgressEvent(this.browser);
            progressEvent.display = display;
            progressEvent.widget = this.browser;
            progressEvent.current = 100;
            progressEvent.total = 100;
            int n6 = 0;
            while (n6 < this.progressListeners.length) {
                final ProgressListener progressListener = this.progressListeners[n6];
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                            progressListener.completed(progressEvent);
                        }
                    }
                });
                ++n6;
            }
            this.identifier = 0;
        }
    }

    void didReceiveTitle(int n, int n2) {
        int n3 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        if (n2 == Cocoa.objc_msgSend(n3, Cocoa.S_mainFrame)) {
            int n4 = OS.CFStringGetLength(n);
            char[] cArray = new char[n4];
            CFRange cFRange = new CFRange();
            cFRange.length = n4;
            OS.CFStringGetCharacters(n, cFRange, cArray);
            String string = new String(cArray);
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            int n5 = 0;
            while (n5 < this.titleListeners.length) {
                this.titleListeners[n5].changed(titleEvent);
                ++n5;
            }
        }
    }

    void didStartProvisionalLoadForFrame(int n) {
    }

    void didCommitLoadForFrame(int n) {
        TypedEvent typedEvent;
        boolean bl;
        int n2 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
        int n3 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_request);
        int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_URL);
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        if (n7 == 0) {
            return;
        }
        char[] cArray = new char[n7];
        CFRange cFRange = new CFRange();
        cFRange.length = n7;
        OS.CFStringGetCharacters(n6, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FROMMEMORY)) {
            string = ABOUT_BLANK;
        }
        final Display display = this.browser.getDisplay();
        boolean bl2 = bl = n == Cocoa.objc_msgSend(n2, Cocoa.S_mainFrame);
        if (bl) {
            this.resourceCount = 0;
            this.url = string;
            typedEvent = new ProgressEvent(this.browser);
            ((ProgressEvent)typedEvent).display = display;
            ((ProgressEvent)typedEvent).widget = this.browser;
            ((ProgressEvent)typedEvent).current = 1;
            ((ProgressEvent)typedEvent).total = 100;
            int n8 = 0;
            while (n8 < this.progressListeners.length) {
                final ProgressListener progressListener = this.progressListeners[n8];
                display.asyncExec(new Runnable((ProgressEvent)typedEvent){
                    private final /* synthetic */ ProgressEvent val$progress;
                    {
                        this.val$progress = progressEvent;
                    }

                    public void run() {
                        if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                            progressListener.changed(this.val$progress);
                        }
                    }
                });
                ++n8;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            int n9 = 0;
            while (n9 < this.statusTextListeners.length) {
                this.statusTextListeners[n9].changed(statusTextEvent);
                ++n9;
            }
        }
        typedEvent = new LocationEvent(this.browser);
        typedEvent.display = display;
        typedEvent.widget = this.browser;
        typedEvent.location = string;
        typedEvent.top = bl;
        int n10 = 0;
        while (n10 < this.locationListeners.length) {
            this.locationListeners[n10].changed((LocationEvent)typedEvent);
            ++n10;
        }
    }

    void didFinishLoadingFromDataSource(int n, int n2) {
    }

    void didFailLoadingWithError(int n, int n2, int n3) {
    }

    int identifierForInitialRequest(int n, int n2) {
        final Display display = this.browser.getDisplay();
        final ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = display;
        progressEvent.widget = this.browser;
        progressEvent.current = this.resourceCount;
        progressEvent.total = Math.max(this.resourceCount, 100);
        int n3 = 0;
        while (n3 < this.progressListeners.length) {
            final ProgressListener progressListener = this.progressListeners[n3];
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed() && !Safari.this.browser.isDisposed()) {
                        progressListener.changed(progressEvent);
                    }
                }
            });
            ++n3;
        }
        n3 = Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithInt, this.resourceCount++);
        if (this.identifier == 0) {
            int n4 = Cocoa.HIWebViewGetWebView(this.webViewHandle);
            int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_webFrame);
            if (n5 == Cocoa.objc_msgSend(n4, Cocoa.S_mainFrame)) {
                this.identifier = n3;
            }
        }
        return n3;
    }

    int willSendRequest(int n, int n2, int n3, int n4) {
        return n2;
    }

    void handleNotification(int n) {
    }

    int createWebViewWithRequest(int n) {
        int n2;
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            n2 = 0;
            while (n2 < this.openWindowListeners.length) {
                this.openWindowListeners[n2].open(windowEvent);
                ++n2;
            }
        }
        n2 = 0;
        Browser browser = windowEvent.browser;
        if (browser != null && !browser.isDisposed()) {
            n2 = Cocoa.HIWebViewGetWebView(((Safari)browser.webBrowser).webViewHandle);
            if (n != 0) {
                int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(n3, Cocoa.S_loadRequest, n);
            }
        }
        return n2;
    }

    void webViewShow(int n) {
        Shell shell = this.browser.getShell();
        org.eclipse.swt.graphics.Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = true;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        int n2 = 0;
        while (n2 < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[n2].show(windowEvent);
            ++n2;
        }
        this.location = null;
        this.size = null;
    }

    void setFrame(int n) {
        float[] fArray = new float[4];
        OS.memmove(fArray, n, 16);
        Rectangle rectangle = this.browser.getDisplay().getBounds();
        this.location = new org.eclipse.swt.graphics.Point((int)fArray[0], rectangle.height - (int)fArray[1] - (int)fArray[3]);
        this.size = new org.eclipse.swt.graphics.Point((int)fArray[2], (int)fArray[3]);
    }

    void webViewFocus() {
    }

    void webViewUnfocus() {
    }

    void runJavaScriptAlertPanelWithMessage(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        String string = new String(cArray);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        messageBox.open();
    }

    int runJavaScriptConfirmPanelWithMessage(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        String string = new String(cArray);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runOpenPanelForFileButtonWithResultListener(int n) {
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 0);
        String string = fileDialog.open();
        if (string == null) {
            Cocoa.objc_msgSend(n, Cocoa.S_cancel);
            return;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, n2);
        Cocoa.objc_msgSend(n, Cocoa.S_chooseFilename, n3);
        OS.CFRelease(n3);
    }

    void webViewClose() {
        Shell shell = this.browser.getShell();
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n = 0;
        while (n < this.closeWindowListeners.length) {
            this.closeWindowListeners[n].close(windowEvent);
            ++n;
        }
        this.browser.dispose();
        if (shell.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
    }

    int contextMenuItemsForElement(int n, int n2) {
        Point point = new Point();
        OS.GetGlobalMouse(point);
        Event event = new Event();
        event.x = point.h;
        event.y = point.v;
        this.browser.notifyListeners(35, event);
        Menu menu = this.browser.getMenu();
        if (!event.doit) {
            return 0;
        }
        if (menu != null && !menu.isDisposed()) {
            if (event.x != point.h || event.y != point.v) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return n2;
    }

    void setStatusBarVisible(int n) {
        this.statusBar = n != 0;
    }

    void setStatusText(int n) {
        int n2 = OS.CFStringGetLength(n);
        if (n2 == 0) {
            return;
        }
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(cArray);
        int n3 = 0;
        while (n3 < this.statusTextListeners.length) {
            this.statusTextListeners[n3].changed(statusTextEvent);
            ++n3;
        }
    }

    void setResizable(int n) {
    }

    void setToolbarsVisible(int n) {
        this.toolBar = n != 0;
    }

    void mouseDidMoveOverElement(int n, int n2) {
        Object object;
        String string;
        if (n == 0) {
            return;
        }
        int n3 = WebElementLinkURLKey.length();
        char[] cArray = new char[n3];
        WebElementLinkURLKey.getChars(0, n3, cArray, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray, n3);
        int n5 = Cocoa.objc_msgSend(n, Cocoa.S_valueForKey, n4);
        OS.CFRelease(n4);
        if (n5 == 0) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            int n6 = 0;
            while (n6 < this.statusTextListeners.length) {
                this.statusTextListeners[n6].changed(statusTextEvent);
                ++n6;
            }
            return;
        }
        int n7 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        n3 = OS.CFStringGetLength(n7);
        if (n3 == 0) {
            string = "";
        } else {
            cArray = new char[n3];
            object = new CFRange();
            ((CFRange)object).length = n3;
            OS.CFStringGetCharacters(n7, (CFRange)object, cArray);
            string = new String(cArray);
        }
        if (string.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = string;
        object = new StatusTextEvent(this.browser);
        ((StatusTextEvent)object).display = this.browser.getDisplay();
        ((StatusTextEvent)object).widget = this.browser;
        ((StatusTextEvent)object).text = string;
        int n8 = 0;
        while (n8 < this.statusTextListeners.length) {
            this.statusTextListeners[n8].changed((StatusTextEvent)object);
            ++n8;
        }
    }

    void decidePolicyForMIMEType(int n, int n2, int n3, int n4) {
        boolean bl = Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_canShowMIMEType, n) != 0;
        Cocoa.objc_msgSend(n4, bl ? Cocoa.S_use : Cocoa.S_download);
    }

    void decidePolicyForNavigationAction(int n, int n2, int n3, int n4) {
        int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_URL);
        if (n5 == 0) {
            Cocoa.objc_msgSend(n4, Cocoa.S_ignore);
            return;
        }
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        char[] cArray = new char[n7];
        CFRange cFRange = new CFRange();
        cFRange.length = n7;
        OS.CFStringGetCharacters(n6, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FROMMEMORY)) {
            string = ABOUT_BLANK;
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            this.changingLocation = true;
            int n8 = 0;
            while (n8 < this.locationListeners.length) {
                this.locationListeners[n8].changing(locationEvent);
                ++n8;
            }
            this.changingLocation = false;
        }
        Cocoa.objc_msgSend(n4, locationEvent.doit ? Cocoa.S_use : Cocoa.S_ignore);
        if (this.html != null && !this.browser.isDisposed()) {
            String string2 = this.html;
            this.html = null;
            this._setText(string2);
        }
    }

    void decidePolicyForNewWindowAction(int n, int n2, int n3, int n4) {
        Cocoa.objc_msgSend(n4, Cocoa.S_use);
    }

    void unableToImplementPolicyWithError(int n, int n2) {
    }

    void decideDestinationWithSuggestedFilename(int n, int n2) {
        int n3 = OS.CFStringGetLength(n2);
        char[] cArray = new char[n3];
        CFRange cFRange = new CFRange();
        cFRange.length = n3;
        OS.CFStringGetCharacters(n2, cFRange, cArray);
        String string = new String(cArray);
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        if (string2 == null) {
            Cocoa.objc_msgSend(n, Cocoa.S_release);
            return;
        }
        n3 = string2.length();
        char[] cArray2 = new char[n3];
        string2.getChars(0, n3, cArray2, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, cArray2, n3);
        Cocoa.objc_msgSend(n, Cocoa.S_setDestinationAllowOverwrite, n4, 1);
        OS.CFRelease(n4);
    }
}

