/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jsd;

import java.io.File;
import java.io.IOException;
import net.kldp.jsd.IllegalSimpleDaemonClassException;
import net.kldp.jsd.LockFileExistException;
import net.kldp.jsd.SimpleDaemon;
import net.kldp.jsd.SimpleLogger;

public class SimpleDaemonManager {
    private static int DEFAULT_FILE_POLLING_INTERVAL = 2;
    private static SimpleDaemonManager instance = null;
    private Class simpleDaemonClass = null;
    private SimpleDaemon simpleDaemon = null;
    private String representName = null;
    private SimpleLogger log = null;
    private boolean initialized = false;
    static /* synthetic */ Class class$net$kldp$jsd$SimpleDaemon;

    private SimpleDaemonManager(Class daemonClass) {
        this.simpleDaemonClass = daemonClass;
        this.log = SimpleLogger.getLogger();
    }

    public static synchronized SimpleDaemonManager getInstance(Class daemonClass) throws IllegalSimpleDaemonClassException {
        if (instance != null) {
            return instance;
        }
        if (!SimpleDaemonManager.isSimpleDaemonClass(daemonClass)) {
            throw new IllegalSimpleDaemonClassException(daemonClass);
        }
        instance = new SimpleDaemonManager(daemonClass);
        return instance;
    }

    public static boolean isSimpleDaemonClass(Class daemonClass) {
        Class<?>[] interfaces = daemonClass.getInterfaces();
        boolean isSimpleDaemonClass = false;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(class$net$kldp$jsd$SimpleDaemon == null ? SimpleDaemonManager.class$("net.kldp.jsd.SimpleDaemon") : class$net$kldp$jsd$SimpleDaemon)) continue;
            isSimpleDaemonClass = true;
            break;
        }
        return isSimpleDaemonClass;
    }

    public void start() throws LockFileExistException, IOException, IllegalSimpleDaemonClassException {
        this.initialize();
        this.simpleDaemon.startDaemon();
    }

    protected synchronized void initialize() throws LockFileExistException, IOException, IllegalSimpleDaemonClassException {
        if (this.initialized) {
            this.log.err("\uc774\ubbf8 initialize() \uba54\uc18c\ub4dc\ub97c \ud638\ucd9c \ud588\uc5c8\uc2b5\ub2c8\ub2e4.");
            return;
        }
        try {
            this.simpleDaemon = (SimpleDaemon)this.simpleDaemonClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new IllegalSimpleDaemonClassException(this.simpleDaemonClass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalSimpleDaemonClassException(this.simpleDaemonClass, (Throwable)e);
        }
        File lockFile = this.getLockFile();
        if (lockFile.exists()) {
            throw new LockFileExistException(lockFile);
        }
        this.log.out(lockFile.getAbsolutePath() + " \ub77d \ud30c\uc77c\uc744 \uc0dd\uc131\ud569\ub2c8\ub2e4.");
        if (!lockFile.createNewFile()) {
            String err = lockFile.getAbsolutePath() + " \ub77d \ud30c\uc77c \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
            this.log.err(err);
            throw new IOException(err);
        }
        File exitFlagFile = this.getExitFlagFile();
        if (exitFlagFile.exists()) {
            this.log.out(exitFlagFile.getAbsolutePath() + " \uc885\ub8cc \ud45c\uc2dc\uc790 \ud30c\uc77c\uc774 \uc874\uc7ac\ud569\ub2c8\ub2e4. \uc0ad\uc81c\ud569\ub2c8\ub2e4.");
            if (!exitFlagFile.delete()) {
                String err = exitFlagFile.getAbsolutePath() + " \uc885\ub8cc \ud45c\uc2dc\uc790 \ud30c\uc77c \uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
                this.log.err(err);
                throw new IOException(err);
            }
        }
        Runtime.getRuntime().addShutdownHook(new SimpleDaemonShutdownManager());
        ExitFlagFilePoll effp = new ExitFlagFilePoll(DEFAULT_FILE_POLLING_INTERVAL);
        effp.setDaemon(true);
        effp.start();
    }

    protected String getLockFileName() {
        String lockFileName = this.getRepresentName() + ".lock";
        return lockFileName;
    }

    protected File getLockFile() {
        File lockFile = new File(this.getLockFileName());
        return lockFile;
    }

    protected String getExitFlagFileName() {
        String exitFlagFileName = this.getRepresentName() + ".shutdown";
        return exitFlagFileName;
    }

    protected File getExitFlagFile() {
        File exitFlagFile = new File(this.getExitFlagFileName());
        return exitFlagFile;
    }

    protected synchronized String getRepresentName() {
        if (this.representName != null) {
            return this.representName;
        }
        String home = System.getProperty("user.home");
        this.log.out("user.home\uc740 " + home);
        String className = this.simpleDaemonClass.getName();
        this.log.out("SimpleDaemon\uc758 \ud074\ub798\uc2a4 \uc774\ub984\uc740 " + className);
        this.representName = home + File.separator + ".NKJSD_" + className;
        this.log.out("\ub370\ubaac\uc744 \ub300\ud45c\ud558\ub294 \uc774\ub984\uc740 " + this.representName + " \uc785\ub2c8\ub2e4.");
        return this.representName;
    }

    public void shutdownDaemon() throws IOException {
        File exitFlagFile = this.getExitFlagFile();
        if (exitFlagFile.exists()) {
            this.log.err(exitFlagFile.getAbsolutePath() + "\uac00 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4.");
            return;
        }
        try {
            exitFlagFile.createNewFile();
        }
        catch (IOException ex) {
            String err = exitFlagFile.getAbsolutePath() + " \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.";
            this.log.err(err);
            throw new IOException(err);
        }
        this.log.out(exitFlagFile.getAbsolutePath() + " \ub97c \uc0dd\uc131\ud588\uc2b5\ub2c8\ub2e4. " + " \ub370\ubaac\uc774 \uace7 \uc885\ub8cc\ub420 \uac83\uc785\ub2c8\ub2e4.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ExitFlagFilePoll
    extends Thread {
        private int intervalms = 0;

        public ExitFlagFilePoll(int interval) {
            this.intervalms = interval > 0 ? interval * 1000 : DEFAULT_FILE_POLLING_INTERVAL * 1000;
        }

        public void run() {
            SimpleDaemonManager.this.log.out("\ub370\ubaac \uc885\ub8cc \ud45c\uc2dc\uc790 \ud30c\uc77c \uac10\uc2dc \uc4f0\ub808\ub4dc\ub97c \uc2dc\uc791\ud588\uc2b5\ub2c8\ub2e4.");
            while (true) {
                File exitFlagFile;
                if ((exitFlagFile = SimpleDaemonManager.this.getExitFlagFile()).exists()) {
                    SimpleDaemonManager.this.log.out(SimpleDaemonManager.this.getExitFlagFileName() + " \uac00 \uc0dd\uc131\ub418\uc5c8\uc2b5\ub2c8\ub2e4. " + "\uc2dc\uc2a4\ud15c\uc744 \uc885\ub8cc\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4 .");
                    System.exit(0);
                }
                try {
                    Thread.sleep(this.intervalms);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    protected class SimpleDaemonShutdownManager
    extends Thread {
        protected SimpleDaemonShutdownManager() {
        }

        public void run() {
            SimpleLogger log = SimpleLogger.getLogger();
            log.out("\ub370\ubaac\uc758 shutdown() \uba54\uc18c\ub4dc \ud638\ucd9c\ud569\ub2c8\ub2e4.");
            SimpleDaemonManager.this.simpleDaemon.shutdown();
            File lockFile = SimpleDaemonManager.this.getLockFile();
            log.out(lockFile.getAbsolutePath() + " \ub77d \ud30c\uc77c \uc0ad\uc81c\ub97c \uc2dc\ub3c4\ud569\ub2c8\ub2e4.");
            if (lockFile.exists()) {
                if (lockFile.delete()) {
                    log.out(lockFile.getAbsolutePath() + " \ub77d \ud30c\uc77c\uc744 \uc0ad\uc81c\ud588\uc2b5\ub2c8\ub2e4.");
                } else {
                    log.err(lockFile.getAbsolutePath() + " \ub77d \ud30c\uc77c \uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
                }
            } else {
                log.err(lockFile.getAbsolutePath() + " \ub77d \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            File exitFlagFile = SimpleDaemonManager.this.getExitFlagFile();
            log.out(exitFlagFile.getAbsolutePath() + " \uc885\ub8cc \ud45c\uc2dc\uc790 \ud30c\uc77c\uc758 \uc0ad\uc81c\ub97c \uc2dc\ub3c4\ud569\ub2c8\ub2e4.");
            if (exitFlagFile.exists()) {
                if (exitFlagFile.delete()) {
                    log.out(exitFlagFile.getAbsolutePath() + " \uc885\ub8cc \ud45c\uc2dc\uc790 \ud30c\uc77c\uc744 \uc0ad\uc81c\ud588\uc2b5\ub2c8\ub2e4.");
                } else {
                    log.err(exitFlagFile.getAbsolutePath() + " \uc885\ub8cc \ud45c\uc2dc\uc790 \ud30c\uc77c \uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
            log.out("\ub370\ubaac\uc758 \uc885\ub8cc\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
    }
}

