/*
 * Decompiled with CFR 0.152.
 */
package JpicDriver;

import JPICSDK.JpicDriverInterface;
import JPICSDK.JpicDriverOwnerInterface;
import JPICSDK.JpicXmlDocMaker;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class WeatherDisasterDriver
implements JpicDriverInterface,
Runnable {
    private Thread thread_;
    private JpicXmlDocMaker jpicXmlDocMaker_;
    private JpicDriverOwnerInterface owner_;
    private String uri_;

    public void setOwner(JpicDriverOwnerInterface owner) {
        this.owner_ = owner;
    }

    public JpicDriverOwnerInterface getOwner() {
        return this.owner_;
    }

    public boolean request(String uri) {
        if (this.owner_ == null) {
            return false;
        }
        if (this.thread_ != null && this.thread_.isAlive()) {
            return false;
        }
        this.uri_ = uri;
        this.thread_ = new Thread((Runnable)this);
        this.thread_.start();
        return true;
    }

    @Override
    public void run() {
        Document doc = this.analysisUri();
        this.owner_.onResponse(this.uri_, doc);
    }

    private Document analysisUri() {
        String[] uriItem = this.uri_.split("/");
        Document doc = null;
        if (uriItem.length <= 1) {
            return null;
        }
        if (uriItem[1].equals("\ubbf8\uc138\uba3c\uc9c0")) {
            doc = this.getUrlSourceDefault("http://www.kma.go.kr/weather/asiandust/density.jsp");
            doc = this.editFineDust(doc);
        } else if (uriItem[1].equals("\ud2b9\ubcf4")) {
            doc = this.getUrlSourceDefault("http://www.kma.go.kr/weather/warning/status.jsp");
            doc = this.editNewsbreak(doc);
        } else if (uriItem[1].equals("\uc8fc\uac04\uc608\ubcf4")) {
            doc = this.getUrlXml("http://www.kma.go.kr/weather/forecast/mid-term-xml.jsp?stnId=108");
            doc = this.editWeekForecast(doc);
        }
        return doc;
    }

    private Document editFineDust(Document inputDoc) {
        Document resultDoc = this.getDefaultResultDoc();
        Element rootEle = this.createAttributeElement(resultDoc, "\ubbf8\uc138\uba3c\uc9c0", "", "");
        Element curEle = (Element)resultDoc.getFirstChild().appendChild(rootEle);
        Element eTbody = (Element)inputDoc.getElementsByTagName("tbody").item(0);
        NodeList lTr = eTbody.getElementsByTagName("tr");
        int i = 0;
        while (i < lTr.getLength()) {
            Element eTr = (Element)lTr.item(i);
            NodeList lTd = eTr.getElementsByTagName("td");
            Element newDataEle = this.createAttributeElement(resultDoc, "\ub370\uc774\ud130", "", "");
            Element curDataEle = (Element)curEle.appendChild(newDataEle);
            int j = 0;
            while (j < lTd.getLength()) {
                Element eTd = (Element)lTd.item(j);
                if (j % 2 == 0) {
                    Element newCityEle = this.createTextElement(resultDoc, "\uad00\uce21\uc9c0\uc810", this.getChildNodeValue(eTd.getFirstChild()));
                    curDataEle.appendChild(newCityEle);
                } else {
                    Element newConcenEle = this.createTextElement(resultDoc, "\ub18d\ub3c4", this.getChildNodeValue((Node)eTd));
                    curDataEle.appendChild(newConcenEle);
                }
                if (j == 1) {
                    newDataEle = this.createAttributeElement(resultDoc, "\ub370\uc774\ud130", "", "");
                    curDataEle = (Element)curEle.appendChild(newDataEle);
                }
                ++j;
            }
            ++i;
        }
        return resultDoc;
    }

    private Document editNewsbreak(Document inputDoc) {
        Document resultDoc = this.getDefaultResultDoc();
        Element rootEle = this.createAttributeElement(resultDoc, "\ud2b9\ubcf4", "", "");
        Element curEle = (Element)resultDoc.getFirstChild().appendChild(rootEle);
        Element curSubEle = null;
        Element newEle = null;
        Element eDiv = null;
        Element eBody = (Element)inputDoc.getElementsByTagName("body").item(0);
        NodeList lDiv = eBody.getElementsByTagName("div");
        int i = 0;
        while (i < lDiv.getLength()) {
            eDiv = (Element)lDiv.item(i);
            if (eDiv.getAttribute("id").compareTo("content") == 0) break;
            ++i;
        }
        NodeList lDl = eDiv.getElementsByTagName("dl");
        int i2 = 0;
        while (i2 < lDl.getLength()) {
            Element eWeatherNews = (Element)lDl.item(i2);
            Element eDt = (Element)eWeatherNews.getFirstChild();
            Element eDd = (Element)eWeatherNews.getFirstChild().getNextSibling();
            switch (i2) {
                case 0: {
                    newEle = this.createAttributeElement(resultDoc, "\uae30\uc0c1\uc18d\ubcf4", "", "");
                    break;
                }
                case 1: {
                    newEle = this.createAttributeElement(resultDoc, "\uae30\uc0c1\ud2b9\ubcf4", "", "");
                    break;
                }
                case 2: {
                    newEle = this.createAttributeElement(resultDoc, "\uc608\ube44\uae30\uc0c1\ud2b9\ubcf4", "", "");
                    break;
                }
                case 3: {
                    newEle = this.createAttributeElement(resultDoc, "\uae30\uc0c1\uc815\ubcf4", "", "");
                }
            }
            String[] strText = this.getChildNodeValue((Node)eDt).split(": ");
            curSubEle = (Element)curEle.appendChild(newEle);
            newEle = this.createTextElement(resultDoc, "\ub0a0\uc9dc", strText[1]);
            curSubEle.appendChild(newEle);
            newEle = this.createTextElement(resultDoc, "\uc815\ubcf4", this.mergeChildText((Node)eDd, true));
            curSubEle.appendChild(newEle);
            ++i2;
        }
        return resultDoc;
    }

    private Document editWeekForecast(Document inputDoc) {
        Document resultDoc = this.getDefaultResultDoc();
        Element rootEle = null;
        Node curLocationEle = null;
        Element curCityEle = null;
        Element curDataEle = null;
        Element newDataEle = null;
        String strTempLocation = "";
        NodeList lLocation = inputDoc.getElementsByTagName("tm");
        rootEle = this.createAttributeElement(resultDoc, "\uc8fc\uac04\uc608\ubcf4", "", "");
        resultDoc.getFirstChild().appendChild(rootEle);
        Element newWeatherEle = this.createTextElement(resultDoc, "\ub0a0\uc9dc", this.getChildNodeValue(lLocation.item(0)));
        resultDoc.getFirstChild().getFirstChild().appendChild(newWeatherEle);
        lLocation = inputDoc.getElementsByTagName("location");
        int i = 0;
        while (i < lLocation.getLength()) {
            Element eLocation = (Element)lLocation.item(i);
            Node nProvince = eLocation.getFirstChild().getNextSibling();
            if (strTempLocation.compareTo(this.getChildNodeValue(nProvince)) != 0) {
                strTempLocation = this.getChildNodeValue(nProvince);
                Element newLocationEle = this.createAttributeElement(resultDoc, "\uc9c0\uc5ed", "\uc774\ub984", this.getChildNodeValue(nProvince));
                curLocationEle = (Element)resultDoc.getFirstChild().getFirstChild().appendChild(newLocationEle);
            }
            Node nCity = nProvince.getNextSibling().getNextSibling();
            Element newCityEle = this.createAttributeElement(resultDoc, "\ub3c4\uc2dc", "\uc774\ub984", this.getChildNodeValue(nCity));
            curCityEle = (Element)curLocationEle.appendChild(newCityEle);
            Node nData = nCity;
            int j = 0;
            while (j < 6) {
                nData = nData.getNextSibling().getNextSibling();
                newDataEle = this.createAttributeElement(resultDoc, "\ub370\uc774\ud130", "", "");
                curDataEle = (Element)curCityEle.appendChild(newDataEle);
                Node nDate = nData.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
                newDataEle = this.createTextElement(resultDoc, "\ub0a0\uc9dc", this.getChildNodeValue(nDate));
                curDataEle.appendChild(newDataEle);
                Node nWeather = nDate.getNextSibling().getNextSibling();
                newDataEle = this.createTextElement(resultDoc, "\ub0a0\uc528", this.getChildNodeValue(nWeather));
                curDataEle.appendChild(newDataEle);
                Node nMinTem = nWeather.getNextSibling().getNextSibling();
                newDataEle = this.createTextElement(resultDoc, "\ucd5c\uc800\uc628\ub3c4", this.getChildNodeValue(nMinTem));
                curDataEle.appendChild(newDataEle);
                Node nMaxTem = nMinTem.getNextSibling().getNextSibling();
                newDataEle = this.createTextElement(resultDoc, "\ucd5c\uace0\uc628\ub3c4", this.getChildNodeValue(nMaxTem));
                curDataEle.appendChild(newDataEle);
                Node nReliability = nMaxTem.getNextSibling().getNextSibling();
                newDataEle = this.createTextElement(resultDoc, "\uc2e0\ub8b0\ub3c4", this.getChildNodeValue(nReliability));
                curDataEle.appendChild(newDataEle);
                ++j;
            }
            ++i;
        }
        return resultDoc;
    }

    private String mergeChildText(Node rootNode, boolean isUsingNewLine) {
        return this.mergeChildText(rootNode.getChildNodes(), isUsingNewLine);
    }

    private String mergeChildText(NodeList nodeList, boolean isUsingNewLine) {
        String mergedText = "";
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                mergedText = String.valueOf(mergedText) + node.getNodeValue();
            } else if (node.hasChildNodes()) {
                if (isUsingNewLine && node.getNodeName().compareTo("p") == 0) {
                    mergedText = String.valueOf(mergedText) + "\n\n";
                }
                mergedText = String.valueOf(mergedText) + this.mergeChildText(node.getChildNodes(), isUsingNewLine);
            } else if (isUsingNewLine && node.getNodeName().compareTo("br") == 0) {
                mergedText = String.valueOf(mergedText) + "\n";
            }
            ++i;
        }
        return mergedText;
    }

    private String getChildNodeValue(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    private Element createTextElement(Document creator, String elementName, String text) {
        Element elementNode = creator.createElement(elementName);
        Text textNode = creator.createTextNode(text);
        elementNode.appendChild(textNode);
        return elementNode;
    }

    private Element createAttributeElement(Document creator, String elementName, String attriName, String attriValue) {
        Element elementNode = creator.createElement(elementName);
        if (attriName.compareTo("") != 0 && attriValue.compareTo("") != 0) {
            elementNode.setAttribute(attriName, attriValue);
        }
        return elementNode;
    }

    private Document getDefaultResultDoc() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document resultDoc = null;
        try {
            documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        resultDoc = documentBuilder.newDocument();
        Element rootElement = resultDoc.createElement("\uae30\uc0c1\uccad");
        resultDoc.appendChild(rootElement);
        rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttribute("xsi:noNamespaceSchemaLocation", "WeatherDisasterDriverDocument.xsd");
        return resultDoc;
    }

    private Document getUrlSourceDefault(String strUrl) {
        Document doc = null;
        try {
            URL url = new URL(strUrl);
            URLConnection connection = url.openConnection();
            connection.connect();
            Tidy tidy = new Tidy();
            tidy.setInputEncoding("EUC-KR");
            doc = tidy.parseDOM(connection.getInputStream(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private Document getUrlXml(String strUrl) {
        Document doc = null;
        try {
            URL url = new URL(strUrl);
            InputStream is = url.openStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            doc = parser.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }
}

