package com.ibatis.jpetstore.presentation.action;

import com.ibatis.common.util.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class ViewProductAction extends BaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    String productId = request.getParameter("productId");

    PaginatedList itemList = (PaginatedList)request.getSession().getAttribute("itemList");

    if (productId != null) {
      request.setAttribute("itemList", petStore.getItemListByProduct(productId));
      request.setAttribute("product", petStore.getProduct(productId));
    } else if (itemList != null) {
      String page = request.getParameter("page");
      if ("next".equals(page)) {
        itemList.nextPage();
      } else if ("previous".equals(page)) {
        itemList.previousPage();
      }
    }

    return mapping.findForward("success");

  }


}



