package com.ibatis.jpetstore.presentation.action;

import com.ibatis.common.util.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class SearchProductsAction extends BaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    String keyword = request.getParameter("keyword");

    if (keyword == null || keyword.length() < 1) {
      String page = request.getParameter("page");
      PaginatedList results = (PaginatedList) request.getSession().getAttribute("searchResultsProductList");
      if (page == null || page.length() < 1) {
        request.setAttribute("message", "Please enter a keyword to search for, then press the search button.");
        return mapping.findForward("failure");
      } else {
        if ("next".equals(page)) {
          results.nextPage();
        } else if ("previous".equals(page)) {
          results.previousPage();
        }
        return mapping.findForward("success");
      }
    } else {

      PaginatedList productList = petStore.searchProductList(keyword.toLowerCase());

      request.getSession().setAttribute("searchResultsProductList", productList);

      return mapping.findForward("success");
    }

  }


}
